/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.ui.color.ColorGradient;

public class ColorGradientCanvas
extends Canvas {
    ColorGradient gradient;
    int style;

    public ColorGradientCanvas(Composite parent, int style) {
        super(parent, (style | 0x800) & 0xFFFFFCFF | 0x20000000);
        this.style = style & 0x300;
        this.addPaintListener(this.createPaintListener());
    }

    public void setGradient(ColorGradient gradient) {
        this.gradient = gradient;
        this.redraw();
    }

    protected PaintListener createPaintListener() {
        return new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle clip = gc.getClipping();
                ColorGradientCanvas.this.paintGradient(gc, clip);
            }
        };
    }

    protected void paintGradient(GC gc, Rectangle clip) {
        if (this.gradient != null) {
            Image image = this.gradient.getGradientImage(clip.width, clip.height, this.style);
            gc.drawImage(image, 0, 0);
            image.dispose();
        } else {
            gc.setBackground(Display.getCurrent().getSystemColor(1));
            gc.fillRectangle(clip);
        }
    }
}

