/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class SWTUtils {
    public static boolean asyncExec(Display display, Runnable runnable) {
        block3: {
            try {
                if (!display.isDisposed()) break block3;
                return false;
            }
            catch (SWTException sWTException) {
                return false;
            }
        }
        display.asyncExec(runnable);
        return true;
    }

    public static boolean asyncExec(Widget widget, Runnable runnable) {
        block3: {
            try {
                if (!widget.isDisposed()) break block3;
                return false;
            }
            catch (SWTException sWTException) {
                return false;
            }
        }
        widget.getDisplay().asyncExec(runnable);
        return true;
    }

    public static void invokeAndDispatchEvents(Display display, IThreadWorkQueue inThread, final Runnable invoke) throws InterruptedException {
        if (display.isDisposed()) {
            throw new IllegalArgumentException("display is disposed");
        }
        final Semaphore sem = new Semaphore(0);
        ThreadUtils.asyncExec((IThreadWorkQueue)inThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    invoke.run();
                }
                finally {
                    sem.release();
                }
            }
        });
        boolean done = false;
        while (!done) {
            done = sem.tryAcquire(10L, TimeUnit.MILLISECONDS);
            while (!done && display.readAndDispatch()) {
                done = sem.tryAcquire();
            }
        }
    }

    public static <T> T tryGetObject(Control control, ControlFilter<T> filter) {
        block11: {
            if (control == null || control.isDisposed()) {
                return null;
            }
            T t = filter.accept(control);
            if (t != null) {
                return t;
            }
            if (!(control instanceof Composite)) break block11;
            if (control instanceof TabFolder) {
                TabFolder tf = (TabFolder)control;
                TabItem[] tabItemArray = tf.getSelection();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    t = SWTUtils.tryGetObject(item.getControl(), filter);
                    if (t != null) {
                        return t;
                    }
                    ++n2;
                }
            } else if (control instanceof CTabFolder) {
                CTabFolder tf = (CTabFolder)control;
                CTabItem item = tf.getSelection();
                if (item != null && (t = SWTUtils.tryGetObject(item.getControl(), filter)) != null) {
                    return t;
                }
            } else {
                Composite c = (Composite)control;
                Control[] controlArray = c.getChildren();
                int n = controlArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Control child = controlArray[n3];
                    t = SWTUtils.tryGetObject(child, filter);
                    if (t != null) {
                        return t;
                    }
                    ++n3;
                }
            }
        }
        return null;
    }

    @FunctionalInterface
    public static interface ControlFilter<T> {
        public T accept(Control var1);
    }
}

