/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.operationsymbols;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.Shadow;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.g2d.utils.PathUtils;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.ObjectUtils;

public class OperationSymbols {
    static final double SHADOW_SIZE = 100.0;
    static final Color BORDER_COLOR = Color.GRAY;
    static final Color FILL_COLOR = Color.GRAY;
    static final Color SECONDARY_COLOR = Color.GREEN;
    static final Shadow.ShadowParameters SHADOW = new Shadow.ShadowParameters(0.5, Color.BLACK, 2);
    static final Color HOT = new Color(50, 50, 200);
    static final Color COLD = new Color(190, 190, 255);
    public static final BoilerHeatExchanger[] BOILER_HES = new BoilerHeatExchanger[]{new BoilerHeatExchanger(null, HOT, HOT, null, HOT), new BoilerHeatExchanger(HOT, null, COLD, COLD, HOT), new BoilerHeatExchanger(HOT, null, COLD, null, HOT), new BoilerHeatExchanger(HOT, null, null, HOT, HOT)};
    public static final Image BOILER_SYMBOL = new BoilerSymbol2(FILL_COLOR, FILL_COLOR, BOILER_HES);
    public static final Image BOILER_SHADOW = new Shadow(BOILER_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image COMPRESSOR_SYMBOL = new CompressorSymbol(FILL_COLOR, BORDER_COLOR);
    public static final Image COMPRESSOR_SHADOW = new Shadow(COMPRESSOR_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image NO_SPIN_SYMBOL = new NoSpinSymbol(FILL_COLOR, BORDER_COLOR);
    public static final Image NO_SPIN_SHADOW = new Shadow(NO_SPIN_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image CONTROLVALVE_SYMBOL = new ControlValveSymbol(BORDER_COLOR, FILL_COLOR);
    public static final Image CONTROLVALVE_SHADOW = new Shadow(CONTROLVALVE_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image THREEWAYVALVE_SYMBOL = new ThreeWayValveSymbol(BORDER_COLOR, FILL_COLOR);
    public static final Image THREEWAYVALVE_SHADOW = new Shadow(THREEWAYVALVE_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image HEATEXCHANGER_SYMBOL = new HeatExchangerSymbol(BORDER_COLOR, FILL_COLOR);
    public static final Image HEATEXCHANGER_SHADOW = new Shadow(HEATEXCHANGER_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image PUMP_SYMBOL = new PumpSymbol(BORDER_COLOR, FILL_COLOR);
    public static final Image PUMP_SHADOW = new Shadow(PUMP_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image SHUTOFFVALVE_SYMBOL = new ShutoffValveSymbol(BORDER_COLOR, FILL_COLOR);
    public static final Image SHUTOFFVALVE_SHADOW = new Shadow(SHUTOFFVALVE_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image SWITCH_SYMBOL = new SwitchSymbol(BORDER_COLOR);
    public static final Image SWITCH_SHADOW = new Shadow(SWITCH_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image TURBINE_SYMBOL = new TurbineSymbol(BORDER_COLOR, FILL_COLOR);
    public static final Image TURBINE_SHADOW = new Shadow(TURBINE_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image VOLTAGETRANSFORMER_SYMBOL = new VoltageTransformerSymbol(SECONDARY_COLOR, BORDER_COLOR);
    public static final Image VOLTAGETRANSFORMER_SHADOW = new Shadow(VOLTAGETRANSFORMER_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image CHIMNEY_SYMBOL = new ChimneySymbol(SECONDARY_COLOR, BORDER_COLOR);
    public static final Image CHIMNEY_SHADOW = new Shadow(CHIMNEY_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image GENERATOR_SYMBOL = new GeneratorSymbol(SECONDARY_COLOR, BORDER_COLOR);
    public static final Image GENERATOR_SHADOW = new Shadow(GENERATOR_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image TANK_SYMBOL = new TankSymbol(new Rectangle2D.Double(0.0, 0.0, 20.0, 8.0), 2.0, SECONDARY_COLOR, BORDER_COLOR);
    public static final Image TANK_SHADOW = new Shadow(TANK_SYMBOL, SHADOW, 100.0, 100.0);
    public static final Image TANK2_SYMBOL = new Tank2Symbol((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 20.0, 8.0), 2.0, SECONDARY_COLOR, BORDER_COLOR, HOT);
    public static final Image TANK2_SHADOW = new Shadow(TANK2_SYMBOL, SHADOW, 100.0, 100.0);

    public static class BoilerHeatExchanger {
        public final Color color;
        public final Color topLeft;
        public final Color topRight;
        public final Color bottomLeft;
        public final Color bottomRight;

        public BoilerHeatExchanger(Color topLeft, Color topRight, Color bottomLeft, Color bottomRight, Color color) {
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
            this.color = color;
            this.topLeft = topLeft;
            this.topRight = topRight;
        }
    }

    public static class BoilerSymbol
    extends PS
    implements Image {
        public static final int DIM = 10;
        public static final Polygon SHAPE;
        public static final Rectangle2D BOUNDS;

        static {
            int[] nArray = new int[6];
            nArray[0] = -10;
            nArray[1] = -10;
            nArray[3] = 10;
            nArray[4] = 10;
            SHAPE = new Polygon(nArray, new int[]{20, -20, -30, -20, 20, 30}, 6);
            BOUNDS = SHAPE.getBounds2D();
        }

        public BoilerSymbol(Color bc, Color fc) {
            super(SHAPE.getBounds2D(), bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
        }
    }

    public static class BoilerSymbol2
    extends PS
    implements Image {
        public static Path2D HE = PathUtils.path(10.0, 0.0, 0.0, 0.0, 0.0, 5.0, 5.0, 10.0, -5.0, 10.0, 0.0, 15.0, 0.0, 20.0);
        private final Shape shape;
        private final BoilerHeatExchanger[] hes;

        public static Rectangle2D getBoilerRect(BoilerHeatExchanger ... hes) {
            return new Rectangle2D.Double(-10.0, 0.0, 20.0, hes.length * 25 + 25);
        }

        public static Shape getBoilerShape(BoilerHeatExchanger ... hes) {
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(-10.0, 10.0);
            ((Path2D)p).lineTo(0.0, 0.0);
            ((Path2D)p).lineTo(10.0, 10.0);
            double h = hes.length * 25;
            ((Path2D)p).lineTo(10.0, h + 15.0);
            ((Path2D)p).lineTo(0.0, h + 25.0);
            ((Path2D)p).lineTo(-10.0, h + 15.0);
            p.closePath();
            return p;
        }

        public BoilerSymbol2(Color fc, Color bc, BoilerHeatExchanger ... hes) {
            super(BoilerSymbol2.getBoilerRect(hes), bc, fc, null, null);
            this.shape = BoilerSymbol2.getBoilerShape(hes);
            this.hes = hes;
        }

        @Override
        public void paint(Graphics2D g) {
            if (this.fc != null) {
                g.setColor(this.fc);
                g.fill(this.shape);
            }
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(this.shape);
            }
            g.translate(0, 15);
            BoilerHeatExchanger[] boilerHeatExchangerArray = this.hes;
            int n = this.hes.length;
            int n2 = 0;
            while (n2 < n) {
                BoilerHeatExchanger he = boilerHeatExchangerArray[n2];
                g.setColor(he.color);
                g.draw(HE);
                if (he.topLeft != null) {
                    g.setColor(he.topLeft);
                    g.drawLine(-10, 0, 0, 0);
                }
                if (he.topRight != null) {
                    g.setColor(he.topRight);
                    g.drawLine(0, 0, 10, 0);
                }
                if (he.bottomLeft != null) {
                    g.setColor(he.bottomLeft);
                    g.drawLine(-10, 20, 0, 20);
                }
                if (he.bottomRight != null) {
                    g.setColor(he.bottomRight);
                    g.drawLine(0, 20, 10, 20);
                }
                g.translate(0, 25);
                ++n2;
            }
        }
    }

    public static class ChimneySymbol
    extends PS
    implements Image {
        public static final int DIM = 10;
        public static final int D2 = 8;
        public static final Shape C1 = new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0);
        public static final Shape C2 = new Ellipse2D.Double(-8.0, -8.0, 16.0, 16.0);
        public static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10.0, -10.0, 20.0, 40.0);

        public ChimneySymbol(Color fc, Color bc) {
            super(BOUNDS, bc, fc, null, null);
            assert (bc != null);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(this.fc);
            g.fill(C2);
            g.fillRect(-5, 14, 10, 8);
            g.setColor(this.bc);
            g.draw(C1);
            g.draw(C2);
            g.drawLine(0, 10, 0, 15);
            g.drawRect(-5, 14, 10, 8);
            g.drawLine(-5, 14, 5, 22);
        }
    }

    public static class CompressorSymbol
    extends PS
    implements Image {
        public static final int DIM = 10;
        public static final Polygon SHAPE = new Polygon(new int[]{10, 10, -10, -10}, new int[]{-10, 10, 20, -20}, 4);
        public static final Rectangle2D BOUNDS = SHAPE.getBounds2D();

        public CompressorSymbol(Color bc, Color fc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            if (this.fc != null) {
                g.setColor(this.fc);
                g.fill(SHAPE);
            }
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(SHAPE);
            }
        }
    }

    public static class ControlValveSymbol
    extends PS
    implements Image {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int D = 10;
        public static final Path2D SHAPE = PathUtils.closedPath(-10.0, -10.0, -10.0, 10.0, 10.0, -10.0, 10.0, 10.0);
        public static final Rectangle2D BOUNDS = SHAPE.getBounds2D();

        public ControlValveSymbol(Color bc, Color fc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            if (this.fc != null) {
                g.setColor(this.fc);
                g.fill(SHAPE);
            }
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(SHAPE);
            }
        }
    }

    public static class GeneratorSymbol
    extends PS
    implements Image {
        public static final int DIM = 10;
        public static final Shape C1 = new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0);
        public static final Rectangle2D BOUNDS = C1.getBounds2D();
        private static final Font FONT = Font.decode("Serif-12");

        public GeneratorSymbol(Color fc, Color bc) {
            super(BOUNDS, bc, fc, null, null);
            assert (bc != null && fc != null);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(this.fc);
            g.fill(C1);
            g.setColor(this.bc);
            g.draw(C1);
            g.setFont(FONT);
            g.drawString("G", -4, 4);
        }
    }

    public static class HeatExchangerSymbol
    extends PS {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int D = 10;
        public static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);
        public static final int[] xPoints;
        public static final int[] yPoints;

        static {
            int[] nArray = new int[8];
            nArray[0] = -10;
            nArray[3] = -5;
            nArray[4] = 5;
            nArray[7] = 10;
            xPoints = nArray;
            int[] nArray2 = new int[8];
            nArray2[0] = 5;
            nArray2[1] = 5;
            nArray2[2] = 1;
            nArray2[5] = -1;
            nArray2[6] = -5;
            nArray2[7] = -5;
            yPoints = nArray2;
        }

        public HeatExchangerSymbol(Color bc, Color fc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(this.fc);
            g.fill(BOUNDS);
            g.setColor(this.bc);
            g.draw(BOUNDS);
            g.setStroke(STROKE);
            g.drawPolyline(xPoints, yPoints, xPoints.length);
        }
    }

    public static class NoSpinSymbol
    extends PS {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int DIM = 10;
        public static final int D2 = 8;
        public static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);
        public static final Shape CIRCLE = new Ellipse2D.Double(-8.0, -8.0, 16.0, 16.0);

        public NoSpinSymbol(Color fc, Color bc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setStroke(STROKE);
            g.setColor(this.fc);
            g.fillRect(-10, -10, 20, 20);
            g.setColor(this.bc);
            g.drawRect(-10, -10, 20, 20);
            g.draw(CIRCLE);
            g.drawLine(-3, -3, 3, 3);
            g.drawLine(3, -3, -3, 3);
        }
    }

    private static abstract class PS
    implements Image {
        public final Rectangle2D bounds;
        public final Color c1;
        public final Color c2;
        public final Color bc;
        public final Color fc;
        private final int hash;
        static EnumSet<Image.Feature> caps = EnumSet.of(Image.Feature.Vector);

        public PS(Rectangle2D bounds, Color bc, Color fc, Color c1, Color c2) {
            this.bounds = bounds;
            this.bc = bc;
            this.fc = fc;
            this.c1 = c1;
            this.c2 = c2;
            int hash = this.getClass().hashCode();
            if (bc != null) {
                hash += 3 * bc.hashCode();
            }
            if (fc != null) {
                hash += 5 * fc.hashCode();
            }
            if (c1 != null) {
                hash += 7 * c1.hashCode();
            }
            if (c2 != null) {
                hash += 11 * c2.hashCode();
            }
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            PS other = (PS)obj;
            return ObjectUtils.objectEquals((Object)other.c1, (Object)this.c1) && ObjectUtils.objectEquals((Object)other.c2, (Object)this.c2) && ObjectUtils.objectEquals((Object)other.fc, (Object)this.fc) && ObjectUtils.objectEquals((Object)other.bc, (Object)this.bc);
        }

        @Override
        public Rectangle2D getBounds() {
            return this.bounds;
        }

        @Override
        public Shape getOutline() {
            return this.bounds;
        }

        @Override
        public Node init(G2DParentNode g) {
            return null;
        }

        public void paint(Graphics2D g2d) {
        }

        @Override
        public void addImageListener(Image.ImageListener listener) {
        }

        @Override
        public EnumSet<Image.Feature> getFeatures() {
            return caps;
        }

        @Override
        public void removeImageListener(Image.ImageListener listener) {
        }
    }

    public static class PumpSymbol
    extends PS {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int DIM = 10;
        public static final int D2 = 12;
        public static final Rectangle2D BOUNDS = new Rectangle2D.Double(-12.0, -12.0, 24.0, 24.0);
        public static final Shape CIRCLE = new Ellipse2D.Double(-12.0, -12.0, 24.0, 24.0);
        public static final Polygon SHAPE;

        static {
            int[] nArray = new int[7];
            nArray[0] = -10;
            nArray[1] = -10;
            nArray[4] = 10;
            int[] nArray2 = new int[7];
            nArray2[0] = 2;
            nArray2[1] = -2;
            nArray2[2] = -2;
            nArray2[3] = -10;
            nArray2[5] = 10;
            nArray2[6] = 2;
            SHAPE = new Polygon(nArray, nArray2, 7);
        }

        public PumpSymbol(Color bc, Color fc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(this.fc);
            g.fill(CIRCLE);
            g.setColor(this.bc);
            g.setStroke(STROKE);
            g.draw(CIRCLE);
            g.draw(SHAPE);
        }
    }

    public static class ShutoffValveSymbol
    extends PS
    implements Image {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int DIM = 10;
        public static final Path2D SHAPE = PathUtils.closedPath(-10.0, -10.0, -10.0, 10.0, 10.0, -10.0, 10.0, 10.0);
        public static final Rectangle2D BOUNDS = SHAPE.getBounds2D();

        public ShutoffValveSymbol(Color bc, Color fc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            if (this.fc != null) {
                g.setColor(this.fc);
                g.fill(SHAPE);
            }
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(SHAPE);
                g.drawLine(0, -10, 0, 10);
            }
        }
    }

    public static class SwitchSymbol
    extends PS {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int D = 10;
        public static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);

        public SwitchSymbol(Color bc) {
            super(BOUNDS, bc, null, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(this.bc);
            g.setStroke(STROKE);
            g.drawLine(0, -10, 0, 10);
            g.drawLine(-2, -5, 2, -5);
            g.drawLine(-10, 0, 10, 0);
            g.drawLine(-2, 5, 2, 5);
        }
    }

    public static class Tank2Symbol
    extends PS
    implements Image {
        Path2D shape;
        Path2D shape2;

        public static Path2D createWShape() {
            Path2D.Double p = new Path2D.Double();
            double k = Math.sqrt(2.0);
            ((Path2D)p).moveTo(-1.0, -1.0);
            ((Path2D)p).quadTo(0.0, -k, 1.0, -1.0);
            ((Path2D)p).quadTo(k, 0.0, 1.0, 1.0);
            ((Path2D)p).quadTo(0.0, k, -1.0, 1.0);
            ((Path2D)p).quadTo(-k, 0.0, -1.0, -1.0);
            ((Path2D)p).lineTo(-1.0, 1.0);
            ((Path2D)p).lineTo(0.0, 0.0);
            ((Path2D)p).lineTo(1.0, 1.0);
            ((Path2D)p).lineTo(1.0, -1.0);
            return p;
        }

        public Tank2Symbol(Rectangle2D rect, double cap, Color bc, Color fc, Color a1) {
            super(rect, bc, fc, a1, null);
            this.shape = TankSymbol.createTankShape(rect, cap);
            this.shape2 = Tank2Symbol.createWShape();
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(this.fc);
            g.setStroke(GeometryUtils.BASIC_STROKE);
            g.setStroke(new BasicStroke(0.3f));
            g.fill(this.shape);
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(this.shape);
            }
            g.setColor(this.c1);
            double d = Math.min(this.bounds.getHeight(), this.bounds.getWidth());
            g.translate(this.bounds.getMinX() + d / 2.0, this.bounds.getMinY() + d / 2.0);
            g.scale(d / 3.0, d / 3.0);
            g.draw(this.shape2);
        }
    }

    public static class TankSymbol
    extends PS
    implements Image {
        Path2D shape;

        public static Path2D createTankShape(Rectangle2D r, double cap) {
            double x1 = r.getMinX();
            double y1 = r.getMinY();
            double x2 = r.getMaxX();
            double y2 = r.getMaxY();
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(x1 + cap, y1);
            ((Path2D)p).lineTo(x2 - cap, y1);
            ((Path2D)p).quadTo(x2, y1, x2, y1 + cap);
            ((Path2D)p).lineTo(x2, y2 - cap);
            ((Path2D)p).quadTo(x2, y2, x2 - cap, y2);
            ((Path2D)p).lineTo(x1 + cap, y2);
            ((Path2D)p).quadTo(x1, y2, x1, y2 - cap);
            ((Path2D)p).lineTo(x1, y1 + cap);
            ((Path2D)p).quadTo(x1, y1, x1 + cap, y1);
            return p;
        }

        public TankSymbol(Rectangle2D rect, double cap, Color bc, Color fc) {
            super(rect, bc, fc, null, null);
            this.shape = TankSymbol.createTankShape(rect, cap);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(this.fc);
            g.setStroke(GeometryUtils.BASIC_STROKE);
            g.fill(this.shape);
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(this.shape);
            }
        }
    }

    public static class ThreeWayValveSymbol
    extends PS
    implements Image {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int D = 10;
        public static final Path2D SHAPE = PathUtils.closedPath(-10.0, 6.0, -10.0, -6.0, 0.0, 0.0, -6.0, -10.0, 6.0, -10.0, 0.0, 0.0, 10.0, 6.0, 10.0, -6.0, 0.0, 0.0);
        public static final Rectangle2D BOUNDS = SHAPE.getBounds2D();

        public ThreeWayValveSymbol(Color bc, Color fc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            if (this.fc != null) {
                g.setColor(this.fc);
                g.fill(SHAPE);
            }
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(SHAPE);
            }
        }
    }

    public static class TurbineSymbol
    extends PS
    implements Image {
        public static final int DIM = 10;
        public static final Polygon SHAPE = new Polygon(new int[]{-10, -10, 10, 10}, new int[]{-10, 10, 20, -20}, 4);
        public static final Rectangle2D BOUNDS = SHAPE.getBounds2D();

        public TurbineSymbol(Color bc, Color fc) {
            super(BOUNDS, bc, fc, null, null);
        }

        @Override
        public void paint(Graphics2D g) {
            if (this.fc != null) {
                g.setColor(this.fc);
                g.fill(SHAPE);
            }
            if (this.bc != null) {
                g.setColor(this.bc);
                g.draw(SHAPE);
            }
        }
    }

    public static class VoltageTransformerSymbol
    extends PS
    implements Image {
        public static final Stroke STROKE = new BasicStroke(1.5f);
        public static final int DIM = 10;
        public static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10.0, -17.0, 20.0, 34.0);
        public static final Shape CIRCLE = new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0);

        public VoltageTransformerSymbol(Color c1, Color c2) {
            super(BOUNDS, null, null, c1, c2);
        }

        @Override
        public void paint(Graphics2D g) {
            g.setStroke(STROKE);
            Graphics2D sg = (Graphics2D)g.create();
            sg.clipRect(-20, -20, 40, 20);
            sg.setColor(this.c1);
            sg.translate(0.0, -7.0);
            sg.draw(CIRCLE);
            sg.setColor(this.c2);
            sg.translate(0.0, 14.0);
            sg.draw(CIRCLE);
            sg.dispose();
            g.clipRect(-20, 0, 40, 20);
            g.setColor(this.c2);
            g.translate(0.0, 7.0);
            g.draw(CIRCLE);
            g.setColor(this.c1);
            g.translate(0.0, -14.0);
            g.draw(CIRCLE);
        }
    }
}

