/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.RelationshipHandler;
import org.simantics.g2d.diagram.handler.TransactionContext;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementPainterConfiguration;
import org.simantics.g2d.diagram.participant.ElementTransferableProvider;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.ZOrderListener;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.Children;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.OutlineColorSpec;
import org.simantics.g2d.element.handler.Parent;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.SelectionOutline;
import org.simantics.g2d.element.handler.SelectionSpecification;
import org.simantics.g2d.element.handler.StrokeSpec;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.ElementNodeBridge;
import org.simantics.g2d.utils.TopologicalSelectionExpander;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.SelectionNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.TransferableProvider;
import org.simantics.scenegraph.g2d.nodes.UnboundedNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.utils.ColorUtil;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ElementPainter
extends AbstractDiagramParticipant
implements IDiagram.CompositionListener,
TransactionContext.TransactionListener,
Children.ChildListener {
    public static final IHintContext.Key KEY_SELECTION_PROVIDER = new IHintContext.KeyOf(ISelectionProvider.class);
    public static final int SELECTION_PAINT_PRIORITY = 100;
    public static final IHintContext.Key KEY_SELECTION_FRAME_COLOR = new IHintContext.KeyOf(Color.class, "SELECTION_FRAME_COLOR");
    public static final IHintContext.Key KEY_SELECTION_CONTENT_COLOR = new IHintContext.KeyOf(Color.class, "SELECTION_CONTENT_COLOR");
    private static final boolean DEBUG = false;
    private static final boolean NODE_TO_ELEMENT_MAPPING = true;
    public static final int ELEMENT_PAINT_PRIORITY = 10;
    @DependencyReflection.Reference
    ZOrderHandler zOrderHandler;
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    Selection selection;
    SingleElementNode diagramParent;
    RTreeNode elementParent;
    ElementPainterConfiguration cfg;
    private transient List<RelationshipHandler.Relation> relations = new ArrayList<RelationshipHandler.Relation>(4);
    private transient Set<IElement> relatedElements = new HashSet<IElement>(8);
    ZOrderListener zOrderListener = new ZOrderListener(){

        @Override
        public void orderChanged(IDiagram diagram) {
            if (diagram == ElementPainter.this.diagram) {
                ElementPainter.updateZOrder(diagram, ElementHints.KEY_SG_NODE);
            }
        }
    };
    ILayersEditor.ILayersEditorListener layersListener = new ILayersEditor.ILayersEditorListener(){

        private void layersChanged() {
            Object task = ElementPainter.BEGIN("EP.layersChanged");
            ElementPainter.this.updateAllVisibility();
            ElementPainter.END(task);
        }

        @Override
        public void layerRemoved(ILayer layer) {
            this.layersChanged();
        }

        @Override
        public void layerDeactivated(ILayer layer) {
            this.layersChanged();
        }

        @Override
        public void layerAdded(ILayer layer) {
            this.layersChanged();
        }

        @Override
        public void layerActivated(ILayer layer) {
            this.layersChanged();
        }

        @Override
        public void ignoreFocusChanged(boolean value) {
            ICanvasContext ctx = ElementPainter.this.getContext();
            if (ctx == null) {
                return;
            }
            G2DSceneGraph sg = ctx.getSceneGraph();
            if (sg == null) {
                return;
            }
            sg.setGlobalProperty("ignoreFocus", (Object)value);
        }

        @Override
        public void ignoreVisibilityChanged(boolean value) {
            this.layersChanged();
        }
    };
    private final DiagramHintListener diagramHintListener = new DiagramHintListener();
    private final ElementHintListener elementHintListener = new ElementHintListener();
    private final Set<TransactionContext.Transaction> activeTransactions = new HashSet<TransactionContext.Transaction>();
    Consumer<IElement> COMPLETE_UPDATE = element -> {
        if (element.getElementClass().containsClass(ConnectionHandler.class)) {
            DiagramUtils.validateAndFix(this.diagram, Collections.singleton(element));
        }
        this.update((IElement)element);
        this.updateSelection((IElement)element);
    };
    private final List<IElement> childrenTemp = new ArrayList<IElement>();
    private transient CharBuffer buf = CharBuffer.allocate(32);
    private transient ConcurrentMap<Integer, ElementNodeBridge> selections = new ConcurrentHashMap<Integer, ElementNodeBridge>();
    private transient Map<Integer, Color> selectionColor = new HashMap<Integer, Color>();
    private transient BasicStroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private transient Point2D pivotPoint = new Point2D.Double();

    public ElementPainter() {
        this(true);
    }

    public ElementPainter(boolean paintSelectionFrames) {
        this(new ElementPainterConfiguration().paintSelectionFrames(paintSelectionFrames));
    }

    public ElementPainter(ElementPainterConfiguration cfg) {
        this.cfg = cfg;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        if (this.zOrderHandler != null) {
            this.zOrderHandler.addOrderListener(this.zOrderListener);
        }
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        if (this.zOrderHandler != null) {
            this.zOrderHandler.removeOrderListener(this.zOrderListener);
        }
        this.selections.clear();
        super.removedFromContext(ctx);
    }

    @Override
    protected void onDiagramSet(IDiagram newValue, IDiagram oldValue) {
        ILayersEditor layers;
        if (oldValue == newValue) {
            return;
        }
        if (oldValue != null) {
            Map nodeToElementMap = (Map)oldValue.removeHint(DiagramHints.NODE_TO_ELEMENT_MAP);
            for (IElement e : oldValue.getElements()) {
                this.removeElement(oldValue, e, nodeToElementMap);
            }
            oldValue.removeCompositionListener(this);
            oldValue.removeKeyHintListener(Hints.KEY_DIRTY, (IHintListener)this.diagramHintListener);
            oldValue.removeKeyHintListener(Hints.KEY_DISABLE_PAINTING, (IHintListener)this.diagramHintListener);
            layers = (ILayersEditor)oldValue.getHint(DiagramHints.KEY_LAYERS_EDITOR);
            if (layers != null) {
                layers.removeListener(this.layersListener);
            }
            for (TransactionContext transactionContext : oldValue.getDiagramClass().getItemsByClass(TransactionContext.class)) {
                transactionContext.removeTransactionListener(oldValue, this);
            }
        }
        if (newValue != null) {
            this.diagram.removeHint(DiagramHints.NODE_TO_ELEMENT_MAP);
            HashMap<INode, IElement> nodeElementMap = new HashMap<INode, IElement>();
            if (nodeElementMap != null) {
                this.diagram.setHint(DiagramHints.NODE_TO_ELEMENT_MAP, nodeElementMap);
            }
            for (IElement e : newValue.getElements()) {
                this.addElement(newValue, e, false, nodeElementMap);
            }
            newValue.addCompositionListener(this);
            newValue.addKeyHintListener(Hints.KEY_DISABLE_PAINTING, (IHintListener)this.diagramHintListener);
            newValue.addKeyHintListener(Hints.KEY_DIRTY, (IHintListener)this.diagramHintListener);
            layers = (ILayersEditor)newValue.getHint(DiagramHints.KEY_LAYERS_EDITOR);
            if (layers != null) {
                layers.addListener(this.layersListener);
            }
            for (TransactionContext transactionContext : newValue.getDiagramClass().getItemsByClass(TransactionContext.class)) {
                transactionContext.addTransactionListener(newValue, this);
            }
        }
        this.updateAll();
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.diagramParent = (SingleElementNode)parent.addNode("elements_" + Node.IDCOUNTER, UnboundedNode.class);
        this.diagramParent.setZIndex(10);
        this.elementParent = (RTreeNode)this.diagramParent.addNode("spatialRoot", RTreeNode.class);
        this.elementParent.setLookupId("spatialRoot");
        this.elementParent.setZIndex(0);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.diagramParent.remove();
        this.elementParent = null;
        this.diagramParent = null;
    }

    public INode getDiagramElementParentNode() {
        return this.elementParent;
    }

    protected static void updateZOrder(IDiagram diagram, IHintContext.Key elementSgNodeKey) {
        int zIndex = 0;
        for (IElement e : diagram.getElements()) {
            Node node = (Node)e.getHint(elementSgNodeKey);
            if (!(node instanceof IG2DNode)) continue;
            ((IG2DNode)node).setZIndex(++zIndex);
        }
    }

    protected void updateAllVisibility() {
        this.updateAll();
    }

    @Override
    public void transactionStarted(IDiagram d, TransactionContext.Transaction t) {
        this.activeTransactions.add(t);
    }

    Set<IElement> addRelatedElements(Set<IElement> elements) {
        RelationshipHandler rh = this.diagram.getDiagramClass().getAtMostOneItemOfClass(RelationshipHandler.class);
        if (rh != null) {
            this.relatedElements.clear();
            for (IElement el : elements) {
                this.relations.clear();
                rh.getRelations(this.diagram, el, this.relations);
                for (RelationshipHandler.Relation r : this.relations) {
                    Object obj = r.getObject();
                    if (!(obj instanceof IElement)) continue;
                    this.relatedElements.add((IElement)obj);
                }
                this.relations.clear();
            }
            elements.addAll(this.relatedElements);
            this.relatedElements.clear();
        }
        return elements;
    }

    protected void updateSelfAndNeighbors(IElement e, Consumer<IElement> updateCallback) {
        if (!this.isNotSelectionExpandable(e)) {
            Set<IElement> single = Collections.singleton(e);
            Set<IElement> expanded = this.addRelatedElements(CollectionUtils.join(single, TopologicalSelectionExpander.expandSelection(this.diagram, single)));
            for (IElement el : expanded) {
                updateCallback.accept(el);
            }
        } else {
            updateCallback.accept(e);
        }
    }

    protected boolean isNotSelectionExpandable(IElement e) {
        ElementClass ec = e.getElementClass();
        return !ec.containsClass(ConnectionHandler.class) && !ec.containsClass(BendsHandler.class) && !ec.containsClass(TerminalTopology.class);
    }

    @Override
    public void transactionFinished(IDiagram d, TransactionContext.Transaction t) {
        this.activeTransactions.remove(t);
    }

    boolean inDiagramTransaction() {
        return !this.activeTransactions.isEmpty();
    }

    @Override
    public void onElementAdded(IDiagram d, IElement e) {
        Map nodeElementMap = (Map)this.diagram.getHint(DiagramHints.NODE_TO_ELEMENT_MAP);
        if (this.inDiagramTransaction()) {
            this.addElement(d, e, false, nodeElementMap);
        } else {
            this.addElement(d, e, true, nodeElementMap);
        }
    }

    @Override
    public void onElementRemoved(IDiagram d, IElement e) {
        this.removeElement(d, e, (Map)this.diagram.getHint(DiagramHints.NODE_TO_ELEMENT_MAP));
    }

    @Override
    public void elementChildrenChanged(Children.ChildEvent event) {
        Map nodeElementMap = (Map)this.diagram.getHint(DiagramHints.NODE_TO_ELEMENT_MAP);
        for (IElement removed : event.removed) {
            this.removeElement(this.diagram, removed, nodeElementMap);
        }
        for (IElement added : event.added) {
            this.addElement(this.diagram, added, false, nodeElementMap);
        }
    }

    public void addElement(IDiagram d, IElement e, boolean synchronizeSceneGraphNow, Map<INode, IElement> nodeElementMap) {
        Children children;
        ConnectionNode holder;
        boolean isConnection;
        SingleElementNode parentHolder;
        IElement parentElement;
        e.addKeyHintListener(Hints.KEY_DIRTY, this.elementHintListener);
        e.addKeyHintListener(ElementHints.KEY_VISIBLE_LAYERS, this.elementHintListener);
        e.addKeyHintListener(ElementHints.KEY_FOCUS_LAYERS, this.elementHintListener);
        ElementClass clazz = e.getElementClass();
        RTreeNode parentNode = this.elementParent;
        IHintContext.Key sgKey = ElementHints.KEY_SG_NODE;
        Parent parent = clazz.getAtMostOneItemOfClass(Parent.class);
        if (parent != null && (parentElement = parent.getParent(e)) != null && (parentHolder = (SingleElementNode)parentElement.getHint(sgKey)) != null) {
            parentNode = parentHolder;
        }
        if (isConnection = e.getElementClass().containsClass(ConnectionHandler.class)) {
            holder = (ConnectionNode)e.getHint(sgKey);
            if (holder == null) {
                holder = (ConnectionNode)parentNode.addNode(ElementUtils.generateNodeId(e), ConnectionNode.class);
                holder.setKey(e.getHint(ElementHints.KEY_OBJECT));
                holder.setTypeClass((String)e.getHint(ElementHints.KEY_TYPE_CLASS));
                holder.setTransferableProvider((TransferableProvider)new ElementTransferableProvider(this.getContext(), e));
                e.setHint(sgKey, holder);
                holder.setZIndex(parentNode.getNodeCount() + 1);
                if (nodeElementMap != null) {
                    nodeElementMap.put((INode)holder, e);
                }
            }
        } else {
            holder = (SingleElementNode)e.getHint(sgKey);
            if (holder == null) {
                holder = (SingleElementNode)parentNode.addNode(ElementUtils.generateNodeId(e), SingleElementNode.class);
                holder.setKey(e.getHint(ElementHints.KEY_OBJECT));
                holder.setTypeClass((String)e.getHint(ElementHints.KEY_TYPE_CLASS));
                holder.setTransferableProvider((TransferableProvider)new ElementTransferableProvider(this.getContext(), e));
                e.setHint(sgKey, holder);
                holder.setZIndex(parentNode.getNodeCount() + 1);
                if (nodeElementMap != null) {
                    nodeElementMap.put((INode)holder, e);
                }
            }
        }
        if ((children = clazz.getAtMostOneItemOfClass(Children.class)) != null) {
            children.addChildListener(e, this);
            this.childrenTemp.clear();
            children.getChildren(e, this.childrenTemp);
            for (IElement child : this.childrenTemp) {
                this.addElement(d, child, false, nodeElementMap);
            }
            this.childrenTemp.clear();
        }
        if (synchronizeSceneGraphNow) {
            this.updateElement(e, sgKey);
        }
    }

    protected void removeElement(IDiagram d, IElement e, Map<INode, IElement> nodeElementMap) {
        e.removeKeyHintListener(Hints.KEY_DIRTY, this.elementHintListener);
        e.removeKeyHintListener(ElementHints.KEY_VISIBLE_LAYERS, this.elementHintListener);
        e.removeKeyHintListener(ElementHints.KEY_FOCUS_LAYERS, this.elementHintListener);
        ElementClass clazz = e.getElementClass();
        if (clazz.containsClass(Children.class)) {
            Children children = clazz.getSingleItem(Children.class);
            children.removeChildListener(e, this);
        }
        List<SceneGraph> nodeHandlers = e.getElementClass().getItemsByClass(SceneGraph.class);
        for (SceneGraph n : nodeHandlers) {
            n.cleanup(e);
        }
        Map sgHints = e.getHintsOfClass(SceneGraphNodeKey.class);
        for (SceneGraphNodeKey sgKey : sgHints.keySet()) {
            Node n = (Node)e.removeHint((IHintContext.Key)sgKey);
            if (n == null) continue;
            n.remove();
            if (nodeElementMap == null) continue;
            nodeElementMap.remove(n);
        }
    }

    private void setTreeDirty() {
        this.elementParent.setDirty();
    }

    private void invalidateNode(INode node) {
        this.elementParent.setDirty();
    }

    public void updateAll() {
        Object task = ElementPainter.BEGIN("EP.updateAll");
        this.paintDiagram((G2DParentNode)this.elementParent, this.diagram, null);
        this.updateSelections();
        this.setTreeDirty();
        ElementPainter.END(task);
    }

    public void update(IElement element) {
        this.updateElement(element, ElementHints.KEY_SG_NODE);
    }

    public void paintDiagram(G2DParentNode parent, IDiagram diagram, Collection<IElement> elementsToPaint) {
        Object task = ElementPainter.BEGIN("EP.paintDiagram");
        this.paintDiagram(parent, diagram, elementsToPaint, ElementHints.KEY_SG_NODE);
        ElementPainter.END(task);
    }

    public void paintDiagram(G2DParentNode parent, IDiagram diagram, Collection<IElement> elementsToPaint, IHintContext.Key elementSgNodeKey) {
        if (diagram == null) {
            return;
        }
        ICanvasContext ctx = this.getContext();
        assert (ctx != null);
        Boolean disablePaint = (Boolean)diagram.getHint(Hints.KEY_DISABLE_PAINTING);
        if (Boolean.TRUE.equals(disablePaint)) {
            parent.removeNodes();
            return;
        }
        List<IElement> elements = diagram.getSnapshot();
        HashSet<SingleElementNode> tmp = new HashSet<SingleElementNode>();
        int zIndex = 0;
        int pass = 0;
        while (pass < 1) {
            for (IElement e : elements) {
                SingleElementNode holder;
                if (elements != elementsToPaint && elementsToPaint != null && !elementsToPaint.contains(e) || (holder = this.updateElement(parent, e, elementSgNodeKey, false)) == null) continue;
                tmp.add(holder);
                holder.setZIndex(++zIndex);
            }
            ++pass;
        }
        for (IG2DNode node : parent.getNodes()) {
            if (tmp.contains(node)) continue;
            ((SingleElementNode)node).setVisible(Boolean.valueOf(false));
        }
    }

    public void updateElement(IElement e, IHintContext.Key elementSgNodeKey) {
        this.updateElement(null, e, elementSgNodeKey, true);
    }

    public SingleElementNode updateElement(G2DParentNode parent, IElement e, IHintContext.Key elementSgNodeKey, boolean invalidateNode) {
        Object task = ElementPainter.BEGIN("EP.updateElement");
        try {
            SingleElementNode holder = (SingleElementNode)e.getHint(elementSgNodeKey);
            if (holder == null && parent == null) {
                return null;
            }
            if (ElementUtils.isHidden(e)) {
                return null;
            }
            List<SceneGraph> nodeHandlers = e.getElementClass().getItemsByClass(SceneGraph.class);
            Collection decorators = (Collection)e.getHint(ElementHints.KEY_DECORATORS);
            if (nodeHandlers.isEmpty() && (decorators == null || decorators.isEmpty())) {
                return null;
            }
            Composite composite = (Composite)e.getHint(ElementHints.KEY_COMPOSITE);
            if (holder == null) {
                holder = (SingleElementNode)parent.addNode(ElementUtils.generateNodeId(e), SingleElementNode.class);
                e.setHint(elementSgNodeKey, holder);
            }
            holder.setComposite(composite);
            holder.setVisible(Boolean.valueOf(true));
            for (SceneGraph n : nodeHandlers) {
                n.init(e, (G2DParentNode)holder);
            }
            if (decorators == null || decorators.isEmpty()) {
                holder.removeNode("decorators");
            } else {
                G2DParentNode decoratorHolder = (G2DParentNode)holder.getOrCreateNode("decorators", G2DParentNode.class);
                decoratorHolder.removeNodes();
                for (SceneGraph decorator : decorators) {
                    decorator.init(e, decoratorHolder);
                }
            }
            if (invalidateNode) {
                this.invalidateNode((INode)holder);
            }
            SingleElementNode singleElementNode = holder;
            return singleElementNode;
        }
        finally {
            ElementPainter.END(task);
        }
    }

    public void updateSelections() {
        Object task = ElementPainter.BEGIN("EP.updateSelections");
        try {
            Integer selectionId;
            if (!this.cfg.paintSelectionFrames) {
                return;
            }
            if (this.selection == null) {
                return;
            }
            boolean selectionsChanged = false;
            HashSet<Integer> existingSelections = new HashSet<Integer>();
            HashSet<INode> selectionNodes = new HashSet<INode>();
            HashSet tmp = new HashSet();
            HashMap<INode, LinkNode> selectionLinks = new HashMap<INode, LinkNode>();
            for (Map.Entry<Integer, Set<IElement>> entry : this.selection.getSelections().entrySet()) {
                selectionId = entry.getKey();
                Set<IElement> selectedElements = entry.getValue();
                existingSelections.add(selectionId);
                ElementNodeBridge bridge = this.getOrCreateSelectionMap(selectionId);
                selectionNodes.clear();
                selectionsChanged |= this.paintSelection(selectedElements, selectionId, selectionNodes, bridge);
                tmp.clear();
                tmp.addAll(bridge.getRightSet());
                tmp.removeAll(selectionNodes);
                selectionsChanged |= bridge.retainAllRight(selectionNodes);
                G2DParentNode selectionsNode = this.getSelectionsNode(selectionId);
                selectionLinks.clear();
                this.getSelectedNodeReferences(selectionsNode, selectionLinks);
                for (INode node : tmp) {
                    INode linkNode = (INode)selectionLinks.get(node.getParent());
                    if (linkNode != null) {
                        linkNode.remove();
                    }
                    node.remove();
                }
            }
            Iterator iterator = this.selections.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                selectionId = (Integer)entry.getKey();
                if (existingSelections.contains(selectionId)) continue;
                selectionsChanged = true;
                for (INode node : ((ElementNodeBridge)((Object)entry.getValue())).getRightSet()) {
                    node.remove();
                }
                iterator.remove();
                G2DParentNode selectionsNode = this.getSelectionsNode(selectionId);
                selectionsNode.removeNodes();
            }
            if (selectionsChanged) {
                this.setDirty();
            }
        }
        finally {
            ElementPainter.END(task);
        }
    }

    private G2DParentNode getSelectionsNode() {
        G2DParentNode sels = (G2DParentNode)NodeUtil.lookup((INode)this.diagramParent, (String)"selections", G2DParentNode.class);
        if (sels == null) {
            DataNode data = (DataNode)NodeUtil.lookup((INode)this.diagramParent, (String)"data", DataNode.class);
            sels = (G2DParentNode)data.addNode("selections", G2DParentNode.class);
            sels.setLookupId("selections");
        }
        return sels;
    }

    private G2DParentNode getSelectionsNode(int selectionId) {
        G2DParentNode selectionsNode = this.getSelectionsNode();
        G2DParentNode s = (G2DParentNode)selectionsNode.getOrCreateNode(String.valueOf(selectionId), G2DParentNode.class);
        return s;
    }

    private Map<INode, LinkNode> getSelectedNodeReferences(G2DParentNode selectionsNode, Map<INode, LinkNode> result) {
        IG2DNode[] iG2DNodeArray = selectionsNode.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode n3;
            IG2DNode node = iG2DNodeArray[n2];
            if (node instanceof LinkNode && (n3 = ((LinkNode)node).getDelegate()) != null) {
                result.put(n3, (LinkNode)node);
            }
            ++n2;
        }
        return result;
    }

    public void updateSelection(IElement el) {
        Object task = ElementPainter.BEGIN("EP.updateSelection");
        try {
            if (!this.cfg.paintSelectionFrames) {
                return;
            }
            G2DParentNode elementNode = (G2DParentNode)el.getHint(ElementHints.KEY_SG_NODE);
            if (elementNode == null) {
                return;
            }
            boolean nodesUpdated = false;
            for (Map.Entry entry : this.selections.entrySet()) {
                Integer selectionId = (Integer)entry.getKey();
                ElementNodeBridge bridge = (ElementNodeBridge)((Object)entry.getValue());
                Color color = this.getSelectionColor(selectionId);
                G2DParentNode selectionNode = (G2DParentNode)bridge.getRight(el);
                if (selectionNode == null) continue;
                if (NodeUtil.needSelectionPaint((INode)elementNode)) {
                    this.paintSelectionFrame(elementNode, selectionNode, el, color);
                }
                nodesUpdated = true;
            }
            if (nodesUpdated) {
                this.setDirty();
            }
        }
        finally {
            ElementPainter.END(task);
        }
    }

    public boolean paintSelection(Set<IElement> selection, int selectionId, Set<INode> selectionNodes, ElementNodeBridge bridge) {
        boolean result = false;
        Color color = this.getSelectionColor(selectionId);
        G2DParentNode selectionsNode = this.getSelectionsNode(selectionId);
        Class<G2DParentNode> selectionNodeClass = this.cfg.selectionNodeClass != null ? this.cfg.selectionNodeClass : G2DParentNode.class;
        for (IElement e : selection) {
            Node elementNode = (Node)e.getHint(ElementHints.KEY_SG_NODE);
            if (elementNode instanceof G2DParentNode) {
                G2DParentNode en = (G2DParentNode)elementNode;
                G2DParentNode selectionNode = (G2DParentNode)en.getOrCreateNode("selection", selectionNodeClass);
                selectionNode.setZIndex(100);
                if (selectionNodes != null) {
                    selectionNodes.add((INode)selectionNode);
                }
                if (!bridge.containsLeft(e)) {
                    bridge.map(e, selectionNode);
                    result = true;
                }
                this.createSelectionReference(selectionsNode, (INode)elementNode);
                if (!NodeUtil.needSelectionPaint((INode)elementNode)) continue;
                this.paintSelectionFrame(en, selectionNode, e, color);
                continue;
            }
            if (elementNode == null) continue;
            System.out.println("Cannot add selection child node for non-parent element node: " + elementNode);
        }
        return result;
    }

    public void paintSelectionFrame(G2DParentNode elementNode, G2DParentNode selectionNode, IElement e, Color color) {
        AffineTransform selectionTransform = ElementUtils.getTransform(e);
        Shape shape = ElementUtils.getElementShapeOrBounds(e);
        Rectangle2D bounds = shape.getBounds2D();
        Point2D scale = GeometryUtils.getScale2D((AffineTransform)selectionTransform);
        double marginX = Math.abs(scale.getX()) > 1.0E-10 ? 1.0 / scale.getX() : 1.0;
        double marginY = Math.abs(scale.getY()) > 1.0E-10 ? 1.0 / scale.getY() : 1.0;
        bounds.setFrame(bounds.getMinX() - marginX, bounds.getMinY() - marginY, bounds.getWidth() + 2.0 * marginX, bounds.getHeight() + 2.0 * marginY);
        List<SelectionSpecification> ss = e.getElementClass().getItemsByClass(SelectionSpecification.class);
        if (!ss.isEmpty()) {
            G2DParentNode shapeholder = (G2DParentNode)selectionNode.getOrCreateNode(this.getNodeId("outlines", e), G2DParentNode.class);
            for (SelectionSpecification es : ss) {
                Transform transform;
                Outline outline = (Outline)es.getAdapter(Outline.class);
                if (outline == null || outline.getElementShape(e) == null) continue;
                ShapeNode shapenode = (ShapeNode)shapeholder.getOrCreateNode(this.getNodeId("outline", e, es), ShapeNode.class);
                shapenode.setShape(outline.getElementShape(e));
                StrokeSpec strokeSpec = (StrokeSpec)es.getAdapter(StrokeSpec.class);
                if (strokeSpec != null && strokeSpec.getStroke(e) != null) {
                    shapenode.setStroke(strokeSpec.getStroke(e));
                }
                shapenode.setScaleStroke(false);
                OutlineColorSpec foregroundColor = (OutlineColorSpec)es.getAdapter(OutlineColorSpec.class);
                if (foregroundColor != null && foregroundColor.getColor(e) != null) {
                    shapenode.setColor((Paint)foregroundColor.getColor(e));
                }
                if ((transform = (Transform)es.getAdapter(Transform.class)) != null && transform.getTransform(e) != null) {
                    shapenode.setTransform(transform.getTransform(e));
                }
                shapenode.setFill(false);
                FillColor fillColor = (FillColor)es.getAdapter(FillColor.class);
                if (fillColor == null || fillColor.getFillColor(e) == null) continue;
                shapenode.setFill(true);
            }
            return;
        }
        List<SelectionOutline> shapeHandlers = e.getElementClass().getItemsByClass(SelectionOutline.class);
        if (!shapeHandlers.isEmpty()) {
            G2DParentNode shapeholder = (G2DParentNode)selectionNode.getOrCreateNode(this.getNodeId("outlines", e), G2DParentNode.class);
            for (SelectionOutline es : shapeHandlers) {
                ShapeNode shapenode = (ShapeNode)shapeholder.getOrCreateNode(this.getNodeId("outline", e, es), ShapeNode.class);
                shapenode.setShape(es.getSelectionShape(e));
                shapenode.setStroke(null);
                shapenode.setScaleStroke(false);
                shapenode.setColor((Paint)ColorUtil.withAlpha((Color)color, (int)192));
                shapenode.setTransform(selectionTransform);
                shapenode.setFill(true);
            }
            return;
        }
        ISelectionProvider provider = (ISelectionProvider)this.getContext().getDefaultHintContext().getHint(KEY_SELECTION_PROVIDER);
        if (provider != null) {
            provider.init(e, selectionNode, this.getNodeId("shape", e), selectionTransform, bounds, color);
        } else {
            SelectionNode s = (SelectionNode)selectionNode.getOrCreateNode(this.getNodeId("shape", e), SelectionNode.class);
            s.init(selectionTransform, bounds, color);
            Double paddingFactor = (Double)this.diagram.getHint(DiagramHints.SELECTION_PADDING_SCALE_FACTOR);
            if (paddingFactor != null) {
                s.setPaddingFactor(paddingFactor.doubleValue());
            }
        }
    }

    private void createSelectionReference(G2DParentNode selectionsNode, INode elementNode) {
        String id = NodeUtil.lookupId((INode)elementNode);
        String uuid = null;
        if (id == null) {
            id = uuid = UUID.randomUUID().toString();
        }
        NodeUtil.map((INode)elementNode, (String)id);
        LinkNode link = (LinkNode)selectionsNode.getOrCreateNode(id, LinkNode.class);
        link.setDelegateId(id);
        link.setIgnoreDelegate(true);
        link.setLookupIdOwner(uuid != null);
    }

    private String getNodeId(String prefix, Object first) {
        return this.getNodeId(prefix, first, null);
    }

    private String getNodeId(String prefix, Object first, Object second) {
        this.buf.clear();
        if (prefix != null) {
            this.buf.append(prefix);
        }
        if (first != null) {
            this.buf.append('_');
            this.buf.append("" + first.hashCode());
        }
        if (second != null) {
            this.buf.append('_');
            this.buf.append("" + second.hashCode());
        }
        this.buf.limit(this.buf.position());
        this.buf.rewind();
        return this.buf.toString();
    }

    protected Color getSelectionColor(int selectionId) {
        if (selectionId == 0) {
            Color c = (Color)this.getHint(KEY_SELECTION_FRAME_COLOR);
            if (c != null) {
                return c;
            }
            return Color.BLACK;
        }
        Color c = this.selectionColor.get(selectionId);
        if (c == null) {
            Random r = new Random(selectionId);
            c = new Color(r.nextFloat(), r.nextFloat(), r.nextFloat());
            this.selectionColor.put(selectionId, c);
        }
        return c;
    }

    ElementNodeBridge getSelectionMap(int selectionId) {
        return (ElementNodeBridge)((Object)this.selections.get(selectionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ElementNodeBridge getOrCreateSelectionMap(int selectionId) {
        Integer id = selectionId;
        ConcurrentMap<Integer, ElementNodeBridge> concurrentMap = this.selections;
        synchronized (concurrentMap) {
            ElementNodeBridge map = (ElementNodeBridge)((Object)this.selections.get(id));
            if (map != null) {
                return map;
            }
            map = new ElementNodeBridge(id);
            this.selections.put(id, map);
            return map;
        }
    }

    @HintReflection.HintListener(Class=Selection.class, Field="SELECTION0")
    public void selectionChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        this.updateSelections();
    }

    @HintReflection.HintListener(Class=Selection.class, Field="SELECTION0")
    public void selectionRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        this.updateSelections();
    }

    private static Object BEGIN(String name) {
        return null;
    }

    private static void END(Object task) {
    }

    class DiagramHintListener
    extends HintListenerAdapter {
        DiagramHintListener() {
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == Hints.KEY_DISABLE_PAINTING) {
                if (ElementPainter.this.diagramParent != null) {
                    ElementPainter.this.diagramParent.setVisible(Boolean.valueOf(!Boolean.TRUE.equals(newValue)));
                }
            } else if (key == Hints.KEY_DIRTY && newValue == Hints.VALUE_Z_ORDER_CHANGED) {
                ElementPainter.this.diagram.removeHint(Hints.KEY_DIRTY);
                ElementPainter.updateZOrder(ElementPainter.this.diagram, ElementHints.KEY_SG_NODE);
            }
        }
    }

    class ElementHintListener
    implements IHintListener {
        ElementHintListener() {
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == Hints.KEY_DIRTY) {
                if (newValue == Hints.VALUE_SG_DIRTY && sender instanceof IElement) {
                    assert (ElementPainter.this.getContext().getThreadAccess().currentThreadAccess());
                    Object task = ElementPainter.BEGIN("element dirty");
                    IElement e = (IElement)sender;
                    e.removeHint(Hints.KEY_DIRTY);
                    ElementPainter.this.updateSelfAndNeighbors(e, ElementPainter.this.COMPLETE_UPDATE);
                    ElementPainter.END(task);
                }
            } else if ((key == ElementHints.KEY_FOCUS_LAYERS || key == ElementHints.KEY_VISIBLE_LAYERS) && sender instanceof IElement) {
                assert (ElementPainter.this.getContext().getThreadAccess().currentThreadAccess());
                IElement e = (IElement)sender;
                Object task = ElementPainter.BEGIN("layers changed: " + e);
                ElementPainter.this.update(e);
                ElementPainter.END(task);
            }
        }

        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        }
    }

    public static interface ISelectionProvider {
        public void init(IElement var1, G2DParentNode var2, String var3, AffineTransform var4, Rectangle2D var5, Color var6);
    }
}

