/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DPDFRenderingHints;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.utils.GeometryUtils;

public class FlagNode
extends G2DNode {
    private static final long serialVersionUID = -1716729504104107151L;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final byte LEADING = 0;
    private static final byte TRAILING = 1;
    private static final byte CENTER = 2;
    private static final boolean DEBUG = false;
    private static final double GLOBAL_SCALE = 0.1;
    private static final double TEXT_MARGIN = 5.0;
    static final transient BasicStroke STROKE = new BasicStroke(0.25f, 0, 0);
    public static final Font DEFAULT_FONT = Font.decode("Arial 12");
    protected boolean visible;
    protected Shape flagShape;
    protected String[] flagText;
    protected Stroke stroke;
    protected Color border;
    protected Color fill;
    protected Color textColor;
    protected float width;
    protected float height;
    protected double direction;
    protected float beakAngle;
    protected Rectangle2D textArea;
    protected byte hAlign;
    protected byte vAlign;
    protected Font font = DEFAULT_FONT;
    private final transient Point2D origin = new Point2D.Double();
    private final transient Point2D xa = new Point2D.Double();
    private final transient Point2D ya = new Point2D.Double();
    protected transient TextLayout[] textLayout = null;
    protected transient Rectangle2D[] rects = null;
    protected transient float textHeight = 0.0f;
    protected transient float lastViewScale = 0.0f;

    @INode.SyncField(value={"visible"})
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @INode.SyncField(value={"visible", "flagShape", "flagText", "stroke", "border", "fill", "textColor", "width", "height", "direction", "beakAngle", "textSize", "hAlign", "vAlign", "font"})
    public void init(Shape flagShape, String[] flagText, Stroke stroke, Color border, Color fill, Color textColor, float width, float height, double direction, float beakAngle, Rectangle2D textArea, int hAlign, int vAlign, Font font) {
        this.visible = true;
        this.flagShape = flagShape;
        this.flagText = flagText;
        this.stroke = stroke;
        this.border = border;
        this.fill = fill;
        this.textColor = textColor;
        this.width = width;
        this.height = height;
        this.direction = direction;
        this.beakAngle = beakAngle;
        this.textArea = textArea;
        this.hAlign = (byte)hAlign;
        this.vAlign = (byte)vAlign;
        this.font = font;
        this.resetCaches();
    }

    private void resetCaches() {
        this.textLayout = null;
        this.rects = null;
    }

    @Override
    public void render(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        AffineTransform ot = g.getTransform();
        g.transform(this.transform);
        try {
            double leftoverHeight;
            Object renderingHint = g.getRenderingHint(RenderingHints.KEY_RENDERING);
            g.setColor(this.fill);
            g.fill(this.flagShape);
            g.setStroke(this.stroke);
            g.setColor(this.border);
            g.draw(this.flagShape);
            if (renderingHint != RenderingHints.VALUE_RENDER_QUALITY) {
                double viewScale = GeometryUtils.getScale(ot);
                if ((viewScale *= GeometryUtils.getScale(this.transform)) < 4.0) {
                    return;
                }
            }
            if (this.flagText == null || this.flagText.length == 0) {
                return;
            }
            g.setFont(this.font);
            g.setColor(this.textColor);
            AffineTransform orig = g.getTransform();
            double det = orig.getDeterminant();
            if (det < 0.0) {
                this.origin.setLocation(this.textArea.getMinX(), this.textArea.getMaxY());
                this.xa.setLocation(this.textArea.getMaxX(), this.textArea.getMaxY());
                this.ya.setLocation(this.textArea.getMinX(), this.textArea.getMinY());
            } else {
                this.origin.setLocation(this.textArea.getMinX(), this.textArea.getMinY());
                this.xa.setLocation(this.textArea.getMaxX(), this.textArea.getMinY());
                this.ya.setLocation(this.textArea.getMinX(), this.textArea.getMaxY());
            }
            orig.transform(this.origin, this.origin);
            orig.transform(this.xa, this.xa);
            orig.transform(this.ya, this.ya);
            double xAxisX = this.xa.getX() - this.origin.getX();
            double xAxisY = this.xa.getY() - this.origin.getY();
            double yAxisX = this.ya.getX() - this.origin.getX();
            double yAxisY = this.ya.getY() - this.origin.getY();
            boolean needToFlip = xAxisX < 0.0 || yAxisY < 0.0;
            byte horizAlign = this.hAlign;
            if (needToFlip) {
                this.origin.setLocation(this.origin.getX() + xAxisX + yAxisX, this.origin.getY() + xAxisY + yAxisY);
                xAxisX = -xAxisX;
                xAxisY = -xAxisY;
                yAxisX = -yAxisX;
                yAxisY = -yAxisY;
                if (horizAlign == 0) {
                    horizAlign = 1;
                } else if (horizAlign == 1) {
                    horizAlign = 0;
                }
            }
            double scale = GeometryUtils.getMaxScale(orig) * 0.1;
            double rotation = Math.atan2(xAxisY, xAxisX);
            g.setTransform(IDENTITY);
            g.translate(this.origin.getX(), this.origin.getY());
            g.rotate(rotation);
            g.scale(scale, scale);
            FontMetrics fm = g.getFontMetrics(this.font);
            double fontHeight = fm.getHeight();
            if (this.textLayout == null || (float)scale != this.lastViewScale) {
                this.lastViewScale = (float)scale;
                FontRenderContext frc = g.getFontRenderContext();
                if (this.textLayout == null) {
                    this.textLayout = new TextLayout[this.flagText.length];
                }
                if (this.rects == null) {
                    this.rects = new Rectangle2D[this.flagText.length];
                }
                this.textHeight = 0.0f;
                int i = 0;
                while (i < this.flagText.length) {
                    String txt = this.flagText[i].isEmpty() ? " " : this.flagText[i];
                    this.textLayout[i] = new TextLayout(txt, this.font, frc);
                    this.rects[i] = this.textLayout[i].getBounds();
                    this.rects[i].setRect(this.rects[i].getX(), this.rects[i].getY(), this.rects[i].getWidth(), fontHeight);
                    this.textHeight = (float)((double)this.textHeight + this.rects[i].getHeight() * 0.1);
                    ++i;
                }
            }
            if ((leftoverHeight = this.textArea.getHeight() - (double)this.textHeight) < 0.0) {
                leftoverHeight = 0.0;
            }
            double lineDist = 0.0;
            double startY = 0.0;
            switch (this.vAlign) {
                case 0: {
                    lineDist = leftoverHeight / (double)this.flagText.length;
                    startY = fm.getMaxAscent();
                    break;
                }
                case 1: {
                    lineDist = leftoverHeight / (double)this.flagText.length;
                    startY = (double)fm.getMaxAscent() + lineDist * 10.0;
                    break;
                }
                case 2: {
                    lineDist = leftoverHeight / (double)(this.flagText.length + 1);
                    startY = (double)fm.getMaxAscent() + lineDist * 10.0;
                }
            }
            lineDist *= 10.0;
            double y = startY;
            double textAreaWidth = this.textArea.getWidth() * 10.0;
            boolean renderAsText = g.getRenderingHint(G2DPDFRenderingHints.KEY_PDF_WRITER) != null || g.getRenderingHint(G2DRenderingHints.KEY_TEXT_RENDERING_MODE) == G2DRenderingHints.TextRenderingMode.AS_TEXT;
            int i = 0;
            while (i < this.flagText.length) {
                Rectangle2D rect = this.rects[i];
                double x = 0.0;
                switch (horizAlign) {
                    case 0: {
                        x = 5.0;
                        break;
                    }
                    case 1: {
                        x = textAreaWidth - rect.getWidth() - 5.0;
                        break;
                    }
                    case 2: {
                        x = textAreaWidth * 0.5 - rect.getWidth() * 0.5;
                    }
                }
                if (renderAsText) {
                    g.drawString(this.flagText[i], (float)x, (float)y);
                } else {
                    this.textLayout[i].draw(g, (float)x, (float)y);
                }
                y += lineDist;
                y += rect.getHeight();
                ++i;
            }
        }
        finally {
            g.setTransform(ot);
        }
    }

    public static double getBeakLength(double height, double beakAngle) {
        beakAngle = Math.min(180.0, Math.max(10.0, beakAngle));
        return height / (2.0 * Math.tan(Math.toRadians(beakAngle) / 2.0));
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.flagShape == null) {
            return null;
        }
        return this.flagShape.getBounds2D();
    }
}

