/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class G2DRepaintManager
extends RepaintManager {
    private RepaintManager delegate;
    private Class<?> rootClass;
    private static final Rectangle NULL_RECTANGLE = new Rectangle();
    private static final Dimension NULL_DIMENSION = new Dimension();

    public G2DRepaintManager(Class<?> rootClass, RepaintManager repaintManager) {
        this.delegate = repaintManager;
        this.rootClass = rootClass;
    }

    void setDelegate(RepaintManager manager) {
        this.delegate = manager;
    }

    public RepaintManager getDelegate() {
        return this.delegate;
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        JComponent root = (JComponent)G2DRepaintManager.getAncestorOfClass(this.rootClass, c);
        if (root != null) {
            this.delegate.markCompletelyDirty(root);
        } else if (this.delegate != null) {
            this.delegate.addDirtyRegion(c, x, y, w, h);
        }
    }

    @Override
    public void addInvalidComponent(JComponent invalidComponent) {
        if (this.delegate != null) {
            this.delegate.addInvalidComponent(invalidComponent);
        }
    }

    @Override
    public Rectangle getDirtyRegion(JComponent component) {
        if (this.delegate != null) {
            return this.delegate.getDirtyRegion(component);
        }
        return NULL_RECTANGLE;
    }

    @Override
    public Dimension getDoubleBufferMaximumSize() {
        if (this.delegate != null) {
            return this.delegate.getDoubleBufferMaximumSize();
        }
        assert (false);
        return NULL_DIMENSION;
    }

    @Override
    public Image getOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        if (this.delegate != null) {
            return this.delegate.getOffscreenBuffer(c, proposedWidth, proposedHeight);
        }
        assert (false);
        return null;
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        if (this.delegate != null) {
            return this.delegate.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isCompletelyDirty(JComponent component) {
        if (this.delegate != null) {
            return this.delegate.isCompletelyDirty(component);
        }
        assert (false);
        return false;
    }

    @Override
    public boolean isDoubleBufferingEnabled() {
        if (this.delegate != null) {
            return this.delegate.isDoubleBufferingEnabled();
        }
        assert (false);
        return false;
    }

    @Override
    public void markCompletelyClean(JComponent component) {
        if (this.delegate != null) {
            this.delegate.markCompletelyClean(component);
        }
    }

    public static Container getAncestorOfClass(Class<?> c, Component comp) {
        if (comp == null || c == null) {
            return null;
        }
        if (c.isInstance(comp) && comp instanceof Container) {
            return (Container)comp;
        }
        Container parent = comp.getParent();
        while (parent != null && !c.isInstance(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Override
    public void markCompletelyDirty(JComponent component) {
        JComponent root = (JComponent)G2DRepaintManager.getAncestorOfClass(this.rootClass, component);
        if (root != null) {
            this.delegate.markCompletelyDirty(root);
        } else if (this.delegate != null) {
            this.delegate.markCompletelyDirty(component);
        }
    }

    @Override
    public void paintDirtyRegions() {
        if (this.delegate != null) {
            this.delegate.paintDirtyRegions();
        } else assert (false);
    }

    @Override
    public void removeInvalidComponent(JComponent component) {
        if (this.delegate != null) {
            this.delegate.removeInvalidComponent(component);
        } else assert (false);
    }

    @Override
    public void setDoubleBufferingEnabled(boolean flag) {
        if (this.delegate != null) {
            this.delegate.setDoubleBufferingEnabled(flag);
        } else assert (false);
    }

    @Override
    public void setDoubleBufferMaximumSize(Dimension d) {
        if (this.delegate != null) {
            this.delegate.setDoubleBufferMaximumSize(d);
        } else assert (false);
    }

    @Override
    public void validateInvalidComponents() {
        if (this.delegate != null) {
            this.delegate.validateInvalidComponents();
        } else assert (false);
    }
}

