/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.writer;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.writer.GraphWriter;

public abstract class GraphWriterPartial
implements GraphWriter {
    ClusteringSupport clustering;
    ReadGraph graph;
    Layer0 l0;

    public GraphWriterPartial(ReadGraph graph) {
        this.graph = graph;
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        this.clustering = (ClusteringSupport)graph.getSession().getService(ClusteringSupport.class);
    }

    @Override
    public ReadGraph getGraph() {
        return this.graph;
    }

    @Override
    public GraphWriter create(String name, Resource type) throws DatabaseException {
        this.create(type);
        return this.let(this.l0.HasName, name, this.l0.String);
    }

    @Override
    public GraphWriter create(int clusterHint, String name, Resource type) throws DatabaseException {
        this.create(clusterHint, type);
        return this.let(clusterHint, this.l0.HasName, name, this.l0.String);
    }

    @Override
    public GraphWriter create(int clusterHint) throws DatabaseException {
        return this.create();
    }

    @Override
    public GraphWriter create(int clusterHint, Resource type) throws DatabaseException {
        return this.create(type);
    }

    @Override
    public GraphWriter let(int clusterHint, Resource p, Object value, Resource dataType) throws DatabaseException {
        return this.let(p, value, dataType);
    }

    @Override
    public GraphWriter createLiteral(int clusterHint, Object value, Resource dataType) throws DatabaseException {
        return this.createLiteral(value, dataType);
    }

    @Override
    public GraphWriter stat(Resource s, Resource p, Resource o) throws DatabaseException {
        return this.handle(s).let(p, o);
    }

    @Override
    public GraphWriter createInverse(int clusterHint, Resource r) throws DatabaseException {
        return this.createInverse(r);
    }
}

