/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledActionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.Logger;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class CreateStyleAction
extends ModelledActionImpl<Resource> {
    public CreateStyleAction(Resource configuration) {
        super(configuration);
    }

    public void run(final Resource runtimeDiagram) {
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    String modelURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
                    if (modelURI == null) {
                        return;
                    }
                    Resource model = graph.getPossibleResource(modelURI);
                    if (model == null) {
                        return;
                    }
                    String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"Style", (Resource)model, (Resource)L0.ConsistsOf);
                    Resource newStyle = graph.newResource();
                    graph.claim(newStyle, L0.InstanceOf, DIA.SCLTextStyle);
                    graph.claimLiteral(newStyle, L0X.HasExpression, (Object)"");
                    graph.claimLiteral(newStyle, L0.HasName, (Object)name);
                    graph.claim(model, L0.ConsistsOf, newStyle);
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }
}

