/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.simantics.structural.synchronization.base.ComponentBase;
import org.simantics.structural.synchronization.base.ComponentFactory;
import org.simantics.structural.synchronization.base.Solver;
import org.simantics.structural.synchronization.base.StateUndoContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MappingBase<T extends ComponentBase<T>> {
    private final transient Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected transient THashMap<String, T> configurationByUid;
    protected transient Map<String, T> configurationBySolverName;
    transient THashSet<T> pendingRemoval = new THashSet();
    public transient StateUndoContextBase undoContext = this.createUndoContext();
    public transient ComponentFactory<T> componentFactory = this.createComponentFactory();
    public long currentRevision;
    private boolean trustUids;

    public abstract T getConfiguration();

    public MappingBase() {
        this(null, -1L, false);
    }

    public MappingBase(T configuration, boolean trustUids) {
        this(configuration, -1L, trustUids);
    }

    public MappingBase(T configuration, long currentRevision, boolean trustUids) {
        if (trustUids) {
            this.createConfigurationById(configuration);
        }
        this.currentRevision = currentRevision;
        this.trustUids = trustUids;
    }

    public abstract StateUndoContextBase createUndoContext();

    public abstract ComponentFactory<T> createComponentFactory();

    protected void createConfigurationById(T configuration) {
        THashMap configurationByUid = new THashMap();
        this.browseConfiguration(configurationByUid, configuration);
        this.configurationByUid = configurationByUid;
    }

    private void browseConfiguration(THashMap<String, T> configurationByUid, T configuration) {
        configurationByUid.put((Object)((ComponentBase)configuration).uid, configuration);
        for (ComponentBase child : ((ComponentBase)configuration).getChildren()) {
            this.browseConfiguration(configurationByUid, child);
            child.parent = configuration;
        }
    }

    public Map<String, T> getConfigurationBySolverName() {
        Map<String, Object> result = this.configurationBySolverName;
        if (result == null) {
            T configuration = this.getConfiguration();
            result = configuration != null ? (this.configurationBySolverName = this.createConfigurationBySolverName(configuration)) : Collections.emptyMap();
        }
        return result;
    }

    protected Map<String, T> createConfigurationBySolverName(T configuration) {
        THashMap configurationBySolverName = new THashMap();
        this.browseConfigurationBySolverName(configurationBySolverName, configuration);
        return configurationBySolverName;
    }

    private void browseConfigurationBySolverName(THashMap<String, T> configurationBySolverName, T configuration) {
        if (((ComponentBase)configuration).solverComponentName != null) {
            configurationBySolverName.put((Object)((ComponentBase)configuration).solverComponentName, configuration);
        } else if (((ComponentBase)configuration).componentId != 0) {
            this.LOGGER.warn("configuration.solverComponentName is null! configuration uid is {} and component id {}", (Object)((ComponentBase)configuration).getUid(), (Object)((ComponentBase)configuration).componentId);
        }
        for (ComponentBase child : ((ComponentBase)configuration).getChildren()) {
            this.browseConfigurationBySolverName(configurationBySolverName, child);
            child.parent = configuration;
        }
    }

    public T detachOrCreateComponent(String uid) {
        ComponentBase result = (ComponentBase)this.configurationByUid.get((Object)uid);
        if (result == null) {
            result = this.componentFactory.create(uid);
            this.configurationByUid.put((Object)uid, (Object)result);
            this.configurationBySolverName = null;
        } else if (result.getParent() == null) {
            this.pendingRemoval.remove((Object)result);
        } else {
            ((ComponentBase)result.getParent()).detachByUid(uid);
        }
        return (T)result;
    }

    public void addPendingRemoval(T component) {
        this.pendingRemoval.add(component);
    }

    public void printUidMap() {
        this.printUidMap(new PrintWriter(System.out));
    }

    public void printUidMap(final PrintWriter out) {
        out.println("Component tree");
        out.print("    ");
        ((ComponentBase)this.getConfiguration()).printConfiguration(out, 1);
        if (this.configurationByUid != null) {
            out.println("UIDs");
            this.configurationByUid.forEachEntry(new TObjectObjectProcedure<String, T>(){

                public boolean execute(String a, T b) {
                    out.println("    " + a + " (" + ((ComponentBase)b).solverComponentName + ", " + ((ComponentBase)b).componentId + ", " + ((ComponentBase)b).uid + ")");
                    return true;
                }
            });
        }
    }

    public void remove(final Solver solver, T component) {
        if (this.configurationByUid != null) {
            this.configurationByUid.remove((Object)((ComponentBase)component).uid);
        }
        if (this.configurationBySolverName != null && ((ComponentBase)component).solverComponentName != null) {
            this.configurationBySolverName.remove(((ComponentBase)component).solverComponentName);
        }
        if (((ComponentBase)component).getChildMap() != null) {
            ((ComponentBase)component).getChildMap().forEachValue(new TObjectProcedure<T>(){

                public boolean execute(T child) {
                    MappingBase.this.remove(solver, child);
                    return true;
                }
            });
        }
        if (((ComponentBase)component).componentId > 0 && !((ComponentBase)component).attached) {
            solver.remove(((ComponentBase)component).componentId);
        }
    }

    public void saveUndoState(final Solver solver, T component) {
        if (((ComponentBase)component).getChildMap() != null) {
            ((ComponentBase)component).getChildMap().forEachValue(new TObjectProcedure<T>(){

                public boolean execute(T child) {
                    MappingBase.this.saveUndoState(solver, child);
                    return true;
                }
            });
        } else if (((ComponentBase)component).componentId > 0 && !((ComponentBase)component).attached) {
            this.undoContext.saveState(solver, ((ComponentBase)component).componentId, ((ComponentBase)component).uid);
        }
    }

    public void removePending(final Solver solver) {
        this.pendingRemoval.forEach(new TObjectProcedure<T>(){

            public boolean execute(T component) {
                MappingBase.this.saveUndoState(solver, component);
                return true;
            }
        });
        this.pendingRemoval.forEach(new TObjectProcedure<T>(){

            public boolean execute(T component) {
                MappingBase.this.remove(solver, component);
                return true;
            }
        });
        this.pendingRemoval.clear();
    }

    public void setTrustUids(boolean trustUids) {
        if (trustUids != this.trustUids) {
            T configuration;
            this.trustUids = trustUids;
            if (trustUids && (configuration = this.getConfiguration()) != null) {
                this.createConfigurationById(configuration);
            }
        }
        if (!trustUids) {
            this.configurationByUid = null;
        }
    }

    public boolean getTrustUids() {
        return this.trustUids;
    }

    public void dispose() {
        if (this.configurationByUid != null) {
            this.configurationByUid.clear();
        }
        if (this.configurationBySolverName != null) {
            this.configurationBySolverName.clear();
            this.configurationBySolverName = null;
        }
        this.pendingRemoval.clear();
    }

    public boolean hasPendingRemovals() {
        return !this.pendingRemoval.isEmpty();
    }

    public void forEachPendingRemoval(Consumer<T> consumer) {
        this.pendingRemoval.forEach(c -> {
            consumer.accept(c);
            return true;
        });
    }
}

