/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.request.ResourceToPossibleVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.ManagementSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural.synchronization.StructuralChangeFlattener;
import org.simantics.structural.synchronization.protocol.ChildInfo;
import org.simantics.structural.synchronization.protocol.Connection;
import org.simantics.structural.synchronization.protocol.SerializedVariable;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.simantics.structural.synchronization.protocol.SynchronizationException;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;

public class Synchronizer {
    public static boolean TRACE = false;
    ReadGraph graph;
    Layer0 L0;
    StructuralResource2 STR;
    THashSet<String> visitedTypes = new THashSet();
    IProgressMonitor monitor;
    double workDone = 0.0;
    int workDoneInteger;
    int maxWork;

    public Synchronizer(ReadGraph graph) {
        this.graph = graph;
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
    }

    public void setMonitor(IProgressMonitor monitor, int maxWork) {
        this.monitor = monitor;
        this.maxWork = maxWork;
        this.workDoneInteger = 0;
    }

    private void didWork(double amount) {
        int t;
        this.workDone += amount;
        if (this.monitor != null && (t = (int)(this.workDone * (double)this.maxWork)) > this.workDoneInteger) {
            this.monitor.worked(t - this.workDoneInteger);
            this.workDoneInteger = t;
        }
    }

    ChildInfo mapChild(Variable child) throws DatabaseException {
        String name = child.getName(this.graph);
        RVI rvi = child.getRVI(this.graph);
        return new ChildInfo(name, rvi.toString());
    }

    Collection<ChildInfo> mapChildren(SynchronizationEventHandler handler, Collection<Variable> children) throws DatabaseException {
        ArrayList<ChildInfo> result = new ArrayList<ChildInfo>(children.size());
        for (Variable child : children) {
            if (child.getPossibleType(this.graph, this.STR.Component) == null) continue;
            try {
                result.add(this.mapChild(child));
            }
            catch (Exception e) {
                handler.reportProblem("Failed to get ChildInfo for " + child + ".", e);
            }
        }
        return result;
    }

    Collection<Connection> mapConnections(SynchronizationEventHandler handler, Variable child) throws DatabaseException {
        ArrayList<Connection> result = new ArrayList<Connection>();
        for (Variable conn : child.getProperties(this.graph, "http://www.simantics.org/Structural-1.2/SynchronizedConnectionRelation")) {
            String name = conn.getName(this.graph);
            org.simantics.structural2.variables.Connection vc = (org.simantics.structural2.variables.Connection)conn.getValue(this.graph);
            Collection connectionPoints = vc.getConnectionPointDescriptors(this.graph, null);
            ArrayList<String> cps = new ArrayList<String>(connectionPoints.size());
            for (VariableConnectionPointDescriptor desc : connectionPoints) {
                if (desc.isFlattenedFrom(this.graph, conn) || !desc.hasClassification(this.graph, "http://www.simantics.org/Structural-1.2/ProvidingConnectionRelation")) continue;
                String cpRef = desc.getRelativeRVI(this.graph, child);
                cps.add(cpRef);
            }
            result.add(new Connection(name, cps));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private SerializedVariable serialize(SynchronizationEventHandler handler, Variable var, String name) throws DatabaseException {
        block5: {
            try {
                result = new SerializedVariable(name, var.getVariantValue(this.graph));
                for (Variable prop : var.getProperties(this.graph, "http://www.simantics.org/Structural-1.2/SynchronizedRelation")) {
                    v = this.serialize(handler, prop, pName = prop.getName(this.graph));
                    if (v == null) continue;
                    result.addProperty(pName, v);
                }
                return result;
            }
            catch (MissingVariableValueException e) {
                handler.reportProblem("Failed to read " + name + ". " + e.getMessage());
                cur = e;
                ** while ((cur = cur.getCause()) != null)
            }
lbl-1000:
            // 1 sources

            {
                if (cur instanceof MissingVariableValueException) continue;
                handler.reportProblem(cur.getMessage());
                continue;
lbl16:
                // 1 sources

                break block5;
            }
            catch (Exception e) {
                handler.reportProblem("Failed to serialize " + name + ": " + e.getMessage(), e);
            }
        }
        return null;
    }

    Collection<SerializedVariable> mapProperties(SynchronizationEventHandler handler, Variable child) throws DatabaseException {
        ArrayList<SerializedVariable> result = new ArrayList<SerializedVariable>();
        for (Variable prop : child.getProperties(this.graph, "http://www.simantics.org/Structural-1.2/SynchronizedRelation")) {
            SerializedVariable serialized = this.serialize(handler, prop, prop.getName(this.graph));
            if (serialized == null) continue;
            result.add(serialized);
        }
        return result;
    }

    public void fullSynchronization(Variable variable, SynchronizationEventHandler handler) throws DatabaseException {
        long duration = 0L;
        if (TRACE) {
            System.out.println("fullSynchronization " + variable.getURI(this.graph));
            duration -= System.nanoTime();
        }
        SCLContext context = SCLContext.getCurrent();
        Object oldGraph = context.put((Object)"graph", (Object)this.graph);
        try {
            handler.beginSynchronization();
            this.synchronizationRec(variable, handler, null, 1.0);
            handler.endSynchronization();
        }
        finally {
            context.put((Object)"graph", oldGraph);
        }
        if (TRACE) {
            System.out.println("full sync in " + 1.0E-9 * (double)(duration += System.nanoTime()) + "s.");
        }
    }

    private void synchronizationRec(Variable variable, SynchronizationEventHandler handler, TObjectIntHashMap<Variable> changeFlags, double proportionOfWork) throws DatabaseException {
        Collection<SerializedVariable> propertyMap;
        boolean endComponentNeeded;
        String typeId;
        String name = variable.getName(this.graph);
        Resource type = variable.getPossibleType(this.graph, this.STR.Component);
        if (type == null) {
            return;
        }
        Collection children = variable.getChildren(this.graph);
        if (this.graph.isInheritedFrom(type, this.STR.Composite) || this.graph.isInheritedFrom(type, this.STR.AbstractDefinedComponentType)) {
            typeId = this.graph.getPossibleURI(type);
            if (typeId == null) {
                throw new SynchronizationException("User component " + type + " does not have an URI.");
            }
            if (this.visitedTypes.add((Object)typeId)) {
                this.visitType(typeId, type, handler);
            }
            endComponentNeeded = false;
            try {
                propertyMap = this.mapProperties(handler, variable);
                Collection<ChildInfo> childMap = this.mapChildren(handler, children);
                endComponentNeeded = true;
                handler.beginComponent(name, typeId, propertyMap, Collections.emptyList(), childMap);
            }
            catch (Exception e) {
                handler.reportProblem("Failed to synchronize " + name + ": " + e.getMessage(), e);
                if (endComponentNeeded) {
                    handler.endComponent();
                }
                return;
            }
        }
        typeId = this.graph.getPossibleURI(type);
        if (typeId == null) {
            throw new SynchronizationException("User component " + type + " does not have an URI.");
        }
        if (this.visitedTypes.add((Object)typeId)) {
            this.visitType(typeId, type, handler);
        }
        endComponentNeeded = false;
        try {
            propertyMap = this.mapProperties(handler, variable);
            Collection<Connection> connectionMap = this.mapConnections(handler, variable);
            Collection<ChildInfo> childMap = this.mapChildren(handler, children);
            endComponentNeeded = true;
            handler.beginComponent(name, typeId, propertyMap, connectionMap, childMap);
        }
        catch (Exception e) {
            handler.reportProblem("Failed to synchronize " + name + ": " + e.getMessage(), e);
            if (endComponentNeeded) {
                handler.endComponent();
            }
            return;
        }
        if (changeFlags == null) {
            if (children.size() > 0) {
                double proportionOfWorkForChildren = proportionOfWork / (double)children.size();
                for (Variable child : children) {
                    this.synchronizationRec(child, handler, null, proportionOfWorkForChildren);
                }
            } else {
                this.didWork(proportionOfWork);
                if (this.monitor != null && this.monitor.isCanceled()) {
                    throw new CancelTransactionException();
                }
            }
        } else {
            int relevantChildCount = 0;
            for (Variable child : children) {
                int changeStatus = changeFlags.get((Object)child);
                if (changeStatus == 0) continue;
                ++relevantChildCount;
            }
            if (relevantChildCount > 0) {
                double proportionOfWorkForChildren = proportionOfWork / (double)relevantChildCount;
                for (Variable child : children) {
                    int changeStatus = changeFlags.get((Object)child);
                    if (changeStatus == 0) continue;
                    this.synchronizationRec(child, handler, (TObjectIntHashMap<Variable>)(changeStatus == 1 ? changeFlags : null), proportionOfWorkForChildren);
                }
            } else {
                this.didWork(proportionOfWork);
            }
        }
        handler.endComponent();
    }

    public void partialSynchronization(Variable variable, SynchronizationEventHandler handler, TObjectIntHashMap<Variable> changeFlags) throws DatabaseException {
        int changeStatus;
        long duration = 0L;
        if (TRACE) {
            System.out.println("partialSynchronization " + variable.getURI(this.graph));
            duration -= System.nanoTime();
        }
        if ((changeStatus = changeFlags.get((Object)variable)) == 0) {
            return;
        }
        SCLContext context = SCLContext.getCurrent();
        Object oldGraph = context.put((Object)"graph", (Object)this.graph);
        try {
            handler.beginSynchronization();
            this.synchronizationRec(variable, handler, (TObjectIntHashMap<Variable>)(changeStatus == 1 ? changeFlags : null), 1.0);
            handler.endSynchronization();
        }
        finally {
            context.put((Object)"graph", oldGraph);
        }
        if (TRACE) {
            System.out.println("partial sync in " + 1.0E-9 * (double)(duration += System.nanoTime()) + "s.");
        }
    }

    public void partialSynchronization(Variable variable, SynchronizationEventHandler handler, long fromRevision) throws DatabaseException {
        TObjectIntHashMap<Variable> modifiedComponents = StructuralChangeFlattener.getModifiedComponents(this.graph, variable, fromRevision);
        this.partialSynchronization(variable, handler, modifiedComponents);
    }

    void visitType(String typeId, Resource typeResource, SynchronizationEventHandler handler) throws DatabaseException {
        Variable typeVariable = (Variable)this.graph.syncRequest((Read)new ResourceToPossibleVariable(typeResource), (AsyncProcedure)TransientCacheAsyncListener.instance());
        handler.beginType(typeId, this.mapProperties(handler, typeVariable));
        handler.endType();
    }

    public long getHeadRevisionId() throws DatabaseException {
        return ((ManagementSupport)this.graph.getService(ManagementSupport.class)).getHeadRevisionId() + 1L;
    }
}

