/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph.layer;

import java.util.Collection;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.SimpleLayer;

public class GraphLayer {
    public static final String PROP_VISIBLE = "PROP_VISIBLE";
    public static final String PROP_FOCUSABLE = "PROP_FOCUSABLE";
    private final String name;
    private final Resource layer;
    private final Map<String, Resource> tags;

    public GraphLayer(String name, Resource layer, Map<String, Resource> tags) {
        this.name = name;
        this.layer = layer;
        this.tags = tags;
    }

    public GraphLayer withName(String name) {
        return new GraphLayer(name, this.layer, this.tags);
    }

    public String getName() {
        return this.name;
    }

    public Resource getLayer() {
        return this.layer;
    }

    public Resource getVisible() {
        return this.tags.get(PROP_VISIBLE);
    }

    public Resource getFocusable() {
        return this.tags.get(PROP_FOCUSABLE);
    }

    public ILayer getILayer() {
        return new SimpleLayer(this.name);
    }

    public Collection<Resource> getTags() {
        return this.tags.values();
    }

    public void forEachTag(DbConsumer<Resource> consumer) throws DatabaseException {
        for (Resource r : this.tags.values()) {
            consumer.accept((Object)r);
        }
    }
}

