/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.profile.MonitorTextResult;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.utils.Alignment;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.ui.colors.Colors;

public abstract class TextStyle
extends StyleBase<MonitorTextResult> {
    private final Font FONT = Font.decode("Arial 12");
    private final java.awt.Color BACKGROUND_COLOR = new java.awt.Color(255, 255, 255, 192);
    protected double xOffset;
    protected double yOffset;

    public TextStyle() {
        this(0.0, -2.2);
    }

    public TextStyle(double xOffset, double yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public abstract Resource getPropertyRelation(ReadGraph var1, Resource var2);

    public abstract String getNodeName();

    protected Resource getConfigurationComponent(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        Resource config = graph.getPossibleObject(element, mr.ElementToComponent);
        return config;
    }

    protected String getConfigurationComponentNameForElement(ReadGraph graph, Resource element) throws DatabaseException {
        Resource config = this.getConfigurationComponent(graph, element);
        if (config == null) {
            return null;
        }
        String name = (String)graph.getPossibleRelatedValue(config, this.getPropertyRelation(graph, element), (Binding)Bindings.STRING);
        return name;
    }

    public AffineTransform getTransform(AffineTransform parentTransform, Rectangle2D elementBounds, int location) {
        double scale = GeometryUtils.getScale((AffineTransform)parentTransform);
        AffineTransform at = AffineTransform.getTranslateInstance(parentTransform.getTranslateX() + elementBounds.getCenterX() * scale + this.xOffset, parentTransform.getTranslateY() + elementBounds.getMinY() * scale + this.yOffset * (double)location);
        at.scale(0.15, 0.15);
        return at;
    }

    @Override
    public MonitorTextResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        String name = this.getConfigurationComponentNameForElement(graph, element);
        if (name == null) {
            return null;
        }
        AffineTransform transform = DiagramGraphUtil.getAffineTransform(graph, element);
        return new MonitorTextResult(name, transform);
    }

    @Override
    public void applyStyleForNode(EvaluationContext observer, INode _node, MonitorTextResult result) {
        String value;
        String string = value = result != null ? result.getText() : null;
        if (value != null && !value.isEmpty() && !value.trim().isEmpty()) {
            TextNode node = (TextNode)ProfileVariables.claimChild((INode)_node, (String)"", (String)this.getNodeName(), TextNode.class, (Observer)observer);
            if (node == null) {
                return;
            }
            Integer location = (Integer)observer.getTemporaryProperty(_node, "location");
            if (location == null) {
                location = 1;
            }
            Rectangle2D bounds = NodeUtil.getLocalElementBounds((INode)_node);
            AffineTransform at = this.getTransform(result.getParentTransform(), bounds, location);
            Color color = result.getColor();
            observer.setTemporaryProperty(_node, "location", (Object)(location + 1));
            node.setTransform(at);
            node.setHorizontalAlignment((byte)Alignment.CENTER.ordinal());
            node.setZIndex(3000);
            if (color != null) {
                node.setColor(Colors.awt((Color)color));
            } else {
                node.setColor(java.awt.Color.DARK_GRAY);
            }
            node.setEditable(false);
            node.setFont(this.FONT);
            node.setText(value);
            node.setBackgroundColor(this.BACKGROUND_COLOR);
        } else {
            this.cleanupStyleForNode(observer, _node);
        }
    }

    @Override
    protected void cleanupStyleForNode(EvaluationContext observer, INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)this.getNodeName());
    }
}

