/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.InvalidOrderedSetException;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.function.DbFunction;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class OrderedSetUtils {
    public static boolean contains(ReadGraph g, Resource l, Resource el) throws DatabaseException {
        return g.hasStatement(el, l) && !l.equals(el);
    }

    public static Resource next(ReadGraph g, Resource l, Resource el) throws DatabaseException {
        Collection nexts = g.getObjects(el, l);
        if (nexts.size() != 1) {
            throw new InvalidOrderedSetException("Invalid list element: " + l + " " + el + " " + nexts.size() + " successors.");
        }
        Iterator iterator = nexts.iterator();
        if (iterator.hasNext()) {
            Resource r = (Resource)iterator.next();
            return r;
        }
        return null;
    }

    public static void forNext(AsyncReadGraph g, final Resource l, Resource el, final AsyncMultiProcedure<Resource> procedure) {
        g.forEachObject(el, l, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public void finished(AsyncReadGraph graph) {
            }

            public void execute(AsyncReadGraph graph, Resource nel) {
                if (!nel.equals(l)) {
                    procedure.execute(graph, (Object)nel);
                    OrderedSetUtils.forNext(graph, l, nel, (AsyncMultiProcedure<Resource>)procedure);
                }
            }
        });
    }

    public static Resource prev(ReadGraph g, Resource l, Resource el) throws DatabaseException {
        Collection prevs = g.getObjects(el, g.getInverse(l));
        if (prevs.size() != 1) {
            throw new InvalidOrderedSetException("Invalid list element, " + prevs.size() + " predecessors.");
        }
        Iterator iterator = prevs.iterator();
        if (iterator.hasNext()) {
            Resource r = (Resource)iterator.next();
            return r;
        }
        return null;
    }

    public static boolean add(WriteGraph g, Resource l, Resource el) throws DatabaseException {
        if (g.hasStatement(el, l)) {
            return false;
        }
        Resource back = OrderedSetUtils.prev((ReadGraph)g, l, l);
        g.denyStatement(back, l, l);
        g.claim(back, l, el);
        g.claim(el, l, l);
        return true;
    }

    public static boolean addFirst(WriteGraph g, Resource l, Resource el) throws DatabaseException {
        return OrderedSetUtils.addAfter(g, l, l, el);
    }

    public static boolean addAll(WriteGraph g, Resource l, Iterable<Resource> els) throws DatabaseException {
        for (Resource r : els) {
            if (!g.hasStatement(r, l)) continue;
            return false;
        }
        Resource cur = OrderedSetUtils.prev((ReadGraph)g, l, l);
        g.denyStatement(cur, l, l);
        for (Resource r : els) {
            g.claim(cur, l, r);
            cur = r;
        }
        g.claim(cur, l, l);
        return true;
    }

    public static boolean addAllNew(WriteGraph g, Resource l, Iterable<Resource> els) throws DatabaseException {
        Resource cur = OrderedSetUtils.prev((ReadGraph)g, l, l);
        Resource inv = g.getInverse(l);
        g.deny(cur, l, inv, l);
        for (Resource r : els) {
            g.claim(cur, l, inv, r);
            cur = r;
        }
        g.claim(cur, l, inv, l);
        return true;
    }

    public static boolean addAfter(WriteGraph g, Resource l, Resource pos, Resource el) throws DatabaseException {
        if (g.hasStatement(el, l)) {
            return false;
        }
        Resource next = OrderedSetUtils.next((ReadGraph)g, l, pos);
        g.denyStatement(pos, l, next);
        g.claim(pos, l, el);
        g.claim(el, l, next);
        return true;
    }

    public static boolean addBefore(WriteGraph g, Resource l, Resource pos, Resource el) throws DatabaseException {
        if (g.hasStatement(el, l)) {
            return false;
        }
        Resource prev = OrderedSetUtils.prev((ReadGraph)g, l, pos);
        g.denyStatement(prev, l, pos);
        g.claim(prev, l, el);
        g.claim(el, l, pos);
        return true;
    }

    public static boolean remove(WriteGraph g, Resource l, Resource el) throws DatabaseException {
        Collection nexts = g.getObjects(el, l);
        if (nexts.size() == 0) {
            return false;
        }
        if (nexts.size() != 1) {
            throw new InvalidOrderedSetException("Invalid list element.");
        }
        Collection prevs = g.getObjects(el, g.getInverse(l));
        if (prevs.size() != 1) {
            throw new InvalidOrderedSetException("Invalid list element.");
        }
        for (Resource p : prevs) {
            Iterator iterator = nexts.iterator();
            if (!iterator.hasNext()) continue;
            Resource n = (Resource)iterator.next();
            g.denyStatement(p, l, el);
            g.denyStatement(el, l, n);
            g.claim(p, l, n);
            return true;
        }
        return true;
    }

    public static List<Resource> removeList(WriteGraph g, Resource l) throws DatabaseException {
        List<Resource> els = OrderedSetUtils.toList((ReadGraph)g, l);
        for (Resource el : els) {
            g.deny(el, l);
        }
        g.deny(l, l);
        Resource inv = g.getInverse(l);
        g.deny(l);
        g.deny(inv);
        return els;
    }

    public static void replace(WriteGraph g, Resource l, Resource oldEl, Resource newEl) throws DatabaseException {
        Collection nexts = g.getObjects(oldEl, l);
        if (nexts.size() != 1) {
            throw new InvalidOrderedSetException("Invalid list element.");
        }
        Collection prevs = g.getObjects(oldEl, g.getInverse(l));
        if (prevs.size() != 1) {
            throw new InvalidOrderedSetException("Invalid list element.");
        }
        for (Resource p : prevs) {
            Iterator iterator = nexts.iterator();
            if (!iterator.hasNext()) continue;
            Resource n = (Resource)iterator.next();
            g.denyStatement(p, l, oldEl);
            g.denyStatement(oldEl, l, n);
            g.claim(p, l, newEl);
            g.claim(newEl, l, n);
            return;
        }
    }

    public static List<Resource> toList(ReadGraph g, Resource l) throws DatabaseException {
        ArrayList<Resource> ret = new ArrayList<Resource>();
        Resource cur = l;
        while (!(cur = OrderedSetUtils.next(g, l, cur)).equals(l)) {
            ret.add(cur);
        }
        return ret;
    }

    public static void forEach(AsyncReadGraph g, final Resource l, final AsyncMultiProcedure<Resource> procedure) {
        g.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                for (Resource r : OrderedSetUtils.toList(graph, l)) {
                    procedure.execute((AsyncReadGraph)graph, (Object)r);
                }
            }
        });
    }

    public static Resource create(WriteOnlyGraph g, Resource type) throws DatabaseException {
        Layer0 l0 = (Layer0)g.getService(Layer0.class);
        Resource l = g.newResource();
        g.claim(l, l0.InstanceOf, null, type);
        g.claim(l, l0.SubrelationOf, null, l0.HasNext);
        Resource invL = g.newResource();
        g.claim(invL, l0.SubrelationOf, null, l0.HasPrevious);
        g.claim(l, l0.InverseOf, l0.InverseOf, invL);
        g.claim(l, l, invL, l);
        return l;
    }

    @Deprecated
    public static Resource create(WriteOnlyGraph g, Resource type, Iterable<Resource> c) throws DatabaseException {
        Layer0 l0 = (Layer0)g.getService(Layer0.class);
        Resource l = g.newResource();
        g.claim(l, l0.InstanceOf, null, type);
        g.claim(l, l0.SubrelationOf, null, l0.HasNext);
        Resource invL = g.newResource();
        g.claim(invL, l0.SubrelationOf, null, l0.HasPrevious);
        g.claim(l, l0.InverseOf, l0.InverseOf, invL);
        Resource cur = l;
        for (Resource r : c) {
            g.claim(cur, l, invL, r);
            cur = r;
        }
        g.claim(cur, l, invL, l);
        return l;
    }

    public static Resource create(WriteOnlyGraph g, Resource type, String name, Iterable<Resource> c) throws DatabaseException {
        return OrderedSetUtils.createExisting(g, g.newResource(), type, name, c);
    }

    public static Resource createExisting(WriteOnlyGraph g, Resource l, Resource type, String name, Iterable<Resource> c) throws DatabaseException {
        Layer0 l0 = (Layer0)g.getService(Layer0.class);
        g.claim(l, l0.InstanceOf, null, type);
        g.claim(l, l0.SubrelationOf, null, l0.HasNext);
        g.addLiteral(l, l0.HasName, l0.NameOf, l0.String, (Object)name, (Binding)Bindings.STRING);
        Resource invL = g.newResource();
        g.claim(invL, l0.SubrelationOf, null, l0.HasPrevious);
        g.addLiteral(invL, l0.HasName, l0.NameOf, l0.String, (Object)"Inverse", (Binding)Bindings.STRING);
        g.claim(l, l0.InverseOf, l0.InverseOf, invL);
        g.claim(l, l0.ConsistsOf, l0.PartOf, invL);
        Resource cur = l;
        for (Resource r : c) {
            g.claim(cur, l, invL, r);
            cur = r;
        }
        g.claim(cur, l, invL, l);
        return l;
    }

    public static Resource create(WriteOnlyGraph g, Resource type, Resource ... c) throws DatabaseException {
        Layer0 l0 = (Layer0)g.getService(Layer0.class);
        Resource l = g.newResource();
        g.claim(l, l0.InstanceOf, null, type);
        g.claim(l, l0.SubrelationOf, null, l0.HasNext);
        Resource invL = g.newResource();
        g.claim(invL, l0.SubrelationOf, null, l0.HasPrevious);
        g.claim(l, l0.InverseOf, l0.InverseOf, invL);
        Resource cur = l;
        Resource[] resourceArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            g.claim(cur, l, invL, r);
            cur = r;
            ++n2;
        }
        g.claim(cur, l, invL, l);
        return l;
    }

    public static Resource createExisting(WriteGraph g, Resource l, Resource ... c) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        g.claim(l, l0.SubrelationOf, null, l0.HasNext);
        Resource invL = g.newResource();
        g.claim(invL, l0.SubrelationOf, null, l0.HasPrevious);
        g.claim(l, l0.InverseOf, l0.InverseOf, invL);
        Resource cur = l;
        Resource[] resourceArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            g.claim(cur, l, invL, r);
            cur = r;
            ++n2;
        }
        g.claim(cur, l, invL, l);
        return l;
    }

    public static ListIterator<Resource> iterator(ReadGraph g, Resource l) throws DatabaseException {
        return new OrderedSetIterator(g, l);
    }

    public static boolean set(WriteGraph g, Resource l, Iterable<Resource> els) throws DatabaseException {
        Resource temp2;
        HashSet<Pair> removed = new HashSet<Pair>();
        ArrayList<Pair> added = new ArrayList<Pair>();
        Resource cur = l;
        do {
            temp2 = OrderedSetUtils.next((ReadGraph)g, l, cur);
            removed.add(new Pair((Object)cur, (Object)temp2));
        } while (!(cur = temp2).equals(l));
        cur = l;
        for (Resource temp2 : els) {
            Pair pair = new Pair((Object)cur, (Object)temp2);
            if (!removed.remove(pair)) {
                added.add(pair);
            }
            cur = temp2;
        }
        Pair pair2 = new Pair((Object)cur, (Object)l);
        if (!removed.remove(pair2)) {
            added.add(pair2);
        }
        if (added.isEmpty() && removed.isEmpty()) {
            return false;
        }
        for (Pair pair2 : removed) {
            g.denyStatement((Resource)pair2.first, l, (Resource)pair2.second);
        }
        for (Pair pair2 : added) {
            g.claim((Resource)pair2.first, l, (Resource)pair2.second);
        }
        return true;
    }

    public static Resource getSingleOwnerList(ReadGraph g, Resource el, Resource listBaseRelation) throws DatabaseException {
        Collection<Resource> result = OrderedSetUtils.getOwnerLists(g, el, listBaseRelation);
        if (result.size() != 1) {
            throw new ValidationException(String.valueOf(NameUtils.getSafeName(g, el)) + " is part of " + result.size() + " lists of base type " + NameUtils.getSafeName(g, listBaseRelation) + ", expected only one list.");
        }
        return result.iterator().next();
    }

    public static Resource getSingleOwnerList(ReadGraph g, Resource el) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        Collection<Resource> result = OrderedSetUtils.getOwnerLists(g, el, l0.OrderedSet);
        if (result.size() != 1) {
            throw new ValidationException(String.valueOf(NameUtils.getSafeName(g, el)) + " is part of " + result.size() + " lists of base type L0.OrderedSet, expected only one list.");
        }
        return result.iterator().next();
    }

    public static Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>(1);
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        for (Resource pred : g.getPredicates(object)) {
            if (!g.isInstanceOf(pred, l0.OrderedSet) || pred.equals(object)) continue;
            result.add(pred);
        }
        return result;
    }

    private static void forSubjects(ReadGraph g, Resource object, DbFunction<Resource, Boolean> consumer) throws DatabaseException {
        for (Resource pred : g.getPredicates(object)) {
            if (!pred.equals(object) && !((Boolean)consumer.apply((Object)pred)).booleanValue()) break;
        }
    }

    public static Collection<Resource> getOwnerLists(ReadGraph g, Resource el, Resource listBaseRelation) throws DatabaseException {
        List<Resource> result = null;
        Collection<Resource> rs = OrderedSetUtils.getSubjects(g, el);
        for (Resource r : rs) {
            if (!g.isInstanceOf(r, listBaseRelation)) continue;
            if (result == null) {
                result = new ArrayList<Resource>(2);
            }
            result.add(r);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static Resource getPossibleOwnerList(ReadGraph g, Resource el, Resource listBaseRelation) throws DatabaseException {
        PossibleOwnerList proc = new PossibleOwnerList(g, listBaseRelation);
        OrderedSetUtils.forSubjects(g, el, proc);
        return proc.result;
    }

    public static class OrderedSetIterator
    implements ListIterator<Resource> {
        ReadGraph g;
        Resource l;
        Resource prev;
        Resource next;
        int index;
        boolean direction;

        WriteGraph getWriteGraph() {
            if (!(this.g instanceof WriteGraph)) {
                throw new UnsupportedOperationException("");
            }
            return (WriteGraph)this.g;
        }

        public OrderedSetIterator(ReadGraph g, Resource l) throws DatabaseException {
            this.g = g;
            this.l = l;
            this.prev = l;
            this.next = OrderedSetUtils.next(g, l, l);
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return !this.next.equals(this.l);
        }

        @Override
        public Resource next() {
            this.prev = this.next;
            try {
                this.next = OrderedSetUtils.next(this.g, this.l, this.next);
            }
            catch (DatabaseException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            ++this.index;
            this.direction = true;
            return this.prev;
        }

        @Override
        public void remove() {
            try {
                WriteGraph wg = this.getWriteGraph();
                if (this.direction) {
                    OrderedSetUtils.remove(wg, this.l, this.prev);
                    this.prev = OrderedSetUtils.prev((ReadGraph)wg, this.l, this.next);
                } else {
                    OrderedSetUtils.remove(wg, this.l, this.next);
                    this.next = OrderedSetUtils.next((ReadGraph)wg, this.l, this.prev);
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }

        @Override
        public void add(Resource e) {
            try {
                WriteGraph wg = this.getWriteGraph();
                wg.denyStatement(this.prev, this.l, this.next);
                wg.claim(this.prev, this.l, e);
                wg.claim(e, this.l, this.next);
                this.prev = e;
            }
            catch (DatabaseException ex) {
                throw new RuntimeDatabaseException((Throwable)ex);
            }
        }

        @Override
        public boolean hasPrevious() {
            return !this.prev.equals(this.l);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public Resource previous() {
            try {
                this.next = this.prev;
                this.prev = OrderedSetUtils.prev(this.g, this.l, this.prev);
                --this.index;
                this.direction = false;
                return this.next;
            }
            catch (DatabaseException ex) {
                throw new RuntimeDatabaseException((Throwable)ex);
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(Resource e) {
            try {
                WriteGraph wg = this.getWriteGraph();
                if (this.direction) {
                    OrderedSetUtils.replace(wg, this.l, this.prev, e);
                    this.prev = e;
                } else {
                    OrderedSetUtils.replace(wg, this.l, this.next, e);
                    this.next = e;
                }
            }
            catch (DatabaseException ex) {
                throw new RuntimeDatabaseException((Throwable)ex);
            }
        }
    }

    private static class PossibleOwnerList
    implements DbFunction<Resource, Boolean> {
        private ReadGraph graph;
        private final Resource listBaseRelation;
        public Layer0 L0;
        public Resource result;

        PossibleOwnerList(ReadGraph graph, Resource listBaseRelation) {
            this.graph = graph;
            this.listBaseRelation = listBaseRelation;
            this.L0 = Layer0.getInstance((ReadGraph)graph);
        }

        public Boolean apply(Resource t) throws DatabaseException {
            Set types = this.graph.getTypes(t);
            if (types.contains(this.L0.OrderedSet) && types.contains(this.listBaseRelation)) {
                if (this.result != null) {
                    this.result = null;
                    return false;
                }
                this.result = t;
            }
            return true;
        }
    }
}

