/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.csv;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.csv.ColumnSeparator;
import org.simantics.history.csv.DecimalSeparator;
import org.simantics.history.csv.ExportInterpolation;
import org.simantics.history.csv.URIs;
import org.simantics.history.util.HistoryExportUtil;
import org.simantics.history.util.ProgressMonitor;
import org.simantics.history.util.StreamIterator;
import org.simantics.history.util.ValueBand;

public class CSVFormatter {
    List<Item> items = new ArrayList<Item>();
    double from = -1.7976931348623157E308;
    double end = Double.MAX_VALUE;
    double startTime = 0.0;
    double timeStep = 0.0;
    ColumnSeparator columnSeparator;
    DecimalSeparator decimalSeparator;
    boolean resample;
    String lineFeed;
    Locale locale;
    Format timeFormat;
    Format floatFormat;
    Format numberFormat;
    Formatter timeFormatter;
    Formatter floatFormatter;
    Formatter numberFormatter;
    ExportInterpolation numberInterpolation = ExportInterpolation.LINEAR_INTERPOLATION;

    public CSVFormatter() {
        this.lineFeed = CSVFormatter.resolvePlatformLineFeed();
        this.locale = Locale.getDefault(Locale.Category.FORMAT);
        DecimalFormat defaultFormat = new DecimalFormat();
        defaultFormat.setGroupingUsed(false);
        this.setTimeFormat(defaultFormat);
        this.setFloatFormat(defaultFormat);
        this.setNumberFormat(defaultFormat);
    }

    public void addItem(HistoryManager history, String historyItemId, String label, String variableReference, String unit) {
        Item i = new Item();
        i.history = history;
        i.label = label != null ? label : "";
        i.variableReference = variableReference != null ? variableReference : "";
        i.variableReference = URIs.safeUnescape(i.variableReference);
        i.historyItemId = historyItemId;
        i.unit = unit;
        if (!this.items.contains(i)) {
            this.items.add(i);
        }
    }

    public void sort() {
        Collections.sort(this.items);
    }

    public void setTimeRange(double from, double end) {
        this.from = from;
        this.end = end;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    /*
     * Unable to fully structure code
     */
    void openHistory() throws HistoryException {
        block4: {
            try {
                for (Item item : this.items) {
                    item.open();
                }
                break block4;
            }
            catch (HistoryException e) {
                ** for (item : this.items)
            }
lbl-1000:
            // 1 sources

            {
                item.close();
                continue;
            }
lbl10:
            // 1 sources

            throw e;
        }
    }

    void closeHistory() {
        for (Item item : this.items) {
            item.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void formulate2(ProgressMonitor monitor, Appendable sb) throws HistoryException, IOException {
        if (this.items.isEmpty()) {
            return;
        }
        this.timeFormatter = this.evaluateFormatter(this.timeFormat, this.decimalSeparator);
        this.floatFormatter = this.evaluateFormatter(this.floatFormat, this.decimalSeparator);
        this.numberFormatter = this.evaluateFormatter(this.numberFormat, this.decimalSeparator);
        this.openHistory();
        try {
            double allFrom = Double.MAX_VALUE;
            double allEnd = -1.7976931348623157E308;
            for (Item i : this.items) {
                if (i.iter.isEmpty()) continue;
                allFrom = Math.min(allFrom, i.iter.getFirstTime());
                allEnd = Math.max(allEnd, i.iter.getLastTime());
            }
            int hl = 0;
            while (hl < 3) {
                switch (hl) {
                    case 0: {
                        sb.append("Time");
                        break;
                    }
                    case 1: {
                        sb.append("----");
                        break;
                    }
                    case 2: {
                        sb.append("Unit");
                        break;
                    }
                }
                sb.append(this.columnSeparator.preference);
                for (Item i : this.items) {
                    boolean lastColumn = i == this.items.get(this.items.size() - 1);
                    switch (hl) {
                        case 0: {
                            sb.append(i.label != null ? i.label : "");
                            break;
                        }
                        case 1: {
                            sb.append(i.variableReference != null ? i.variableReference : "");
                            break;
                        }
                        case 2: {
                            sb.append(i.unit == null ? "no unit" : i.unit);
                            break;
                        }
                    }
                    if (lastColumn) continue;
                    sb.append(this.columnSeparator.preference);
                }
                sb.append(this.lineFeed);
                ++hl;
            }
            boolean hasAnyValues = allFrom != Double.MAX_VALUE && allEnd != -1.7976931348623157E308;
            double _from = Double.MAX_VALUE;
            double _end = -1.7976931348623157E308;
            if (hasAnyValues) {
                _from = Math.max(allFrom, this.from);
                _end = Math.min(allEnd, this.end);
            }
            if (!hasAnyValues) {
                return;
            }
            double time = _from;
            if (!this.resample) {
                time = _from;
                this.timeStep = 0.0;
            } else if (this.timeStep > 0.0) {
                double n = Math.max(0.0, Math.ceil((_from - this.startTime) / this.timeStep));
                time = this.startTime + n * this.timeStep;
            } else if (this.startTime > _from) {
                time = this.startTime;
            }
            BigDecimal bigTime = new BigDecimal(String.valueOf(time));
            BigDecimal bigTimeStep = new BigDecimal(String.valueOf(this.timeStep));
            for (Item i : this.items) {
                i.iter.gotoTime(time);
            }
            do {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                String timeStr = this.timeFormatter.format(time);
                sb.append(timeStr);
                block24: for (Item i : this.items) {
                    sb.append(this.columnSeparator.preference);
                    if (!i.iter.hasValidValue()) continue;
                    Object value = i.iter.getValueBand().getValue();
                    if (value instanceof Number) {
                        if (value instanceof Float || value instanceof Double) {
                            switch (this.numberInterpolation) {
                                case PREVIOUS_SAMPLE: {
                                    sb.append(this.formatNumber(value));
                                    continue block24;
                                }
                                case LINEAR_INTERPOLATION: {
                                    if (time != i.iter.getValueBand().getTimeDouble() && i.iter.hasNext()) {
                                        int currentIndex = i.iter.getIndex();
                                        ValueBand band = i.iter.getValueBand();
                                        Number v1 = (Number)value;
                                        double t12 = band.getEndTimeDouble();
                                        i.iter.next();
                                        double t2 = i.iter.getValueBand().getTimeDouble();
                                        Number v2 = (Number)i.iter.getValueBand().getValue();
                                        i.iter.gotoIndex(currentIndex);
                                        double vs = v1.doubleValue();
                                        if (time > t12) {
                                            vs = HistoryExportUtil.biglerp(t12, v1.doubleValue(), t2, v2.doubleValue(), time);
                                        }
                                        sb.append(this.formatDouble(vs));
                                        continue block24;
                                    }
                                    sb.append(this.formatNumber(value));
                                    continue block24;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Unsupported interpolation: " + (Object)((Object)this.numberInterpolation));
                                }
                            }
                        }
                        sb.append(value.toString());
                        continue;
                    }
                    if (value instanceof Boolean) {
                        sb.append((Boolean)value != false ? "1" : "0");
                        continue;
                    }
                    sb.append(value.toString());
                }
                sb.append(this.lineFeed);
                if (this.timeStep > 0.0) {
                    bigTime = bigTime.add(bigTimeStep);
                    time = bigTime.doubleValue();
                } else {
                    Double nextTime = null;
                    for (Item i : this.items) {
                        Double itemNextTime = i.iter.getNextTime(time);
                        if (itemNextTime == null || itemNextTime < time || nextTime != null && (!(nextTime > itemNextTime) || itemNextTime.equals(time))) continue;
                        nextTime = itemNextTime;
                    }
                    if (nextTime == null) return;
                    if (nextTime.equals(time)) {
                        return;
                    }
                    time = nextTime;
                }
                boolean hasMore = false;
                for (Item i : this.items) {
                    i.iter.proceedToTime(time);
                    if (!this.contains(i, time)) continue;
                    hasMore = true;
                }
                if (hasMore) continue;
                return;
            } while (time <= _end);
            return;
        }
        finally {
            this.closeHistory();
        }
    }

    private boolean contains(Item item, double time) {
        double start = item.iter.getStartTime();
        double end = item.iter.getEndTime();
        if (time == start) {
            return true;
        }
        if (time < start) {
            return false;
        }
        return !(time >= end);
    }

    private CharSequence formatNumber(Object value) {
        return value instanceof Float ? this.floatFormatter.format(value) : this.numberFormatter.format(value);
    }

    private CharSequence formatDouble(double value) {
        return this.numberFormatter.format(value);
    }

    public void setDecimalSeparator(DecimalSeparator separator) {
        this.decimalSeparator = separator;
    }

    public void setColumnSeparator(ColumnSeparator separator) {
        this.columnSeparator = separator;
    }

    public void setResample(boolean resample) {
        this.resample = resample;
    }

    public void setLineFeed(String lf) {
        this.lineFeed = lf;
    }

    public void setTimeFormat(Format format) {
        this.timeFormat = format;
    }

    public void setFloatFormat(Format format) {
        this.floatFormat = format;
    }

    public void setNumberFormat(Format format) {
        this.numberFormat = format;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setNumberInterpolation(ExportInterpolation interpolation) {
        this.numberInterpolation = interpolation;
    }

    private static String resolvePlatformLineFeed() {
        String osName = System.getProperty("os.name", "");
        if ((osName = osName.toLowerCase()).contains("windows")) {
            return "\r\n";
        }
        return "\n";
    }

    private Formatter evaluateFormatter(Format format, DecimalSeparator target) {
        DecimalSeparator formatSeparator;
        String onePointTwo = format.format(1.2);
        System.out.println("formatted zeroPointOne: " + onePointTwo);
        if (onePointTwo.indexOf(46) != -1) {
            formatSeparator = DecimalSeparator.DOT;
        } else if (onePointTwo.indexOf(44) != -1) {
            formatSeparator = DecimalSeparator.COMMA;
        } else {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(this.locale);
            formatSeparator = DecimalSeparator.fromChar(symbols.getDecimalSeparator());
        }
        switch (formatSeparator) {
            case COMMA: {
                switch (target) {
                    case COMMA: {
                        return new NopFormatter(format);
                    }
                    case DOT: {
                        return new ReplacingFormatter(format, ',', '.');
                    }
                }
            }
            case DOT: {
                switch (target) {
                    case COMMA: {
                        return new ReplacingFormatter(format, '.', ',');
                    }
                    case DOT: {
                        return new NopFormatter(format);
                    }
                }
            }
        }
        return new NopFormatter(format);
    }

    static interface Formatter {
        public String format(Object var1);
    }

    private class Item
    implements Comparable<Item> {
        String label;
        String variableReference;
        HistoryManager history;
        String historyItemId;
        String unit;
        StreamAccessor accessor;
        StreamIterator iter;

        private Item() {
        }

        public void open() throws HistoryException {
            this.accessor = this.history.openStream(this.historyItemId, "r");
            this.iter = new StreamIterator((ArrayAccessor)this.accessor);
        }

        public void close() {
            if (this.accessor != null) {
                try {
                    this.accessor.close();
                }
                catch (AccessorException accessorException) {}
            }
            this.accessor = null;
            this.iter = null;
        }

        @Override
        public int compareTo(Item o) {
            int i = this.label.compareTo(o.label);
            if (i != 0) {
                return i;
            }
            i = this.variableReference.compareTo(o.variableReference);
            if (i != 0) {
                return i;
            }
            i = this.historyItemId.compareTo(o.historyItemId);
            if (i != 0) {
                return i;
            }
            return 0;
        }

        public int hashCode() {
            int code = 8964;
            code = 13 * code + this.variableReference.hashCode();
            code = 13 * code + this.label.hashCode();
            code = 13 * code + this.historyItemId.hashCode();
            code = 13 * code + this.history.hashCode();
            return code;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Item)) {
                return false;
            }
            Item other = (Item)obj;
            if (!other.label.equals(this.label)) {
                return false;
            }
            if (!other.variableReference.equals(this.variableReference)) {
                return false;
            }
            if (!other.history.equals(this.history)) {
                return false;
            }
            return other.historyItemId.equals(this.historyItemId);
        }
    }

    static class NopFormatter
    implements Formatter {
        private final Format format;

        public NopFormatter(Format format) {
            this.format = format;
        }

        @Override
        public String format(Object number) {
            return this.format.format(number);
        }
    }

    static class ReplacingFormatter
    implements Formatter {
        private final Format format;
        private final char from;
        private final char to;

        public ReplacingFormatter(Format format, char from, char to) {
            this.format = format;
            this.from = from;
            this.to = to;
        }

        @Override
        public String format(Object number) {
            return this.format.format(number).replace(this.from, this.to);
        }
    }
}

