/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.wizard;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.MigrateModel;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.UserComponentMigration;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.SWTUtils;

public class MigrateWizard
extends Wizard {
    final String initial;
    MigratePage migratePage;
    IEclipsePreferences prefnode;
    private static final Comparator<MigrateModel.MigrationOperation> MIGRATION_OP_COMPARATOR = new Comparator<MigrateModel.MigrationOperation>(){

        @Override
        public int compare(MigrateModel.MigrationOperation o1, MigrateModel.MigrationOperation o2) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.instanceToMigrate.getName(), (Object)o2.instanceToMigrate.getName());
        }
    };

    public MigrateWizard(String initial) {
        this.initial = initial;
        this.setWindowTitle("Perform migration");
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(false);
        this.setDialogSettings(Activator.getDefault().getDialogSettings());
        this.prefnode = InstanceScope.INSTANCE.getNode("org.simantics.modeling.ui.wizard.MigrateWizard");
    }

    public void addPages() {
        this.migratePage = new MigratePage(this.initial);
        this.addPage((IWizardPage)this.migratePage);
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        int locationIndex = this.migratePage.locations.getSelectionIndex();
        if (locationIndex == -1) {
            return true;
        }
        if (this.migratePage.model == null || this.migratePage.model.instances.isEmpty()) {
            return true;
        }
        int[] sel = this.migratePage.instances.getSelectionIndices();
        TIntHashSet sels = new TIntHashSet();
        int[] nArray = sel;
        int n = sel.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sels.add(i);
            ++n2;
        }
        List ops = this.migratePage.model.sortedShownInstances;
        int index = 0;
        final ArrayList<MigrateModel.MigrationOperation> result = new ArrayList<MigrateModel.MigrationOperation>();
        for (MigrateModel.MigrationOperation op : ops) {
            if (sels.contains(index)) {
                result.add(op);
            }
            ++index;
        }
        if (result.isEmpty()) {
            return true;
        }
        try {
            String[] report = new String[1];
            this.getContainer().run(true, true, monitor -> {
                final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
                try {
                    try {
                        stringArray[0] = (String)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<String>(){

                            public String perform(WriteGraph graph) throws DatabaseException {
                                graph.markUndoPoint();
                                String report = UserComponentMigration.doMigration((IProgressMonitor)mon.newChild(500, 0), (WriteGraph)graph, (ArrayList)result);
                                UserComponentMigration.doPostMigration((IProgressMonitor)mon.newChild(500, 0), (WriteGraph)graph, (ArrayList)result);
                                mon.setTaskName("Committing Changes");
                                mon.subTask("");
                                return report;
                            }
                        });
                        Set diagramsToReopen = (Set)Simantics.getSession().syncRequest(graph -> MigrateWizard.componentsToDiagrams(graph, ops));
                        SWTUtils.asyncExec((Display)this.getContainer().getShell().getDisplay(), () -> DiagramEditor.reinitializeDiagram(diagramsToReopen));
                    }
                    catch (DatabaseException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
            ReportDialog md = new ReportDialog(this.getShell(), report[0], 800, 500);
            md.open();
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof CancelTransactionException) && !(cause instanceof OperationCanceledException)) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Migration failed, see Error Log for details.", e.getCause()));
            }
        }
        catch (InterruptedException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Migration interrupted, see Error Log for details.", (Throwable)e));
        }
        return false;
    }

    private static final Set<Resource> componentsToDiagrams(ReadGraph graph, Collection<MigrateModel.MigrationOperation> ops) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        HashSet<Resource> diagrams = new HashSet<Resource>();
        for (MigrateModel.MigrationOperation op : ops) {
            Resource diagram;
            Resource composite = graph.getPossibleObject(op.instanceToMigrate.getResource(), L0.PartOf);
            if (composite == null || (diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram)) == null) continue;
            diagrams.add(diagram);
        }
        return diagrams;
    }

    private static abstract class BrowseContentRequest
    extends UnaryRead<String, Map<String, Pair<String, ImageDescriptor>>> {
        public BrowseContentRequest(String uri) {
            super((Object)uri);
        }

        public Map<String, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
            Resource root = graph.getPossibleResource((String)this.parameter);
            if (root == null) {
                return null;
            }
            THashMap result = new THashMap();
            Collection<NamedResource> infos = this.getVersions(graph, root);
            for (NamedResource info : infos) {
                result.put(graph.getURI(info.getResource()), Pair.make((Object)Versions.getStandardPathNameString((ReadGraph)graph, (Resource)info.getResource()), null));
            }
            return result;
        }

        protected abstract Collection<NamedResource> getVersions(ReadGraph var1, Resource var2) throws DatabaseException;
    }

    private static class BrowseSourceContentRequest
    extends BrowseContentRequest {
        public BrowseSourceContentRequest(String uri) {
            super(uri);
        }

        @Override
        protected Collection<NamedResource> getVersions(ReadGraph graph, Resource root) throws DatabaseException {
            return Versions.getOlderVersions((ReadGraph)graph, (Resource)root);
        }
    }

    private static class BrowseTargetContentRequest
    extends BrowseContentRequest {
        public BrowseTargetContentRequest(String uri) {
            super(uri);
        }

        @Override
        protected Collection<NamedResource> getVersions(ReadGraph graph, Resource root) throws DatabaseException {
            return Versions.getNewerVersions((ReadGraph)graph, (Resource)root);
        }
    }

    class MigratePage
    extends WizardPage {
        String initial;
        MigrateModel model;
        Text source;
        Button browseSource;
        Text target;
        Button browseTarget;
        Label symbolsLabel;
        CCombo symbols;
        Label instanceLabel;
        Label locationsLabel;
        CCombo locations;
        Composite buttonBar;
        Label instancesLabel;
        org.eclipse.swt.widgets.List instances;
        String previouslySelectedLocationId;
        Listener validateListener;

        public MigratePage(String initial) {
            super("Perform migration", "Perform migration", null);
            this.previouslySelectedLocationId = null;
            this.validateListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 24: {
                            MigratePage.this.validatePage();
                        }
                        case 13: {
                            MigratePage.this.validatePage();
                            break;
                        }
                        case 15: {
                            if (!(event.widget instanceof Text)) break;
                            Text t = (Text)event.widget;
                            t.selectAll();
                        }
                    }
                }
            };
            this.initial = initial;
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 20;
            layout.verticalSpacing = 10;
            layout.numColumns = 10;
            container.setLayout((Layout)layout);
            new Label(container, 0).setText("&Source:");
            this.source = new Text(container, 2048);
            this.source.setText(this.initial);
            this.source.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MigratePage.this.refreshModel();
                    MigratePage.this.refreshInstances();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(8, 1).applyTo((Control)this.source);
            this.browseSource = new Button(container, 0);
            this.browseSource.setText("&Browse");
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.browseSource);
            this.browseSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e_) {
                    try {
                        Map map = (Map)Simantics.getSession().syncRequest((Read)new BrowseSourceContentRequest(MigratePage.this.target.getText()));
                        String uri = MigratePage.this.queryTargetSelection("Select Source Type", map);
                        if (uri != null) {
                            MigratePage.this.source.setText(uri);
                        }
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            });
            new Label(container, 0).setText("&Target:");
            this.target = new Text(container, 2048);
            this.target.setText(this.initial);
            this.target.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MigratePage.this.refreshSymbols();
                    MigratePage.this.refreshModel();
                    MigratePage.this.refreshInstances();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(8, 1).applyTo((Control)this.target);
            this.browseTarget = new Button(container, 0);
            this.browseTarget.setText("B&rowse");
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.browseTarget);
            this.browseTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e_) {
                    try {
                        Map map = (Map)Simantics.getSession().syncRequest((Read)new BrowseTargetContentRequest(MigratePage.this.source.getText()));
                        String uri = MigratePage.this.queryTargetSelection("Select Target Type", map);
                        if (uri != null) {
                            MigratePage.this.target.setText(uri);
                        }
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            });
            this.symbolsLabel = new Label(container, 0);
            this.symbolsLabel.setText("Target &symbol:");
            GridDataFactory.fillDefaults().applyTo((Control)this.symbolsLabel);
            this.symbols = new CCombo(container, 2056);
            this.symbols.setVisibleItemCount(10);
            this.symbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MigratePage.this.refreshModel();
                    MigratePage.this.refreshInstances();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(9, 1).applyTo((Control)this.symbols);
            this.instanceLabel = new Label(container, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(10, 1).applyTo((Control)this.instanceLabel);
            this.instanceLabel.setText("");
            this.locationsLabel = new Label(container, 0);
            this.locationsLabel.setText("&Locations:");
            this.locations = new CCombo(container, 2056);
            this.locations.setVisibleItemCount(25);
            this.locations.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = MigratePage.this.locations.getSelectionIndex();
                    if (index >= 0 && index < MigratePage.this.model.instances.size()) {
                        MigratePage.this.previouslySelectedLocationId = (String)((Triple)MigratePage.this.model.instances.get((int)index)).first;
                    }
                    MigratePage.this.refreshInstances();
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(9, 1).applyTo((Control)this.locations);
            this.instancesLabel = new Label(container, 0);
            this.instancesLabel.setText("&Select instances to migrate:");
            GridDataFactory.fillDefaults().grab(true, false).span(10, 1).applyTo((Control)this.instancesLabel);
            this.buttonBar = new Composite(container, 0);
            RowLayoutFactory.fillDefaults().type(256).applyTo(this.buttonBar);
            GridDataFactory.fillDefaults().grab(true, false).span(10, 1).applyTo((Control)this.buttonBar);
            Button selectAll = new Button(this.buttonBar, 8);
            selectAll.setText("Select &All");
            Button selectNone = new Button(this.buttonBar, 8);
            selectNone.setText("Select &None");
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MigratePage.this.instances.selectAll();
                }
            });
            selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MigratePage.this.instances.deselectAll();
                }
            });
            this.instances = new org.eclipse.swt.widgets.List(container, 2882);
            GridDataFactory.fillDefaults().grab(true, true).span(10, 1).applyTo((Control)this.instances);
            this.instances.addListener(24, this.validateListener);
            this.refreshSymbols();
            this.refreshModel();
            this.refreshInstances();
            this.setControl((Control)container);
            this.validatePage();
        }

        String queryTargetSelection(String title, Map<String, Pair<String, ImageDescriptor>> map) {
            Shell shell = this.source.getShell();
            ResourceSelectionDialog3<String> dialog = new ResourceSelectionDialog3<String>(shell, map, title, false){

                protected IDialogSettings getBaseDialogSettings() {
                    return Activator.getDefault().getDialogSettings();
                }
            };
            if (dialog.open() == 0) {
                return (String)dialog.getFirstResult();
            }
            return null;
        }

        void refreshSymbols() {
            try {
                final String uri = this.target.getText();
                Collection syms = (Collection)Simantics.getSession().syncRequest((Read)new UniqueRead<Collection<NamedResource>>(){

                    public Collection<NamedResource> perform(ReadGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                        THashSet result = new THashSet();
                        Resource componentType = graph.getResource(uri);
                        THashSet potentialSymbols = new THashSet();
                        potentialSymbols.addAll((Collection)graph.syncRequest((Read)new ObjectsWithType(componentType, L0.ConsistsOf, DIA.ElementClass)));
                        potentialSymbols.addAll(graph.getObjects(componentType, MOD.ComponentTypeToSymbol));
                        for (Resource symbol : potentialSymbols) {
                            if (!graph.hasStatement(symbol, MOD.SymbolToComponentType, componentType)) continue;
                            String name = (String)graph.getRelatedValue(symbol, L0.HasName, (Binding)Bindings.STRING);
                            if (!graph.hasStatement(symbol, MOD.SymbolToComponentType, componentType)) continue;
                            result.add(new NamedResource(name, symbol));
                        }
                        return new ArrayList<NamedResource>((Collection<NamedResource>)result);
                    }
                });
                this.symbols.removeAll();
                this.symbols.add("<retain symbol name>");
                for (NamedResource nr : syms) {
                    this.symbols.add(nr.getName());
                }
                this.symbols.setData((Object)syms);
                this.symbols.select(0);
                if (syms.isEmpty()) {
                    this.symbolsLabel.setVisible(false);
                    this.symbols.setVisible(false);
                    GridDataFactory.fillDefaults().exclude(true).applyTo((Control)this.symbolsLabel);
                    GridDataFactory.fillDefaults().exclude(true).grab(true, false).span(9, 1).applyTo((Control)this.symbols);
                } else {
                    this.symbolsLabel.setVisible(true);
                    this.symbols.setVisible(true);
                    GridDataFactory.fillDefaults().applyTo((Control)this.symbolsLabel);
                    GridDataFactory.fillDefaults().grab(true, false).span(9, 1).applyTo((Control)this.symbols);
                }
                this.symbols.getParent().layout();
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }

        void refreshModel() {
            final String sourceText = this.source.getText();
            final String targetText = this.target.getText();
            int symbolIndex = this.symbols.getSelectionIndex();
            Resource symbol = null;
            if (symbolIndex > 0) {
                List nrs = (List)this.symbols.getData();
                symbol = ((NamedResource)nrs.get(symbolIndex - 1)).getResource();
            }
            final Resource finalSymbol = symbol;
            try {
                this.model = (MigrateModel)Simantics.getSession().syncRequest((Read)new UniqueRead<MigrateModel>(){

                    public MigrateModel perform(ReadGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                        Resource source = graph.getPossibleResource(sourceText);
                        if (source == null) {
                            return MigratePage.this.model;
                        }
                        Resource target = graph.getPossibleResource(targetText);
                        if (target == null) {
                            return MigratePage.this.model;
                        }
                        if (graph.isInstanceOf(source, STR.ComponentType)) {
                            return UserComponentMigration.getComponentTypeModel((ReadGraph)graph, (Resource)source, (Resource)target, (Resource)finalSymbol);
                        }
                        if (graph.isInstanceOf(source, L0.SharedOntology)) {
                            return UserComponentMigration.getSharedOntologyModel((ReadGraph)graph, (Resource)source, (Resource)target);
                        }
                        return null;
                    }
                });
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            this.instances.removeAll();
            this.locations.removeAll();
            if (this.model == null) {
                return;
            }
            int preSelect = -1;
            int i = 0;
            for (Triple r : this.model.instances) {
                this.locations.add(String.valueOf(((NamedResource)r.second).getName()) + " (" + ((Collection)r.third).size() + " instances)");
                if (((String)r.first).equals(this.previouslySelectedLocationId)) {
                    preSelect = i;
                }
                if (preSelect < 0 && this.model.activeModels.contains(((NamedResource)r.second).getResource())) {
                    preSelect = i;
                }
                ++i;
            }
            if (this.locations.getItemCount() == 0) {
                this.locations.add("<no instances were found>");
                this.locations.select(0);
            } else {
                this.locations.select(preSelect > -1 ? preSelect : 0);
            }
        }

        void refreshInstances() {
            int toMigrate = 0;
            for (Triple pair : this.model.instances) {
                toMigrate += ((Collection)pair.third).size();
            }
            if (this.model.instanceCount == 0) {
                this.instanceLabel.setText("No instances were found.");
            } else if (this.model.instanceCount == 1) {
                if (toMigrate == 1) {
                    this.instanceLabel.setText("1 migratable instance found.");
                } else {
                    this.instanceLabel.setText("1 instance found, but it cannot be migrated with current settings.");
                }
            } else if (toMigrate < this.model.instanceCount) {
                if (toMigrate == 0) {
                    this.instanceLabel.setText(String.valueOf(this.model.instanceCount) + " instances were found. None of them can be migrated with current settings.");
                } else {
                    this.instanceLabel.setText(String.valueOf(this.model.instanceCount) + " instances were found. " + (this.model.instanceCount - toMigrate) + " of them cannot be migrated with current settings.");
                }
            } else {
                this.instanceLabel.setText(String.valueOf(this.model.instanceCount) + " migratable instances found. ");
            }
            this.instances.removeAll();
            if (this.model == null) {
                return;
            }
            if (toMigrate == 0) {
                this.locationsLabel.setVisible(false);
                this.locations.setVisible(false);
                GridDataFactory.fillDefaults().exclude(true).applyTo((Control)this.locationsLabel);
                GridDataFactory.fillDefaults().exclude(true).grab(true, false).span(9, 1).applyTo((Control)this.locations);
            } else {
                this.locationsLabel.setVisible(true);
                this.locations.setVisible(true);
                GridDataFactory.fillDefaults().applyTo((Control)this.locationsLabel);
                GridDataFactory.fillDefaults().grab(true, false).span(9, 1).applyTo((Control)this.locations);
            }
            if (!this.model.instances.isEmpty()) {
                int locationIndex = this.locations.getSelectionIndex();
                if (locationIndex == -1) {
                    return;
                }
                this.model.sortedShownInstances = new ArrayList();
                for (MigrateModel.MigrationOperation o : (Collection)((Triple)this.model.instances.get((int)locationIndex)).third) {
                    this.model.sortedShownInstances.add(o);
                }
                Collections.sort(this.model.sortedShownInstances, MIGRATION_OP_COMPARATOR);
                for (MigrateModel.MigrationOperation o : this.model.sortedShownInstances) {
                    String uri = o.toString();
                    uri = uri.replace("http://Projects/Development%20Project/", "");
                    uri = URIStringUtils.unescape((String)uri);
                    this.instances.add(uri);
                }
            }
            if (this.model.sortedShownInstances.isEmpty()) {
                this.instancesLabel.setVisible(false);
                this.instances.setVisible(false);
                this.buttonBar.setVisible(false);
                GridDataFactory.fillDefaults().exclude(true).grab(true, false).span(9, 1).applyTo((Control)this.instancesLabel);
                GridDataFactory.fillDefaults().exclude(true).grab(true, true).span(10, 1).applyTo((Control)this.instances);
                GridDataFactory.fillDefaults().exclude(true).grab(true, false).span(10, 1).applyTo((Control)this.buttonBar);
            } else {
                GridDataFactory.fillDefaults().grab(true, false).span(9, 1).applyTo((Control)this.instancesLabel);
                GridDataFactory.fillDefaults().grab(true, true).span(10, 1).applyTo((Control)this.instances);
                GridDataFactory.fillDefaults().grab(true, false).span(10, 1).applyTo((Control)this.buttonBar);
                this.instancesLabel.setVisible(true);
                this.instances.setVisible(true);
                this.buttonBar.setVisible(true);
            }
            this.locations.getParent().layout();
        }

        private void validatePage() {
            this.setMessage(null);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    static class ReportDialog
    extends MessageDialog {
        private final String report;
        private final int initialWidth;
        private final int initialHeight;

        public ReportDialog(Shell shell, String report, int width, int height) {
            super(shell, "Migration report", null, "", 2, new String[]{"Continue"}, 0);
            this.report = report;
            this.initialWidth = width;
            this.initialHeight = height;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Point getInitialSize() {
            return new Point(this.initialWidth, this.initialHeight);
        }

        protected Control createCustomArea(Composite composite) {
            GridLayoutFactory.fillDefaults().applyTo(composite);
            Text text = new Text(composite, 2570);
            text.setText(this.report);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
            return composite;
        }
    }

    static abstract class SelectionAdapter
    implements SelectionListener {
        SelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

