/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class StandardCopyHandler
extends AbstractHandler {
    private static IStatusLineManager status;

    private static List<Variable> getVariables(ISelection selection) {
        IHintContext hints;
        NodeContext context = (NodeContext)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
        if (context == null) {
            return Collections.emptyList();
        }
        Object input = context.getConstant(BuiltinKeys.INPUT);
        IHintContext iHintContext = hints = input instanceof IHintContext ? (IHintContext)input : null;
        if (hints == null) {
            return Collections.emptyList();
        }
        Variable var = (Variable)hints.getHint(SelectionHints.KEY_SELECTION_PROPERTY);
        if (var == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(var);
    }

    private boolean copyText(ISelection selection) {
        Object element;
        StructuredSelection sel;
        if (selection instanceof StructuredSelection && (sel = (StructuredSelection)selection).size() == 1 && (element = sel.getFirstElement()) instanceof String) {
            StandardCopyHandler.setSystemClipboardText((String)element);
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        status = WorkbenchUtils.getStatusLine((IWorkbenchSite)HandlerUtil.getActiveSite((ExecutionEvent)event));
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (this.copyText(selection)) {
            return null;
        }
        this.formatSelectionToClipboardText(event);
        Resource[] rs = ResourceAdaptionUtils.toResources((Object)selection);
        StandardCopyHandler.copyResourcesToClipboard(rs, selection);
        return null;
    }

    public static String copyResourcesToClipboard(final Resource[] rs, ISelection selection) {
        if (rs == null || rs.length == 0) {
            List<Variable> variables = StandardCopyHandler.getVariables(selection);
            if (!variables.isEmpty()) {
                SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
                for (Variable var : variables) {
                    builder.addContent(Collections.singleton(ClipboardUtils.createVariable((RequestProcessor)Simantics.getSession(), (Variable)var)));
                }
                Simantics.setClipboard((SimanticsClipboard)builder);
                StandardCopyHandler.setCopyMessage(builder.getContents().size(), "variable");
                return null;
            }
            StandardCopyHandler.setCopyMessage(0, "");
            return null;
        }
        try {
            final SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Resource[] resourceArray = rs;
                    int n = rs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource r = resourceArray[n2];
                        CopyHandler handler = (CopyHandler)graph.adapt(r, CopyHandler.class);
                        handler.copyToClipboard(graph, (SimanticsClipboardBuilder)builder);
                        ++n2;
                    }
                }
            });
            Simantics.setClipboard((SimanticsClipboard)builder);
            StandardCopyHandler.setCopyMessage(builder.getContents().size(), "resource");
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private static void setCopyMessage(int count, String elementName) {
        if (count > 1) {
            StandardCopyHandler.setStatus("Copied " + count + " " + elementName + "s to clipboard");
        } else if (count == 1) {
            StandardCopyHandler.setStatus("Copied " + elementName + " to clipboard");
        } else {
            StandardCopyHandler.setStatus("Nothing to copy.");
        }
    }

    private static void setStatus(String message) {
        if (status != null) {
            status.setMessage(message);
        }
    }

    private boolean formatSelectionToClipboardText(ExecutionEvent event) {
        Tree tree;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Tree tree2 = tree = shell == null ? null : StandardCopyHandler.tryGetExplorer(shell.getDisplay().getFocusControl());
        if (tree == null) {
            return false;
        }
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            return false;
        }
        StringBuilder sb = StandardCopyHandler.format(selection, new StringBuilder());
        if (sb.length() > 0) {
            StandardCopyHandler.setSystemClipboardText(sb.toString());
            return true;
        }
        return false;
    }

    private static StringBuilder format(TreeItem[] selection, StringBuilder sb) {
        THashSet items = new THashSet(selection.length);
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            items.add(item);
            ++n2;
        }
        boolean firstRow = true;
        TreeItem[] treeItemArray2 = selection;
        int n3 = selection.length;
        n = 0;
        while (n < n3) {
            TreeItem item = treeItemArray2[n];
            if (!firstRow) {
                sb.append('\n');
            }
            firstRow = false;
            int cc = item.getParent().getColumnCount();
            int indent = StandardCopyHandler.indentLevel(item, (Set<TreeItem>)items);
            int i = 0;
            while (i < indent) {
                sb.append('\t');
                ++i;
            }
            boolean firstColumn = true;
            int c = 0;
            while (c < cc) {
                String ct = item.getText(c);
                if (!firstColumn) {
                    sb.append('\t');
                }
                firstColumn = false;
                sb.append(ct);
                ++c;
            }
            ++n;
        }
        return sb;
    }

    private static int indentLevel(TreeItem item, Set<TreeItem> items) {
        TreeItem p = item.getParentItem();
        int i = 1;
        while (p != null) {
            if (items.contains(p)) {
                return i;
            }
            p = p.getParentItem();
        }
        return 0;
    }

    private static Tree tryGetExplorer(Control control) {
        return (Tree)SWTUtils.tryGetObject((Control)control, (SWTUtils.ControlFilter)new SWTUtils.ControlFilter<Tree>(){

            public Tree accept(Control control) {
                if (!control.isDisposed() && control instanceof Tree && control.getData("GraphExplorer") != null) {
                    return (Tree)control;
                }
                return null;
            }
        });
    }

    private static void setSystemClipboardText(String text) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }
}

