/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.Page;
import org.simantics.diagram.layer.ILayersViewPage;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.layers.IEditableLayer;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.layers.SimpleLayer;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.ISelectionUtils;

public class DiagramLayersPage
extends Page
implements ILayersViewPage {
    private static final String TEXT_APPLY_FOCUS_SETTINGS = "Focus Active";
    private static final String TOOLTIP_APPLY_FOCUS_SETTINGS = "Only Focus Diagram Elements For Active Roles";
    private static final String TEXT_IGNORE_FOCUS_SETTINGS = "Focus All";
    private static final String TOOLTIP_IGNORE_FOCUS_SETTINGS = "Focus All Diagram Elements Regardless Of Active Roles";
    private static final String TEXT_APPLY_VISIBILITY_SETTINGS = "Show Active";
    private static final String TOOLTIP_APPLY_VISIBILITY_SETTINGS = "Only Show Diagram Elements For Active Roles";
    private static final String TEXT_IGNORE_VISIBILITY_SETTINGS = "Show All";
    private static final String TOOLTIP_IGNORE_VISIBILITY_SETTINGS = "Show All Diagram Elements Regardless Of Active Roles";
    private final ICanvasContext context;
    private final IDiagram diagram;
    private CheckboxTreeViewer viewer;
    private Composite composite;
    private TreeEditor editor;
    private Collection<IElement> elements = Collections.emptySet();
    private final IHintListener selectionListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            Collection<Object> es = Collections.emptySet();
            if (newValue instanceof Collection) {
                Collection coll = (Collection)newValue;
                es = new ArrayList(coll.size());
                for (Object o : coll) {
                    if (!(o instanceof IElement)) {
                        return;
                    }
                    es.add((IElement)o);
                }
                if (es.isEmpty()) {
                    es = Collections.emptySet();
                }
            }
            DiagramLayersPage.this.elements = es;
            this.redraw();
        }

        private void redraw() {
            DiagramLayersPage.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DiagramLayersPage.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    DiagramLayersPage.this.viewer.getControl().redraw();
                }
            });
        }
    };

    Boolean getAttribute(IElement e, ILayer layer, Attribute attribute) {
        ElementClass ec = e.getElementClass();
        for (ElementLayers el : ec.getItemsByClass(ElementLayers.class)) {
            switch (attribute) {
                case Visible: {
                    return el.isVisible(e, layer);
                }
                case Focusable: {
                    return el.isFocusable(e, layer);
                }
            }
        }
        return null;
    }

    boolean setAttribute(IElement e, ILayer layer, Attribute attribute, boolean value) {
        ElementClass ec = e.getElementClass();
        for (ElementLayers el : ec.getItemsByClass(ElementLayers.class)) {
            switch (attribute) {
                case Visible: {
                    return el.setVisibility(e, layer, value);
                }
                case Focusable: {
                    return el.setFocusability(e, layer, value);
                }
            }
        }
        return false;
    }

    Tristate getJointAttribute(Collection<IElement> elements, ILayer layer, Attribute attribute) {
        Tristate state = null;
        for (IElement e : elements) {
            Boolean attr = this.getAttribute(e, layer, attribute);
            if (attr == null) continue;
            state = state == null ? Tristate.to(attr) : state.merge(Tristate.to(attr));
        }
        return state;
    }

    int setAttribute(Collection<IElement> elements, ILayer layer, Attribute attribute, boolean value) {
        int result = 0;
        for (IElement e : elements) {
            if (!this.setAttribute(e, layer, attribute, value)) continue;
            ++result;
        }
        return result;
    }

    public DiagramLayersPage(IDiagram diagram, ICanvasContext context) {
        assert (diagram != null);
        this.diagram = diagram;
        this.context = context;
        context.getDefaultHintContext().addKeyHintListener((IHintContext.Key)Selection.SELECTION0, this.selectionListener);
    }

    public void dispose() {
        this.context.getDefaultHintContext().removeKeyHintListener((IHintContext.Key)Selection.SELECTION0, this.selectionListener);
        super.dispose();
    }

    public void createControl(Composite parent) {
        final ILayersEditor layers = (ILayersEditor)this.diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        layers.addListener(new ILayersEditor.ILayersEditorListener(){

            public void layerRemoved(ILayer layer) {
                this.scheduleRefresh();
            }

            public void layerAdded(ILayer layer) {
                this.scheduleRefresh();
            }

            public void layerActivated(ILayer layer) {
                this.scheduleRefresh();
            }

            public void layerDeactivated(ILayer layer) {
                this.scheduleRefresh();
            }

            public void ignoreFocusChanged(boolean value) {
            }

            public void ignoreVisibilityChanged(boolean value) {
            }

            void scheduleRefresh() {
                DiagramLayersPage.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DiagramLayersPage.this.viewer.refresh();
                    }
                });
            }
        });
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.composite);
        Button addButton = new Button(this.composite, 0);
        addButton.setText("New");
        addButton.setToolTipText("Create New Diagram Role");
        addButton.addSelectionListener(new SelectionListener(){

            String findFreshName(ILayers layers2, String proposal) {
                Set all = layers2.getLayers();
                String name = proposal;
                int i = 1;
                while (true) {
                    boolean match = false;
                    for (ILayer layer : all) {
                        if (!name.equals(layer.getName())) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        return name;
                    }
                    name = String.valueOf(proposal) + " " + ++i;
                }
            }

            public void widgetSelected(SelectionEvent e) {
                String name = this.findFreshName((ILayers)layers, "New Role");
                SimpleLayer layer = new SimpleLayer(name);
                layers.addLayer((ILayer)layer);
                layers.activate((ILayer)layer);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button removeButton = new Button(this.composite, 0);
        removeButton.setText("Remove");
        removeButton.setToolTipText("Remove Selected Diagram Role");
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = DiagramLayersPage.this.viewer.getTree().getSelection();
                if (items.length == 0) {
                    return;
                }
                Object[] all = DiagramLayersPage.this.viewer.getTree().getItems();
                int firstIndex = Arrays.indexOf((Object[])all, (Object)items[0]);
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    int index = Arrays.indexOf((Object[])all, (Object)item);
                    all[index] = null;
                    ILayer layer = (ILayer)item.getData();
                    layers.removeLayer(layer);
                    ++n2;
                }
                int selectIndex = firstIndex - 1;
                if (firstIndex == 0) {
                    int i = firstIndex;
                    while (i < all.length) {
                        if (all[i] != null) {
                            selectIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (selectIndex >= 0) {
                    DiagramLayersPage.this.viewer.getTree().select((TreeItem)all[selectIndex]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        String ignoreVisibilityText = TEXT_IGNORE_VISIBILITY_SETTINGS;
        String ignoreVisibilityTooltip = TOOLTIP_IGNORE_VISIBILITY_SETTINGS;
        boolean ignoreVisibility = layers.getIgnoreVisibilitySettings();
        if (ignoreVisibility) {
            ignoreVisibilityText = TEXT_APPLY_VISIBILITY_SETTINGS;
            ignoreVisibilityTooltip = TOOLTIP_APPLY_VISIBILITY_SETTINGS;
        }
        final Button ignoreVisibilityButton = new Button(this.composite, 0);
        ignoreVisibilityButton.setText(ignoreVisibilityText);
        ignoreVisibilityButton.setToolTipText(ignoreVisibilityTooltip);
        ignoreVisibilityButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String ignoreText = DiagramLayersPage.TEXT_IGNORE_VISIBILITY_SETTINGS;
                String ignoreTooltip = DiagramLayersPage.TOOLTIP_IGNORE_VISIBILITY_SETTINGS;
                boolean ignore = layers.getIgnoreVisibilitySettings();
                if (!ignore) {
                    ignoreText = DiagramLayersPage.TEXT_APPLY_VISIBILITY_SETTINGS;
                    ignoreTooltip = DiagramLayersPage.TOOLTIP_APPLY_VISIBILITY_SETTINGS;
                    layers.setIgnoreVisibilitySettings(true);
                } else {
                    layers.setIgnoreVisibilitySettings(false);
                }
                ignoreVisibilityButton.setText(ignoreText);
                ignoreVisibilityButton.setToolTipText(ignoreTooltip);
                DiagramLayersPage.this.composite.layout();
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        String ignoreFocusText = TEXT_IGNORE_FOCUS_SETTINGS;
        String ignoreFocusTooltip = TOOLTIP_IGNORE_FOCUS_SETTINGS;
        boolean ignoreFocus = layers.getIgnoreFocusSettings();
        if (ignoreFocus) {
            ignoreFocusText = TEXT_APPLY_FOCUS_SETTINGS;
            ignoreFocusTooltip = TOOLTIP_APPLY_FOCUS_SETTINGS;
        }
        final Button ignoreFocusButton = new Button(this.composite, 0);
        ignoreFocusButton.setText(ignoreFocusText);
        ignoreFocusButton.setToolTipText(ignoreFocusTooltip);
        ignoreFocusButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String ignoreText = DiagramLayersPage.TEXT_IGNORE_FOCUS_SETTINGS;
                String ignoreTooltip = DiagramLayersPage.TOOLTIP_IGNORE_FOCUS_SETTINGS;
                boolean ignore = layers.getIgnoreFocusSettings();
                if (!ignore) {
                    ignoreText = DiagramLayersPage.TEXT_APPLY_FOCUS_SETTINGS;
                    ignoreTooltip = DiagramLayersPage.TOOLTIP_APPLY_FOCUS_SETTINGS;
                    layers.setIgnoreFocusSettings(true);
                } else {
                    layers.setIgnoreFocusSettings(false);
                }
                ignoreFocusButton.setText(ignoreText);
                ignoreFocusButton.setToolTipText(ignoreTooltip);
                DiagramLayersPage.this.composite.layout();
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer = new CheckboxTreeViewer(this.composite, 67584);
        GridDataFactory.fillDefaults().grab(true, true).span(4, 1).applyTo(this.viewer.getControl());
        this.viewer.getControl().setToolTipText("Selects the diagram to include in the exported document.");
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.getTree().setHeaderVisible(true);
        this.editor = new TreeEditor(this.viewer.getTree());
        final TreeColumn column1 = new TreeColumn(this.viewer.getTree(), 16384);
        column1.setText("Role");
        column1.setWidth(100);
        final TreeColumn column2 = new TreeColumn(this.viewer.getTree(), 16384);
        column2.setText("Show");
        column2.setWidth(50);
        final TreeColumn column3 = new TreeColumn(this.viewer.getTree(), 16384);
        column3.setText("Focus");
        column3.setWidth(50);
        this.viewer.getTree().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Tree tree = DiagramLayersPage.this.viewer.getTree();
                Point size = tree.getSize();
                int w = Math.max(size.x - 100 - tree.getBorderWidth() * 2, 30);
                column1.setWidth(w);
            }
        });
        this.viewer.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (!(event.index != 1 && event.index != 2 || DiagramLayersPage.this.elements.isEmpty())) {
                    ILayer[] lz = layers.getLayers().toArray(new ILayer[0]);
                    TreeItem item = (TreeItem)event.item;
                    int index = DiagramLayersPage.this.viewer.getTree().indexOf(item);
                    int width = 0;
                    if (event.index == 1) {
                        width = column2.getWidth() - 1;
                    }
                    if (event.index == 2) {
                        width = column3.getWidth() - 1;
                    }
                    Attribute attribute = Attribute.Visible;
                    if (event.index == 2) {
                        attribute = Attribute.Focusable;
                    }
                    Tristate state = DiagramLayersPage.this.getJointAttribute(DiagramLayersPage.this.elements, lz[index], attribute);
                    Color color = null;
                    switch (state) {
                        case False: {
                            color = DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(3);
                            break;
                        }
                        case True: {
                            color = DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(5);
                            break;
                        }
                        case Both: {
                            color = DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(15);
                        }
                    }
                    GC gc = event.gc;
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    gc.setBackground(color);
                    gc.setForeground(DiagramLayersPage.this.viewer.getTree().getDisplay().getSystemColor(2));
                    gc.fillRectangle(event.x, event.y, width - 1, event.height - 1);
                    Rectangle rect2 = new Rectangle(event.x, event.y, width - 1, event.height - 1);
                    gc.drawRectangle(rect2);
                    gc.setForeground(background);
                    gc.setBackground(foreground);
                }
            }
        });
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B) {
                    System.out.println("startediting");
                    TreeItem[] items = DiagramLayersPage.this.viewer.getTree().getSelection();
                    if (items.length != 1) {
                        return;
                    }
                    TreeItem item = items[0];
                    ILayer layer = (ILayer)ISelectionUtils.filterSingleSelection((Object)DiagramLayersPage.this.viewer.getSelection(), ILayer.class);
                    if (layer == null) {
                        return;
                    }
                    DiagramLayersPage.this.startEditing(layer, item);
                }
            }
        });
        this.viewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (DiagramLayersPage.this.viewer.getControl().isDisposed()) {
                    return;
                }
                Point pt = new Point(event.x, event.y);
                TreeItem item = DiagramLayersPage.this.viewer.getTree().getItem(pt);
                if (item == null) {
                    return;
                }
                int index = DiagramLayersPage.this.viewer.getTree().indexOf(item);
                ILayer[] lz = layers.getLayers().toArray(new ILayer[0]);
                ILayer layer = lz[index];
                Rectangle rect = item.getBounds(0);
                if (event.count == 2 && rect.contains(pt)) {
                    DiagramLayersPage.this.startEditing(layer, item);
                    return;
                }
                if (DiagramLayersPage.this.elements.isEmpty()) {
                    return;
                }
                rect = item.getBounds(1);
                if (rect.contains(pt)) {
                    Tristate state = DiagramLayersPage.this.getJointAttribute(DiagramLayersPage.this.elements, layer, Attribute.Visible);
                    if (DiagramLayersPage.this.setAttribute(DiagramLayersPage.this.elements, layer, Attribute.Visible, state.toggle().toBoolean()) > 0) {
                        this.refresh();
                    }
                    return;
                }
                Rectangle rect2 = item.getBounds(2);
                if (rect2.contains(pt)) {
                    Tristate state = DiagramLayersPage.this.getJointAttribute(DiagramLayersPage.this.elements, layer, Attribute.Focusable);
                    if (DiagramLayersPage.this.setAttribute(DiagramLayersPage.this.elements, layer, Attribute.Focusable, state.toggle().toBoolean()) > 0) {
                        this.refresh();
                    }
                    return;
                }
            }

            private void refresh() {
                DiagramLayersPage.this.viewer.getControl().redraw();
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ILayer layer = (ILayer)event.getElement();
                if (event.getChecked()) {
                    layers.activate(layer);
                } else {
                    layers.deactivate(layer);
                }
                DiagramLayersPage.this.viewer.setSubtreeChecked(event.getElement(), event.getChecked());
                DiagramLayersPage.this.context.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DiagramLayersPage.this.context.isDisposed()) {
                            return;
                        }
                        DiagramLayersPage.this.context.getContentContext().setDirty();
                    }
                });
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty()) {
                    removeButton.setEnabled(false);
                } else {
                    removeButton.setEnabled(true);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return layers.getLayers().toArray();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getColumnIndex() == 0) {
                    ILayer layer = (ILayer)cell.getElement();
                    cell.setText(layer.getName());
                } else {
                    cell.setText("");
                }
            }
        });
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                ILayer layer = (ILayer)element;
                boolean isActive = layers.isActive(layer);
                return isActive;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.viewer.setInput((Object)this);
        for (ILayer layer : layers.getVisibleLayers()) {
            this.viewer.setSubtreeChecked((Object)layer, true);
        }
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    private boolean startEditing(final ILayer layer, final TreeItem item) {
        String initialText = layer.getName();
        final Composite composite = new Composite((Composite)this.viewer.getTree(), 0);
        final Text text = new Text(composite, 2048);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = composite.getClientArea();
                text.setBounds(rect.x + 0, rect.y + 0, rect.width - 0, rect.height - 0);
            }
        });
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                block0 : switch (e.type) {
                    case 16: {
                        if (layer instanceof IEditableLayer) {
                            IEditableLayer l = (IEditableLayer)layer;
                            l.setName(text.getText());
                            System.out.println("renamed layer to " + text.getText());
                            DiagramLayersPage.this.viewer.refresh();
                        }
                        composite.dispose();
                        break;
                    }
                    case 24: {
                        break;
                    }
                    case 25: {
                        String newText = text.getText();
                        String leftText = newText.substring(0, e.start);
                        String rightText = newText.substring(e.end, newText.length());
                        GC gc = new GC((Drawable)text);
                        Point size = gc.textExtent(String.valueOf(leftText) + e.text + rightText);
                        gc.dispose();
                        size = text.computeSize(size.x, -1);
                        ((DiagramLayersPage)DiagramLayersPage.this).editor.horizontalAlignment = 16384;
                        Rectangle itemRect = item.getBounds(0);
                        Rectangle rect = DiagramLayersPage.this.viewer.getTree().getClientArea();
                        ((DiagramLayersPage)DiagramLayersPage.this).editor.minimumWidth = Math.max(size.x, itemRect.width) + 0;
                        int left = itemRect.x;
                        int right = rect.x + rect.width;
                        ((DiagramLayersPage)DiagramLayersPage.this).editor.minimumWidth = Math.min(((DiagramLayersPage)DiagramLayersPage.this).editor.minimumWidth, right - left);
                        ((DiagramLayersPage)DiagramLayersPage.this).editor.minimumHeight = size.y + 0;
                        DiagramLayersPage.this.editor.layout();
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                if (layer instanceof IEditableLayer) {
                                    IEditableLayer l = (IEditableLayer)layer;
                                    l.setName(text.getText());
                                    DiagramLayersPage.this.viewer.refresh();
                                }
                            }
                            case 2: {
                                composite.dispose();
                                e.doit = false;
                                break block0;
                            }
                        }
                    }
                }
            }
        };
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        text.addListener(25, textListener);
        text.addListener(24, textListener);
        this.editor.setEditor((Control)composite, item, 0);
        text.setText(initialText);
        text.selectAll();
        text.setFocus();
        return true;
    }

    static enum Attribute {
        Visible,
        Focusable;

    }

    static enum Tristate {
        True,
        False,
        Both;


        static Tristate to(Boolean b) {
            return b == null ? null : (b != false ? True : False);
        }

        boolean toBoolean() {
            switch (this) {
                case Both: {
                    throw new IllegalStateException("cannot convert Tristate Both to boolean");
                }
                case False: {
                    return false;
                }
                case True: {
                    return true;
                }
            }
            return false;
        }

        Tristate toggle() {
            switch (this) {
                case False: 
                case Both: {
                    return True;
                }
                case True: {
                    return False;
                }
            }
            return False;
        }

        Tristate merge(Tristate state) {
            if (state == null) {
                return this;
            }
            switch (this) {
                case Both: {
                    return Both;
                }
                case False: {
                    switch (state) {
                        case False: {
                            return False;
                        }
                        case True: 
                        case Both: {
                            return Both;
                        }
                    }
                }
                case True: {
                    switch (state) {
                        case True: {
                            return True;
                        }
                        case False: 
                        case Both: {
                            return Both;
                        }
                    }
                }
            }
            return this;
        }
    }
}

