/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.content;

import gnu.trove.map.hash.THashMap;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.content.ResourceBrowserRewriterRepository;
import org.simantics.debug.browser.sections.ResourceBrowserSection;

public class ResourceBrowserContent {
    public final Resource resource;
    private final THashMap<Class<?>, ResourceBrowserSection> sectionMap = new THashMap();
    private static final Comparator<ResourceBrowserSection> SECTION_COMPARATOR = new Comparator<ResourceBrowserSection>(){

        @Override
        public int compare(ResourceBrowserSection o1, ResourceBrowserSection o2) {
            return Double.compare(o1.getPriority(), o2.getPriority());
        }
    };

    private ResourceBrowserContent(Resource resource) {
        this.resource = resource;
    }

    public <T extends ResourceBrowserSection> T getSection(Class<T> clazz) {
        return (T)((ResourceBrowserSection)this.sectionMap.get(clazz));
    }

    public <T extends ResourceBrowserSection> void putSection(Class<T> clazz, T section) {
        this.sectionMap.put(clazz, section);
    }

    public <T extends ResourceBrowserSection> T removeSection(Class<T> clazz) {
        return (T)((ResourceBrowserSection)this.sectionMap.remove(clazz));
    }

    public void toHtml(ReadGraph graph, PrintWriter stream) throws DatabaseException {
        ArrayList sections = new ArrayList(this.sectionMap.values());
        Collections.sort(sections, SECTION_COMPARATOR);
        for (ResourceBrowserSection section : sections) {
            section.toHtml(graph, stream);
        }
    }

    public static ResourceBrowserContent createContentFor(ReadGraph graph, Resource resource) throws DatabaseException {
        ResourceBrowserContent content = new ResourceBrowserContent(resource);
        ResourceBrowserRewriter[] resourceBrowserRewriterArray = ResourceBrowserRewriterRepository.getRewriters();
        int n = resourceBrowserRewriterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceBrowserRewriter rewriter = resourceBrowserRewriterArray[n2];
            rewriter.rewrite(graph, content);
            ++n2;
        }
        return content;
    }
}

