/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;

public class CreateSharedOntologyDialog
extends ResourceSelectionDialog3<Resource> {
    private String name = "";
    private Text t;

    public CreateSharedOntologyDialog(Shell shell, Map<Resource, Pair<String, ImageDescriptor>> parameter, String title) {
        super(shell, parameter, title);
    }

    protected IDialogSettings getBaseDialogSettings() {
        return null;
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(c);
        Label l = new Label(c, 0);
        l.setText("Enter URI for the shared library:  http://");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)l);
        this.t = new Text(c, 2048);
        this.t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateSharedOntologyDialog.this.name = CreateSharedOntologyDialog.this.t.getText();
                CreateSharedOntologyDialog.this.validatePage();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.t);
        this.validatePage();
        return super.createExtendedContentArea(parent);
    }

    public void create() {
        super.create();
        this.t.setFocus();
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        this.validatePage();
    }

    protected void validatePage() {
        StructuredSelection selection = this.getSelectedItems();
        String error = this.validateName(this.name);
        if (error != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", error));
        } else if (selection.isEmpty()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", "No Library selected"));
        } else {
            Resource library = (Resource)selection.getFirstElement();
            try {
                Map children = (Map)Simantics.sync((ReadInterface)new UnescapedChildMapOfResource(library));
                if (children.containsKey(this.name)) {
                    this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", "Name is already in use."));
                } else {
                    this.updateStatus((IStatus)new Status(0, "org.eclipse.ui", ""));
                }
            }
            catch (DatabaseException e) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", "Failed to check validity of name. See error log.", (Throwable)e));
            }
        }
    }

    protected String validateName(final String name) {
        try {
            boolean inUse = (Boolean)Simantics.sync((ReadInterface)new UniqueRead<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    Resource r = graph.getPossibleResource("http://" + name + "@A");
                    if (r != null) {
                        return true;
                    }
                    return false;
                }
            });
            if (inUse) {
                return "Shared Library exists already";
            }
        }
        catch (DatabaseException e) {
            return e.getMessage();
        }
        if (name.trim().isEmpty()) {
            return "Name cannot be empty";
        }
        if (name.startsWith(".")) {
            return "Name cannot begin with a dot";
        }
        if (name.startsWith("/")) {
            return "Name cannot begin with a slash";
        }
        if (name.contains("//")) {
            return "Successive slashes are not allowed";
        }
        if (name.endsWith("/")) {
            return "Name cannot end with slash";
        }
        return null;
    }

    public String getName() {
        return this.name;
    }
}

