/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.datastructures.prioritystack;

public interface IPriorityStackListener<E> {

	/**
	 * T has been added to the context
	 * @param sender context
	 * @param item
	 */
	void itemAdded(IPriorityStack<E> sender, E item);
	
	/**
	 * T has been removed from the stack
	 * @param sender context
	 * @param item
	 */
	void itemRemoved(IPriorityStack<E> sender, E item);

}
