/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.filesystem.services.internal.sizetracker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.simantics.filesystem.services.internal.sizetracker.SizeTrackerImpl;
import org.simantics.filesystem.services.sizetracker.DirectorySizeService;
import org.simantics.filesystem.services.sizetracker.SizeTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class DirectorySizeServiceImpl
implements DirectorySizeService {
    private Logger logger = LoggerFactory.getLogger(DirectorySizeServiceImpl.class);
    private final Map<Path, SizeTrackerImpl> trackers = new HashMap<Path, SizeTrackerImpl>();

    @Override
    public SizeTracker track(Path directory) throws IOException {
        Map<Path, SizeTrackerImpl> map = this.trackers;
        synchronized (map) {
            SizeTrackerImpl tracker = this.trackers.get(directory);
            if (tracker != null) {
                return tracker;
            }
            tracker = new SizeTrackerImpl(this, directory);
            try {
                tracker.start();
                this.trackers.put(directory, tracker);
                return tracker;
            }
            catch (IOException e) {
                this.safeCloseTracker(tracker);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTracker(Path path) {
        Map<Path, SizeTrackerImpl> map = this.trackers;
        synchronized (map) {
            this.trackers.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<Path, SizeTrackerImpl> map = this.trackers;
        synchronized (map) {
            this.trackers.forEach((p, t) -> this.safeCloseTracker((SizeTrackerImpl)t));
            this.trackers.clear();
        }
    }

    private void safeCloseTracker(SizeTrackerImpl t) {
        try {
            t.close();
        }
        catch (IOException e) {
            this.logger.error("Error closing size tracker {}", (Object)t, (Object)e);
        }
    }

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
        this.shutdown();
    }
}

