/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.simantics.db.RequestProcessor;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

public interface SimanticsClipboard {

	public interface Representation {
		
		public Key getKey();
		public <T> T getValue(RequestProcessor processor, Map<String,Object> hints) throws DatabaseException;
		
	}
	
	Collection<Set<Representation>> getContents();

	public static final SimanticsClipboard EMPTY = new SimanticsClipboard() {
		@Override
		public Collection<Set<Representation>> getContents() {
			return Collections.emptySet();
		}
	};

}
