package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class IsEnumeratedType extends ResourceRead<Boolean> {

	public IsEnumeratedType(Resource resource) {
		super(resource);
	}

	@Override
	public Boolean perform(ReadGraph graph) throws DatabaseException {
		if(graph.hasStatement(resource, Layer0.getInstance(graph).Enumeration, resource)) return true;
		for(Resource st : graph.getSupertypes(resource)) {
			if(graph.syncRequest(new IsEnumeratedType(st))) return true;	
		}
		return false;
	}
    
}
