package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;

public class IndexedInstances extends ResourceRead2<Set<Resource>> {

	public IndexedInstances(Resource type, Resource indexRoot) {
		super(type, indexRoot);
	}

	@Override
	public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
		
        Layer0 L0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);

        String typeName = graph.getRelatedValue(resource, L0.HasName);

        Function dependencies = graph.adapt(L0X.Dependencies, Function.class);
        
        Collection<Map<String, Object>> results = (Collection<Map<String, Object>>)dependencies.apply(graph, resource2, "Types:" + IndexQueries.quoteTerm(typeName));
        if (results == null)
            return Collections.emptySet();

        HashSet<Resource> result = new HashSet<Resource>(results.size());
        for(Map<String, Object> entry : results) {
            Resource res = (Resource)entry.get("Resource");
            if(res != null) {
            	if (graph.isInstanceOf(res, resource))
            		result.add(res);
            }
        }
        return result;
		
	}

}
