/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.migration;

import java.util.ArrayList;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.RequestFlags;
import org.simantics.layer0.Layer0;

public class OntologiesFromLibrary extends ResourceRead<List<Resource>> {
    
    public OntologiesFromLibrary(Resource library) {
    	super(library);
    }

    @Override
    public List<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for(Resource r : graph.syncRequest(new ObjectsWithType(resource, L0.ConsistsOf, L0.Library))) {
            if(graph.isInstanceOf(r, L0.IndexRoot)) {
                if(graph.isInstanceOf(r, L0.Ontology)) {
                    result.add(r);
                }
            } else {
                result.addAll(graph.syncRequest(new OntologiesFromLibrary(r)));
            }
        }
        return result;
    }

    @Override
    public int getType() {
        return RequestFlags.IMMEDIATE_UPDATE;
    }

}
