package org.simantics.db.layer0.genericrelation;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

class ExternalRequest extends ParametrizedPrimitiveRead<Pair<GenericRelationIndex,Resource>,Long> implements Runnable {

    private static long value = 0;
    private Session session;
    private Listener<Long> procedure;

    public ExternalRequest(GenericRelationIndex index, Resource model) {
        super(Pair.make(index, model));
    }

    @Override
    public void register(ReadGraph graph, Listener<Long> procedure) {
        synchronized(getClass()) {
            procedure.execute(value++);
        }
        if(procedure.isDisposed()) return;
        assert(this.procedure == null);
        this.session = graph.getSession();
        this.procedure = procedure;
        parameter.first.addListener(graph, parameter.second, this);
    }
    
    @Override
    public void unregistered() {
        parameter.first.removeListener(session, parameter.second, this);
    }
    
    @Override
    public void run() {
        synchronized(getClass()) {
            procedure.execute(value++);
        }
    }
    
}