/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.service.QueryControl;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.FunctionImpl4;
import org.simantics.scl.runtime.function.UnsaturatedFunction2;

/**
 * dependencyResources:
 *      (ReadGraph, Resource model, String query) -> List<Resource>
 *      (ReadGraph, Resource model, String query, Integer maxResults) -> List<Resource>
 * 
 * @author Antti Villberg
 */
public class DependencyResources extends FunctionImpl4<ReadGraph, Resource, String, Integer, Object> {

    protected Resource getIndexRelation(ReadGraph graph) {
        return Layer0X.getInstance(graph).DependenciesRelation;
    }

    protected String getBindingPattern() {
        return Dependencies.getBindingPattern();
    }

    @Override
    public Object apply(ReadGraph p0, Resource p1) {
        return new UnsaturatedFunction2(this, p0, p1);
    }

    @Override
    public Object apply(ReadGraph p0, Resource p1, String p2) {
        return apply(p0, p1, p2, Integer.MAX_VALUE);
    }

    @Override
    public Object apply(ReadGraph graph, final Resource model, final String query, Integer _maxResults) {
        
        try {

            final GenericRelationIndex index = graph.adapt(getIndexRelation(graph), GenericRelationIndex.class);

            // Listen
            graph.syncRequest(new ExternalRequest(index, model));
            
            final int maxResults = _maxResults != null ? _maxResults : Integer.MAX_VALUE;
            
            QueryControl qc = graph.getService(QueryControl.class);
            return index.queryResources(qc.getIndependentGraph(graph), query, getBindingPattern(), new Object[] { model }, maxResults);
            
        } catch (DatabaseException e) {
            Logger.defaultLogError(e);
            return null;
        }
    }

}
