/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.exception;

import org.simantics.db.Resource;


public class PendingVariableException extends VariableException {

	private static final long serialVersionUID = -8379218573294565788L;
	
	private final Resource resource;
	
	public PendingVariableException(String message) {
		super(message);
		this.resource = null;
	}

	public PendingVariableException(String message, Resource resource) {
		super(message);
		this.resource = resource;
	}
	
	public Resource getResource() {
		return resource;
	}
	
	@Override
	public synchronized Throwable fillInStackTrace() {
	    return null;
	}

}
