/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;


/*
 * A value address in Simantics e.g.
 * 
 *  http://www.mycompany.com/My_Project/My_Model/My_Experiment/Composite1/Component1/Property1
 *  
 *  can be divided into 3 distinct parts.
 * 
 *  The model part : http://www.mycompany.com/My_Project/My_Model/
 *  The experiment part : My_Experiment/ 
 *  The variable part : Composite1/Component1/Property1
 * 
 *  A resource which is part of the flattened structure of a model 
 *  
 *  - Can specify uniquely its model part but does not always 
 *  - Does not specify the experiment part 
 *  - Can uniquely specify some part of the variable part
 *
 *  A variable identity is specified by the model part and the structure part  
 *
 *   -http://www.mycompany.com/My_Project/My_Model/Composite1/Component1/Property1
 *  
 *  Use cases:
 *  
 *   -Browse valid variable identities for selected components (e.g. for selected element in diagram)
 *   -Retrieve values for stored variable suffices (e.g. in monitors or expressions)
 *  
 *  
 *  
 */

public interface Valuations {

	/*
	 * Produces a resource in the value space specified by the given identity prefix and the given experiment.
	 * 
	 * @param variableIdentityPrefix a prefix which is sufficient to uniquely identify the VariableSpace
	 * @param experiment a valid experiment in the model specified by the variable identity
	 * @return a resource in a value space
	 */
	Resource getValue(ReadGraph graph, String variableIdentityPrefix, String valuation) throws DatabaseException;

	/*
	 * Produces a resource in the value space specified by the given identity prefix and and suffix and the given experiment.
	 * 
	 * @param variableIdentityPrefix a prefix which is sufficient to uniquely identify the VariableSpace
	 * @param experiment a valid experiment in the model specified by the variable identity
	 * @return a resource in a value space
	 */
	Resource getValue(ReadGraph graph, String variableIdentityPrefix, String valuation, String suffix) throws DatabaseException;   
	
}
