/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

/**
 * Token for trigger activation. Trigger is listened
 * so long as there are one or more activations on it.
 */
public interface Activation {
	/**
	 * Disposes this activation. If the triggers referred
	 * by this activation do not contain more activations,
	 * thery are stopped.
	 */
	@Deprecated
	void activate(ReadGraph graph, Resource resource) throws DatabaseException;
	void deactivate();
	
}
