/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadExt;
import org.simantics.db.request.RequestFlags;

final public class ReadEntry<T> extends CacheEntryBase {

	protected Read<T> request;

	public ReadEntry(Read<T> request) {
    	this.request = request;
    }
    
    @Override
    int makeHash() {
    	return request.hashCode();
    }
	
    @Override
    public Object getOriginalRequest() {
        return request;
    }
    
    @Override
    public void discard() {
    	super.discard();
    	setResult(null);
    }
	
    final public void addOrSet(AsyncReadGraph graph, Object item) {

    	assert(assertPending());
    	
//        ArrayList<Pair<AsyncProcedure<T>, AsyncBarrier>> p = null;

    	synchronized(this) {
    	    
            setResult(item);
    		setReady();
//    		p = procs;
//    		procs = null;
    		
    	}

//        if(p != null)
//        	for(Pair<AsyncProcedure<T>, AsyncBarrier> proc : p) {
//        		proc.first.execute(graph, (T)item);
//        		proc.second.dec();
//        	}
        
    }

    @Override
    final public Query getQuery() {
        
        return new Query() {

			@Override
			public void recompute(ReadGraphImpl graph_, Object provider, CacheEntry entry) {
				
				QueryProcessor qp = (QueryProcessor)provider;
				
		        WriteGraphImpl write = qp.getCore().getSession().getService(WriteGraphImpl.class);
				
		        ReadGraphImpl graph = write.newSync(entry);

				try {

					entry.setPending();
				    T result = request.perform(graph);
				    addOrSet(graph, result);

				} catch (Throwable t) {

					except(t);
                    
                }
				
			}

			@Override
			public void removeEntry(QueryProcessor processor) {
				processor.readMap.remove(request);
			}

			@Override
			public int type() {
				if(request instanceof ReadExt) {
					return ((ReadExt)request).getType();
				} else {
					return RequestFlags.INVALIDATE;
				}
			}
			
			@Override
			public String toString() {
				if(request == null) return "DISCARDED";
				else return request.toString() + statusOrException;
			}
        	
        };
        
    }
    
	public void performFromCache(ReadGraphImpl graph, Object provider,	Object procedure) {
	    
        AsyncProcedure<T> proc = (AsyncProcedure<T>)procedure;

	    if(isExcepted()) {

            try {
                proc.exception(graph, (Throwable)getResult());
            } catch (Throwable t) {
                t.printStackTrace();
            }
	        
	    } else {
	        
            try {
                proc.execute(graph, (T)getResult());
            } catch (Throwable t) {
                t.printStackTrace();
            }

	    }
		
	}
	
	@Override
	public String toString() {
		if(request == null) return "DISCARDED";
		else return request.toString() + " - " + statusOrException;
	}
	
	public Object get(ReadGraphImpl graph, QueryProcessor processor, Object procedure) throws DatabaseException {
		if(procedure != null) performFromCache(graph, processor, procedure);
		checkAndThrow();
		return getResult();
	}
	
	@Override
	boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
		if(request instanceof ReadExt) {
			return ((ReadExt)request).isImmutable(graph);
		}
		return false;
	}

}
