/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;

import org.simantics.db.common.exception.DebugException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.procedure.ListenerBase;

final public class OrderedSet extends CollectionUnaryQuery<IntProcedure> {
	
//	public ArrayList<IntProcedure> procs = null;

	public OrderedSet(final int r) {
        super(r);
    }

    final static OrderedSet entry(final QueryProcessor provider, final int r) {
        
        return (OrderedSet)provider.orderedSetMap.get(r);

    }
	
    final static void runner(ReadGraphImpl graph, final int r, final QueryProcessor provider, OrderedSet cached, final CacheEntry parent, ListenerBase listener, final IntProcedure procedure) {
        
    	OrderedSet entry = cached != null ? cached : (OrderedSet)provider.orderedSetMap.get(r); 
        if(entry == null) {
        	
        	entry = new OrderedSet(r);
        	entry.setPending();
        	entry.clearResult(provider.querySupport);
        	entry.putEntry(provider);
        	
            provider.performForEach(graph, entry, parent, listener, procedure);
            
        } else {

            if(entry.isPending()) {
            	synchronized(entry) {
                    if(entry.isPending()) {
                        throw new IllegalStateException();
//                    	if(entry.procs == null) entry.procs = new ArrayList<IntProcedure>();
//                    	entry.procs.add(procedure);
//                        provider.registerDependencies(graph, entry, parent, listener, procedure, false);
//                    	return;
                    }
            	}
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }

    }
    
    final public static void queryEach(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final IntProcedure procedure) {
        
    	assert(r != 0);
    	
    	final OrderedSet entry = (OrderedSet)provider.orderedSetMap.get(r);
    	
    	if(parent == null && !(listener != null)) {
        	if(entry != null && entry.isReady()) { 
        		entry.performFromCache(graph, provider, procedure);
        		return;
        	}
        }

        runner(graph, r, provider, entry, parent, listener, procedure);
         
    }

    @Override
    public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.orderedSetMap.get(id);
    }
 	
 	@Override
 	public void putEntry(QueryProcessor provider) {
 	    provider.orderedSetMap.put(id, this);
 	}

 	@Override
 	final public void removeEntry(QueryProcessor provider) {
        provider.orderedSetMap.remove(id);
 	}
    
 	private int current = 0;

 	private boolean nextElement(ReadGraphImpl graph, final QueryProcessor provider, final IntProcedure procedure, final boolean store) {
 	    
 		provider.querySupport.ensureLoaded(graph, current); 		
 		
 		boolean found = provider.querySupport.getObjects(graph, current, id, new IntProcedure() {

 			@Override
 			public void execute(ReadGraphImpl graph, int i) {
 				if(i != id) {
 					addOrSet(i);
 					procedure.execute(graph, i);
 				}
 				current = i;
 			}

 			@Override
 			public void exception(ReadGraphImpl graph, Throwable t) {
 				if(DebugException.DEBUG) new DebugException(t).printStackTrace();
 				procedure.exception(graph, t);
 			}

 			@Override
 			public void finished(ReadGraphImpl graph) {
 			}

 		});

 		if(!found) current = id;

 		if(current == id) {
 			finish(graph, provider);
 			procedure.finished(graph);
 			return false;
 		} else {
 			return true;
 		}

 	}
 	
    @Override
    public void clearResult(QuerySupport support) {
        current = id;
        setResult(new IntArray());
    }
 	
    @Override
    public Object computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final IntProcedure procedure, final boolean store) {

        while(nextElement(graph, provider, procedure, store));
        
        return getResult();
        
    }
    
    @Override
    public String toString() {
    	return "OrderedSet[" + id + "]";
    }

    final private void finish(ReadGraphImpl graph, QueryProcessor provider) {
        
    	assert(isPending());

//        ArrayList<IntProcedure> p = null;

        synchronized(this) {

        	setReady();
//            p = procs;
//            procs = null; 
        
        }
        
//        if(p != null) {
//	        IntArray v = (IntArray)getResult();
//	        if(v.data == null) {
//	            if(v.sizeOrData != IntArray.NO_DATA) {
//	                for(IntProcedure proc : p) proc.execute(graph, v.sizeOrData);
//	            }
//	        } else {
//	            for(IntProcedure proc : p) {
//	                for(int i = 0;i < v.sizeOrData ; i++) proc.execute(graph, v.data[i]);
//	            }
//	        }
//	        for(IntProcedure proc : p) proc.finished(graph);
//        }

    }

    final public void addOrSet(int add) {
        
        assert(isPending());
        
        IntArray value = (IntArray)getResult();
        value.add(add);
        
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, final IntProcedure procedure) {
    	
    	assert(isReady());

    	if(handleException(graph, procedure)) return EXCEPTED;
    	
        final IntArray value = (IntArray)getResult();
        if(value.data == null) {
            if(value.sizeOrData != IntArray.NO_DATA) procedure.execute(graph, value.sizeOrData);
        } else {
            for(int i = 0;i < value.sizeOrData ; i++) procedure.execute(graph, value.data[i]);
        }

        procedure.finished(graph);
        
        return value;
        
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        
        final Semaphore s = new Semaphore(0);
        
        computeForEach(graph, provider, new IntProcedureAdapter() {

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }
			
			@Override
			public void exception(ReadGraphImpl graph, Throwable t) {
				throw new Error("Error in recompute.", t);
            }

        }, true);
        
        while(!s.tryAcquire()) {
        	provider.resume(graph);
        }
        
    }
    
}
