/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contribution;

import java.util.Collection;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.Tester;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * TODO: specification
 * 
 * @author Antti Villberg
 */
public interface GraphContribution {

    /**
     * @param graph
     * @param context
     * @return a collection of contributions, must not be <code>null</code>
     * @throws DatabaseException
     */
    public Collection<NodeContext> children(ReadGraph graph, NodeContext context) throws DatabaseException;

    /**
     * @return <code>null</code> if there is no tester
     */
    public Tester getNodeContextTester();

}
