/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.db.Disposable;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.ObjectUtils;

/**
 * @author Antti Villberg
 */
public class WorkbenchSelectionInputSource implements WorkbenchSessionContextInputSource, ObservableInputSource,
        ISelectionListener, Disposable {

    protected ISelectionService   service;
    protected Object              selection;
    protected IWorkbenchPart      part;
    protected IWorkbenchPart      ownPart;
    protected InputSourceListener listener;

    @Override
    public void init(IWorkbenchSite site, IWorkbenchPart ownPart) {
        this.ownPart = ownPart;
        attachToWorkbench();
    }

    /**
     * @thread SWT
     */
    protected void attachToWorkbench() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null)
            return;
        service = window.getSelectionService();
        ISelection initialSelection = service.getSelection();
        IWorkbenchPart activePart = null;
        if (initialSelection != null) {
            IWorkbenchPage activePage = window.getActivePage();
            if (activePage != null)
                activePart = activePage.getActivePart();
        }
        selectionChanged(activePart, initialSelection);
        service.addPostSelectionListener(this);
    }

    /**
     * @thread SWT
     */
    @Override
    public void dispose() {
        if (service != null)
            service.removePostSelectionListener(this);
        service = null;
        selection = null;
        listener = null;
    }

    /**
     * @thread SWT
     */
    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    	// Do not process selections from self
    	if(ObjectUtils.objectEquals(ownPart, part)) return;
        Object old = this.selection;
        this.selection = selection;
        this.part = part;
        //System.err.println("WorkbenchSelectionInputSource.selectionChanged(" + part + ", " + this.selection + ")");
        fireIfInputChanged(old, selection);
    }

    /**
     * @param oldSelection
     * @param newSelection
     * @thread SWT
     */
    protected void fireIfInputChanged(Object oldSelection, Object newSelection) {
        InputSourceListener l = listener;
        if (l != null)
            if (!ObjectUtils.objectEquals(oldSelection, newSelection))
                l.inputChanged(this);
    }

    @Override
    public Object get(ISessionContext ctx) {
        return selection != null ? selection : GraphExplorer.EMPTY_INPUT;
    }
    
    @Override
    public IWorkbenchPart getProvider() {
    	return this.part;
    }

    @Override
    public void setListener(InputSourceListener listener) {
        this.listener = listener;
    }

}
