/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;
import java.util.function.Consumer;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.viewpoints.LazyContainerViewpoint;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class SuperTypeOfViewpointFactory implements ViewpointFactory {

    @Override
    public Viewpoint create(final PrimitiveQueryUpdater updater, final NodeContext context, final ViewpointKey key) {
        assert(updater != null);
        assert(context != null);

        final LazyContainerViewpoint result = new LazyContainerViewpoint();

        DataSource<ReadGraph> source = updater.getDataSource(ReadGraph.class);
        if (source == null)
            return result;

        final Resource inputResource = (Resource) context.getConstant(BuiltinKeys.INPUT);
        assert(inputResource != null);

        source.schedule(new Consumer<ReadGraph>() {
            @Override
            public void accept(ReadGraph source) {
            	try {
	                Collection<Resource> children = source.getObjects(inputResource, Layer0.getInstance(source).SupertypeOf);
	                NodeContext[] resultContexts = NodeContextUtil.toContextsWithInput(children);
	                result.setChildren(updater, resultContexts);
	                result.setHasChildren(resultContexts.length > 0);
	
	                updater.scheduleReplace(context, key, result);
            	} catch (DatabaseException e) {
            		
            	}
            }
        });

        return result;
    }

    @Override
    public String toString() {
        return "Subtypes";
    }

}
