/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;

import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;

/**
 * A graph resource based EnumerationModifier utility implementation.
 * 
 * @author Tuukka Lehtonen
 */
public class GraphEnumerationModifier extends GraphEnumerationModifierBase<Resource> {

    protected final Resource subject;
    protected final Resource relation;

    public GraphEnumerationModifier(Session session, Resource subject, Resource relation, Enumeration<Resource> enumeration, Resource value) {
        this(session, subject, relation, enumeration, enumeration.find(value));
    }

    public GraphEnumerationModifier(Session session, Resource subject, Resource relation, Enumeration<Resource> enumeration, EnumeratedValue<Resource> value) {
        super(session, enumeration, value);
        if (subject == null)
            throw new NullPointerException("null subject");
        if (relation== null)
            throw new NullPointerException("null relation");

        this.subject = subject;
        this.relation = relation;
    }

    @Override
    protected void modifyWithObject(WriteGraph graph, Resource oldEnumObject, Resource enumObject) throws DatabaseException {
//      System.out.println("subject: " + NameUtils.getSafeName(graph, subject));
//      System.out.println("relation: " + NameUtils.getSafeName(graph, relation));
//      System.out.println("old enum object: " + NameUtils.getSafeName(graph, oldEnumObject));
//      System.out.println("enum object: " + NameUtils.getSafeName(graph, enumObject));

        // FIXME: this is a hackish way to support enumeration style editing for boolean values.
        // See GetEnumeration for why this works.
        Layer0 l0 = Layer0.getInstance(graph);
        if (l0.True.equals(enumObject) || l0.False.equals(enumObject)) {
            Boolean value = Boolean.valueOf(l0.True.equals(enumObject));
            // NOTE: this assumes that relation is functional, otherwise it will fail.
            Collection<Resource> props = graph.getObjects(subject, relation);
            if (props.size() > 1) {
                throw new ValidationException("Multiple (" + props.size() + ") '" + NameUtils.getSafeName(graph, relation) + "' properties found for resource '" + NameUtils.getSafeName(graph, subject) + "'. Expected functional property.");
            }
            graph.claimLiteral(subject, relation, value, Bindings.BOOLEAN);
        } else {
            if (oldEnumObject != null)
                //graph.deny(subject, relation, oldEnumObject);
                graph.deny(subject, relation);
            if (enumObject != null)
                graph.claim(subject, relation, null, enumObject);
        }
    }

}
