/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.List;

import org.simantics.browsing.ui.content.Labeler.EnumerationModifier;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class EnumerationVariableModifier3 implements EnumerationModifier {

    protected final Session      session;
    protected final Variable     variable;
    protected final List<String> allowedValues;
    protected final String       defaultValue;

    protected Throwable        modifierFailed;

    public EnumerationVariableModifier3(RequestProcessor processor, Variable variable, List<String> allowedValues) {

    	this.session = processor.getSession();
        this.variable = variable;
        this.allowedValues = allowedValues;
        this.defaultValue = computeDefaultValue(processor, variable);
    	//System.err.println(this.defaultValue);
        
    }

    protected String computeDefaultValue(RequestProcessor processor, final Variable variable) {
        try {
           return processor.syncRequest(new Read<String>() {
                @Override
                public String perform(ReadGraph graph) throws DatabaseException {
          //      	System.err.println(variable.getURI(graph));
                	return variable.getValue(graph);//variable.getPossiblePropertyValue(graph, Variables.LABEL);
                }
            });
        } catch (DatabaseException e) {
            return "";
        }
    }

    public class Write extends WriteRequest {

        final private Variable variable;
        final private String label;

        public Write(Variable variable, String label) {
            super((VirtualGraph)null);
            this.variable = variable;
            this.label = label;
        }

        @Override
        public void perform(WriteGraph graph) throws DatabaseException {
        	variable.setValue(graph, label, Bindings.STRING);
        }

    }
    
    protected void doModify(final String label) {
        session.asyncRequest(new Write(variable, label),
                parameter -> {
                    if (parameter != null)
                        ErrorLogger.defaultLogError(parameter);
        });
    }

    @Override
    public String getValue() {
        return defaultValue;
    }

    @Override
    public String isValid(String label) {
        if (modifierFailed != null)
            return "Could not resolve validator for this value, modification denied. Reason: "
            + modifierFailed.getMessage();
        // Validity should already be enforced by the editing UI for
        // enumerations.
        return null;
    }

    @Override
    public final void modify(String label) {
        if (modifierFailed != null)
            // Should never end up here, isValid should prevent it.
            throw new Error("modifier failed: " + modifierFailed.getMessage());
        doModify(label);
    }

    @Override
    public List<String> getValues() {
    	return allowedValues;
    }

};
