/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.viewpoints.ViewpointStub;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;
import org.simantics.db.AsyncReadGraph;

/**
 * Implement {@link #children(AsyncReadGraph)} and {@link #hasChildren(AsyncReadGraph)}.
 * 
 * @author Tuukka Lehtonen
 */
final public class ContributionViewpoint extends ViewpointStub implements org.simantics.browsing.ui.content.ContributionViewpoint {

    final private Collection<ViewpointContributionFactory> contributions;

    public ContributionViewpoint(Collection<ViewpointContributionFactory> contributions) {
        this.contributions = new ArrayList<ViewpointContributionFactory>(contributions);

//        return contributions;
//
//        this.contributions = new ArrayList<ViewpointContributionFactory>();
//
//        for(final GraphViewpointContribution contribution : contributions) {
//            LazyContribution lazy = new LazyContribution(updater, context, contribution, ContributionViewpoint.this, key);
//            this.contributions.add(lazy);
//        }
    }

    @Override
    public NodeContext[] getChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getHasChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ViewpointContributionFactory> getContributions() {
        return contributions;
    }

}
