/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.common.property.PropertyUtil;
import org.simantics.db.ReadGraph;

/**
 * @author Tuukka Lehtonen
 */
public class ArrayPropertyViewpoint extends LazyParametrizedViewpoint {

    public ArrayPropertyViewpoint(PrimitiveQueryUpdater updater, NodeContext context, ViewpointKey key, Object... parameters) {
        super(updater, context, key, parameters);
    }

    @Override
    public NodeContext[] children(ReadGraph graph) {
        IProperty input = getInput(IProperty.class);
        NodeContext[] children = PropertyUtil.getChildren(input);
        return children;
    }

    @Override
    public Boolean hasChildren(ReadGraph graph) {
        return Boolean.valueOf(children(graph).length > 0);
    }

}
