/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.document.AddDocumentAction;
import org.simantics.document.FileDocumentUtil;
import org.simantics.document.ui.dialogs.FileDetailDialog;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;

public class ImportDocumentWithDetail
extends AddDocumentAction {
    public ImportDocumentWithDetail(ReadGraph graph, String relationUri) throws DatabaseException {
        super(graph, relationUri);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                final FileDetailDialog dialog = new FileDetailDialog(Display.getCurrent().getActiveShell(), resource);
                if (dialog.open() == 1) {
                    dialog.getAnnotationConfigurator().dispose();
                    return;
                }
                final String filename = dialog.getFileName();
                final String name = dialog.getName();
                if (filename == null) {
                    dialog.getAnnotationConfigurator().dispose();
                    return;
                }
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        Resource newDoc = ImportDocumentWithDetail.this.doDocumentImport(graph, resource, filename, name);
                        dialog.getAnnotationConfigurator().apply(graph, newDoc);
                    }
                }, e -> {
                    dialog.getAnnotationConfigurator().dispose();
                    if (e != null) {
                        ExceptionUtils.logAndShowError((String)"Cannot import document.", (Throwable)e);
                    }
                });
            }
        };
    }

    public Resource doDocumentImport(WriteGraph graph, Resource target, String filename, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource newDoc = FileDocumentUtil.importFileWithName((WriteGraph)graph, (String)filename);
        graph.claimLiteral(newDoc, l0.HasName, (Object)name);
        this.linkDocument(graph, target, newDoc);
        return newDoc;
    }

    public static Resource importDocumentWithDetailSCL(WriteGraph graph, Resource target, String filename) throws FileNotFoundException, DatabaseException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found - " + file.getAbsolutePath());
        }
        ImportDocumentWithDetail document = new ImportDocumentWithDetail((ReadGraph)graph, "http://www.simantics.org/Layer0-1.1/ConsistsOf");
        return document.doDocumentImport(graph, target, filename, file.getName());
    }
}

