/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant.pointertool;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.g2d.utils.geom.DirectionSet;

public class TerminalUtil {
    private static final ThreadLocal<ArrayList<Topology.Terminal>> TERMINALS = new ThreadLocal<ArrayList<Topology.Terminal>>(){

        @Override
        protected ArrayList<Topology.Terminal> initialValue() {
            return new ArrayList<Topology.Terminal>();
        }
    };
    private static final ThreadLocal<ArrayList<IElement>> ELEMENTS = new ThreadLocal<ArrayList<IElement>>(){

        @Override
        protected ArrayList<IElement> initialValue() {
            return new ArrayList<IElement>();
        }
    };
    private static final Rectangle2D POINT_PICK_SHAPE = new Rectangle2D.Double(0.0, 0.0, 0.001, 0.001);
    public static final Comparator<TerminalInfo> ASCENDING_DISTANCE_ORDER = new Comparator<TerminalInfo>(){

        @Override
        public int compare(TerminalInfo o1, TerminalInfo o2) {
            double d1 = o1.distance;
            double d2 = o2.distance;
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    };

    public static List<TerminalInfo> pickTerminals(IDiagram d, Shape pickShape, boolean pickPointTerminals, boolean pickAreaTerminals) {
        boolean clearElements = false;
        List elements = null;
        if (pickShape != null) {
            elements = ELEMENTS.get();
            elements.clear();
            clearElements = true;
            PickRequest req = new PickRequest(pickShape);
            DiagramUtils.pick(d, req, elements);
        } else {
            elements = d.getElements();
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        double pickCenterX = 0.0;
        double pickCenterY = 0.0;
        if (pickShape != null) {
            Rectangle2D bounds = pickShape.getBounds2D();
            pickCenterX = bounds.getCenterX();
            pickCenterY = bounds.getCenterY();
        }
        ArrayList<TerminalInfo> result = new ArrayList<TerminalInfo>();
        ArrayList<Topology.Terminal> terminals = TERMINALS.get();
        for (IElement e : elements) {
            TerminalTopology tt = e.getElementClass().getAtMostOneItemOfClass(TerminalTopology.class);
            if (tt == null) continue;
            terminals.clear();
            tt.getTerminals(e, terminals);
            if (terminals.isEmpty()) continue;
            List<TerminalLayout> tls = e.getElementClass().getItemsByClass(TerminalLayout.class);
            for (Topology.Terminal t : terminals) {
                Shape terminalShape = TerminalUtil.getTerminalShape(tls, e, t);
                if (terminalShape == null && !pickPointTerminals || terminalShape != null && !pickAreaTerminals) continue;
                AffineTransform terminalToElement = TerminalUtil.getTerminalPosOnElement0(e, t);
                AffineTransform terminalToDiagram = TerminalUtil.concatenate(ElementUtils.getTransform(e), terminalToElement);
                double pickDist = 0.0;
                if (pickShape != null) {
                    Shape pickTargetShape = terminalShape != null ? terminalShape : POINT_PICK_SHAPE;
                    if (!GeometryUtils.intersects(pickShape, pickTargetShape = GeometryUtils.transformShape(pickTargetShape, terminalToDiagram))) continue;
                    pickDist = Point2D.distance(pickCenterX, pickCenterY, terminalToDiagram.getTranslateX(), terminalToDiagram.getTranslateY());
                }
                TerminalInfo ti = new TerminalInfo();
                ti.e = e;
                ti.posDia = terminalToDiagram;
                ti.posElem = terminalToElement != null ? new AffineTransform(terminalToElement) : new AffineTransform();
                ti.t = t;
                ti.shape = terminalShape;
                ti.distance = pickDist;
                result.add(ti);
            }
        }
        if (clearElements) {
            elements.clear();
        }
        terminals.clear();
        return result;
    }

    public static TerminalInfo pickTerminal(IDiagram diagram, Shape pickShape) {
        ArrayList<IElement> elements = ELEMENTS.get();
        elements.clear();
        PickRequest req = new PickRequest(pickShape);
        DiagramUtils.pick(diagram, req, elements);
        if (elements.isEmpty()) {
            return null;
        }
        TerminalInfo result = new TerminalInfo();
        double bestShortestDist = Double.MAX_VALUE;
        Rectangle2D bounds = pickShape.getBounds2D();
        double pickCenterX = bounds.getCenterX();
        double pickCenterY = bounds.getCenterY();
        ArrayList<Topology.Terminal> terminals = TERMINALS.get();
        for (IElement e : elements) {
            TerminalTopology tt = e.getElementClass().getAtMostOneItemOfClass(TerminalTopology.class);
            if (tt == null) continue;
            terminals.clear();
            tt.getTerminals(e, terminals);
            for (Topology.Terminal t : terminals) {
                double pickDist;
                AffineTransform terminalToElement = TerminalUtil.getTerminalPosOnElement0(e, t);
                AffineTransform terminalToDiagram = TerminalUtil.concatenate(ElementUtils.getTransform(e), terminalToElement);
                Shape terminalShape = TerminalUtil.getTerminalShape(e, t);
                Shape pickTargetShape = terminalShape != null ? terminalShape : POINT_PICK_SHAPE;
                if (!GeometryUtils.intersects(pickShape, pickTargetShape = GeometryUtils.transformShape(pickTargetShape, terminalToDiagram)) || (pickDist = Point2D.distanceSq(pickCenterX, pickCenterY, terminalToDiagram.getTranslateX(), terminalToDiagram.getTranslateY())) > bestShortestDist) continue;
                result.e = e;
                result.posDia = terminalToDiagram;
                result.posElem = terminalToElement != null ? new AffineTransform(terminalToElement) : new AffineTransform();
                result.t = t;
                result.shape = terminalShape;
                result.distance = Math.sqrt(pickDist);
                bestShortestDist = pickDist;
            }
        }
        elements.clear();
        terminals.clear();
        if (bestShortestDist == Double.MAX_VALUE) {
            return null;
        }
        return result;
    }

    public static DirectionSet getTerminalDirectionSet(IElement e, Topology.Terminal t, DirectionSet directions) {
        if (directions == null) {
            directions = new DirectionSet(new double[0]);
        }
        for (TerminalLayout tl : e.getElementClass().getItemsByClass(TerminalLayout.class)) {
            tl.getTerminalDirection(e, t, directions);
        }
        return directions;
    }

    public static DirectionSet getTerminalPosition(IElement e, Topology.Terminal t, DirectionSet directions) {
        if (directions == null) {
            directions = new DirectionSet(new double[0]);
        }
        for (TerminalLayout tl : e.getElementClass().getItemsByClass(TerminalLayout.class)) {
            tl.getTerminalDirection(e, t, directions);
        }
        return directions;
    }

    public static Point2D getTerminalCenterPosOnDiagram(IElement e, Topology.Terminal t) {
        Shape shape = TerminalUtil.getTerminalShape(e, t);
        Point2D.Double terminalCenterPos = new Point2D.Double();
        if (shape != null) {
            Rectangle2D rect = shape.getBounds2D();
            ((Point2D)terminalCenterPos).setLocation(rect.getCenterX(), rect.getCenterY());
        }
        AffineTransform at = TerminalUtil.getTerminalPosOnDiagram(e, t);
        at.transform(terminalCenterPos, terminalCenterPos);
        return terminalCenterPos;
    }

    public static AffineTransform getTerminalPosOnDiagram(IElement e, Topology.Terminal t) {
        AffineTransform pos = TerminalUtil.getTerminalPosOnElement0(e, t);
        return TerminalUtil.concatenate(ElementUtils.getTransform(e), pos);
    }

    public static AffineTransform getTerminalPosOnElement(IElement e, Topology.Terminal t) {
        AffineTransform tr = TerminalUtil.getTerminalPosOnElement0(e, t);
        return tr != null ? new AffineTransform(tr) : null;
    }

    private static AffineTransform getTerminalPosOnElement0(IElement e, Topology.Terminal t) {
        List<TerminalLayout> tls = e.getElementClass().getItemsByClass(TerminalLayout.class);
        AffineTransform result = null;
        for (TerminalLayout tl : tls) {
            result = tl.getTerminalPosition(e, t);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Shape getTerminalShape(IElement e, Topology.Terminal t) {
        List<TerminalLayout> tls = e.getElementClass().getItemsByClass(TerminalLayout.class);
        return TerminalUtil.getTerminalShape(tls, e, t);
    }

    private static Shape getTerminalShape(List<TerminalLayout> tls, IElement e, Topology.Terminal t) {
        for (TerminalLayout tl : tls) {
            Shape result = tl.getTerminalShape(e, t);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public BendsInfo pickBends(IDiagram diagram, Shape pickShape) {
        BendsInfo result = null;
        double bestShortestDist = Double.MAX_VALUE;
        Rectangle2D pickShapeBounds = pickShape.getBounds2D();
        Point2D.Double pickShapeCenter = new Point2D.Double(pickShapeBounds.getCenterX(), pickShapeBounds.getCenterY());
        ArrayList<IElement> elements = ELEMENTS.get();
        elements.clear();
        PickRequest req = new PickRequest(pickShape);
        DiagramUtils.pick(diagram, req, elements);
        ArrayList<BendsHandler.Bend> bends = new ArrayList<BendsHandler.Bend>();
        Point2D.Double bendPos = new Point2D.Double();
        for (IElement e : diagram.getElements()) {
            AffineTransform elementToDiagram = ElementUtils.getTransform(e);
            BendsHandler bh = e.getElementClass().getSingleItem(BendsHandler.class);
            if (bh == null) continue;
            bends.clear();
            bh.getBends(e, bends);
            for (BendsHandler.Bend b : bends) {
                double dist;
                bh.getBendPosition(e, b, bendPos);
                elementToDiagram.transform(bendPos, bendPos);
                if (!pickShape.contains(bendPos) || (dist = bendPos.distance(pickShapeCenter)) > bestShortestDist) continue;
                dist = bestShortestDist;
                result = new BendsInfo();
                result.e = e;
                result.b = b;
            }
        }
        elements.clear();
        if (bestShortestDist == Double.MAX_VALUE) {
            return null;
        }
        return result;
    }

    public static boolean isSameTerminal(TerminalInfo t1, TerminalInfo t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.e.equals(t2.e) && t1.t.equals(t2.e);
    }

    public static List<TerminalInfo> findNearestOverlappingTerminals(List<TerminalInfo> tis) {
        int len = tis.size();
        if (len < 2) {
            return tis;
        }
        TerminalInfo nearest = null;
        int i = 0;
        while (i < len) {
            TerminalInfo ti = tis.get(i);
            if (nearest == null || ti.distance < nearest.distance) {
                nearest = ti;
            }
            ++i;
        }
        ArrayList<TerminalInfo> result = new ArrayList<TerminalInfo>(len);
        int i2 = 0;
        while (i2 < len) {
            TerminalInfo ti = tis.get(i2);
            if (ti.distance == nearest.distance && ti.posDia.equals(nearest.posDia)) {
                result.add(ti);
            }
            ++i2;
        }
        return result;
    }

    private static AffineTransform concatenate(AffineTransform a, AffineTransform b) {
        AffineTransform result = new AffineTransform(a);
        if (b != null) {
            result.concatenate(b);
        }
        return result;
    }

    public static class BendsInfo {
        public IElement e;
        public BendsHandler.Bend b;
    }

    public static class TerminalInfo {
        public IElement e;
        public Topology.Terminal t;
        public AffineTransform posElem;
        public AffineTransform posDia;
        public Shape shape;
        public double distance;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append("element=").append(this.e).append(", terminal=").append(this.t).append(", posDia=").append(this.posDia).append(", shape=").append(this.shape).append(", distance=").append(this.distance).append(']');
            return sb.toString();
        }

        public static TerminalInfo create(Point2D p, IElement e, Topology.Terminal t, Shape terminalShape) {
            AffineTransform at = AffineTransform.getTranslateInstance(p.getX(), p.getY());
            TerminalInfo ti = new TerminalInfo();
            ti.e = e;
            ti.t = t;
            ti.posElem = at;
            ti.posDia = at;
            ti.shape = terminalShape;
            return ti;
        }
    }
}

