/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.TransactionContext;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderListener;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.threads.ThreadUtils;

public class ZOrderHandler
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    Selection sel;
    @DependencyReflection.Dependency
    PickContext pickContext;
    private final ListenerList zOrderListeners = new ListenerList(1);

    public void addOrderListener(ZOrderListener listener) {
        this.zOrderListeners.add((Object)listener);
    }

    public void removeOrderListener(ZOrderListener listener) {
        this.zOrderListeners.remove((Object)listener);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent ce) {
        this.assertDependencies();
        Command c = ce.command;
        if (c.equals((Object)Commands.BRING_UP)) {
            final Set<IElement> selectedElements = this.sel.getAllSelections();
            if (selectedElements == null || selectedElements.isEmpty()) {
                return true;
            }
            Shape area = ElementUtils.getElementShapesOnDiagram(selectedElements);
            if (area == null) {
                return true;
            }
            final ArrayList<IElement> pickedElements = new ArrayList<IElement>();
            PickRequest req = new PickRequest(area);
            req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
            this.pickContext.pick(this.diagram, req, pickedElements);
            DiagramUtils.inDiagramTransaction(this.diagram, TransactionContext.TransactionType.WRITE, new Runnable(){

                @Override
                public void run() {
                    List<IElement> elements = ZOrderHandler.this.diagram.getElements();
                    boolean changed = false;
                    int nextPos = elements.size() - 1;
                    int i = pickedElements.size() - 1;
                    while (i >= 0) {
                        IElement e = (IElement)pickedElements.get(i);
                        int index = elements.indexOf(e);
                        if (index != -1 && selectedElements.contains(e)) {
                            changed |= ZOrderHandler.this.diagram.moveTo(e, nextPos);
                            nextPos = index;
                        }
                        --i;
                    }
                    if (changed) {
                        ZOrderHandler.this.notifyZOrderListeners(ZOrderHandler.this.diagram);
                        ZOrderHandler.this.setDirty();
                        ZOrderHandler.this.scheduleSynchronizeElementOrder(ZOrderHandler.this.diagram);
                    }
                }
            });
            return true;
        }
        if (c.equals((Object)Commands.SEND_DOWN)) {
            final Set<IElement> selectedElements = this.sel.getAllSelections();
            if (selectedElements == null || selectedElements.isEmpty()) {
                return true;
            }
            Shape area = ElementUtils.getElementShapesOnDiagram(selectedElements);
            if (area == null) {
                return true;
            }
            final ArrayList<IElement> pickedElements = new ArrayList<IElement>();
            PickRequest req = new PickRequest(area);
            req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
            this.pickContext.pick(this.diagram, req, pickedElements);
            DiagramUtils.inDiagramTransaction(this.diagram, TransactionContext.TransactionType.WRITE, new Runnable(){

                @Override
                public void run() {
                    List<IElement> elements = ZOrderHandler.this.diagram.getElements();
                    boolean changed = false;
                    int nextPos = 0;
                    int i = 0;
                    while (i < pickedElements.size()) {
                        IElement e = (IElement)pickedElements.get(i);
                        int index = elements.indexOf(e);
                        if (index != -1 && selectedElements.contains(e)) {
                            changed |= ZOrderHandler.this.diagram.moveTo(e, nextPos);
                            nextPos = index;
                        }
                        ++i;
                    }
                    if (changed) {
                        ZOrderHandler.this.notifyZOrderListeners(ZOrderHandler.this.diagram);
                        ZOrderHandler.this.setDirty();
                        ZOrderHandler.this.scheduleSynchronizeElementOrder(ZOrderHandler.this.diagram);
                    }
                }
            });
            return true;
        }
        if (c.equals((Object)Commands.BRING_TO_TOP)) {
            DiagramUtils.inDiagramTransaction(this.diagram, TransactionContext.TransactionType.WRITE, new Runnable(){

                @Override
                public void run() {
                    boolean changed = false;
                    for (Map.Entry<Integer, Set<IElement>> e : ZOrderHandler.this.sel.getSelections().entrySet()) {
                        ArrayList<IElement> ll = new ArrayList<IElement>((Collection)e.getValue());
                        ZOrderHandler.this._sortByOrder(ll);
                        int i = ll.size() - 1;
                        while (i >= 0) {
                            if (ZOrderHandler.this.diagram.containsElement(ll.get(i))) {
                                changed |= ZOrderHandler.this.diagram.bringToTop(ll.get(i));
                            }
                            --i;
                        }
                    }
                    if (changed) {
                        ZOrderHandler.this.notifyZOrderListeners(ZOrderHandler.this.diagram);
                        ZOrderHandler.this.setDirty();
                        ZOrderHandler.this.scheduleSynchronizeElementOrder(ZOrderHandler.this.diagram);
                    }
                }
            });
            return true;
        }
        if (c.equals((Object)Commands.SEND_TO_BOTTOM)) {
            DiagramUtils.inDiagramTransaction(this.diagram, TransactionContext.TransactionType.WRITE, new Runnable(){

                @Override
                public void run() {
                    boolean changed = false;
                    for (Map.Entry<Integer, Set<IElement>> e : ZOrderHandler.this.sel.getSelections().entrySet()) {
                        ArrayList<IElement> ll = new ArrayList<IElement>((Collection)e.getValue());
                        ZOrderHandler.this._sortByOrder(ll);
                        int i = 0;
                        while (i < ll.size()) {
                            if (ZOrderHandler.this.diagram.containsElement(ll.get(i))) {
                                changed |= ZOrderHandler.this.diagram.sendToBottom(ll.get(i));
                            }
                            ++i;
                        }
                    }
                    if (changed) {
                        ZOrderHandler.this.notifyZOrderListeners(ZOrderHandler.this.diagram);
                        ZOrderHandler.this.setDirty();
                        ZOrderHandler.this.scheduleSynchronizeElementOrder(ZOrderHandler.this.diagram);
                    }
                }
            });
            return true;
        }
        return false;
    }

    void scheduleSynchronizeElementOrder(IDiagram diagram) {
        if (diagram.getHint(DiagramHints.KEY_MUTATOR) == null) {
            return;
        }
        ThreadUtils.getBlockingWorkExecutor().execute(() -> DiagramUtils.mutateDiagram(diagram, m -> m.synchronizeElementOrder()));
    }

    void notifyZOrderListeners(IDiagram diagram) {
        Object[] objectArray = this.zOrderListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((ZOrderListener)l).orderChanged(diagram);
            ++n2;
        }
    }

    void _sortByOrder(List<IElement> list) {
        List<IElement> elements = this.diagram.getElements();
        final TObjectIntHashMap position = new TObjectIntHashMap();
        for (IElement e : list) {
            position.put((Object)e, elements.indexOf(e));
        }
        Comparator<IElement> c = new Comparator<IElement>(){

            @Override
            public int compare(IElement o1, IElement o2) {
                int pos1 = position.get((Object)o1);
                int pos2 = position.get((Object)o2);
                return pos2 - pos1;
            }
        };
        Collections.sort(list, c);
    }
}

