/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ByteFileReader
implements Closeable {
    final char[] chars = new char[384];
    private final File file;
    private InputStream stream;
    private ReadableByteChannel channel;
    private final ByteBuffer byteBuffer;
    protected final byte[] bytes;
    private int size;
    protected int byteIndex = 0;

    protected final ReadableByteChannel getChannel() {
        return this.channel;
    }

    protected final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    protected final byte[] getBytes() {
        return this.bytes;
    }

    protected final String utf(byte[] bytearr, int index, int target) throws UTFDataFormatException {
        int c;
        int utflen = target - index;
        char[] chararr = utflen > this.chars.length ? new char[utflen] : this.chars;
        int count = index;
        int chararr_count = 0;
        while (count < target) {
            c = bytearr[count] & 0xFF;
            if (c > 127) break;
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        while (count < target) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > target) {
                        throw new UTFDataFormatException("malformed input: partial character at end (" + (count - index) + " > " + utflen + ")");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > target) {
                        throw new UTFDataFormatException("malformed input: partial character at end (" + (count - index) + " > " + utflen + ")");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
            }
        }
        return new String(chararr, 0, chararr_count);
    }

    protected final byte[] safeBytes(int amount) throws IOException {
        byte[] result = new byte[amount];
        int has = this.size - this.byteIndex;
        if (amount >= has) {
            ReadableByteChannel c = this.channel;
            ByteBuffer bb = this.byteBuffer;
            System.arraycopy(this.bytes, this.byteIndex, result, 0, has);
            ByteBuffer bb2 = ByteBuffer.wrap(result);
            bb2.position(has);
            while (has < amount) {
                int todo = Math.min(amount - has, 65536);
                bb2.limit(has + todo);
                int got = c.read(bb2);
                if (got == -1) {
                    throw new IOException("Unexpected end-of-file");
                }
                bb2.position(has += got);
            }
            this.size = c.read(bb);
            bb.position(0);
            this.byteIndex = 0;
        } else {
            System.arraycopy(this.bytes, this.byteIndex, result, 0, amount);
            this.byteIndex += amount;
        }
        return result;
    }

    protected final int getByte() throws IOException {
        int has = this.size - this.byteIndex;
        if (has == 0) {
            ReadableByteChannel c = this.channel;
            ByteBuffer bb = this.byteBuffer;
            this.size = c.read(bb);
            if (this.size == -1) {
                throw new EOFException("Unexpected end-of-file");
            }
            bb.position(0);
            this.byteIndex = 0;
            if (this.size == 0) {
                return -1;
            }
        }
        int result = this.bytes[this.byteIndex++] & 0xFF;
        return result;
    }

    public int getDynamicUInt32() throws IOException {
        int length = this.getByte();
        if (length >= 128) {
            if (length >= 192) {
                if (length >= 224) {
                    if (length >= 240) {
                        length &= 0xF;
                        length += this.getByte() << 3;
                        length += this.getByte() << 11;
                        length += this.getByte() << 19;
                        length += 270549120;
                    } else {
                        length &= 0x1F;
                        length += this.getByte() << 4;
                        length += this.getByte() << 12;
                        length += this.getByte() << 20;
                        length += 2113664;
                    }
                } else {
                    length &= 0x3F;
                    length += this.getByte() << 5;
                    length += this.getByte() << 13;
                    length += 16512;
                }
            } else {
                length &= 0x7F;
                length += this.getByte() << 6;
                length += 128;
            }
        }
        return length;
    }

    protected final int safeInt() throws IOException {
        byte[] bytes = this.bytes;
        if (this.byteIndex >= this.size - 5) {
            int result = 0;
            ReadableByteChannel c = this.channel;
            ByteBuffer bb = this.byteBuffer;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                if (this.size == -1) {
                    throw new EOFException("Unexpected end-of-file");
                }
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= (bytes[this.byteIndex++] & 0xFF) << 24;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                if (this.size == -1) {
                    throw new EOFException("Unexpected end-of-file");
                }
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= (bytes[this.byteIndex++] & 0xFF) << 16;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                if (this.size == -1) {
                    throw new EOFException("Unexpected end-of-file");
                }
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= (bytes[this.byteIndex++] & 0xFF) << 8;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                if (this.size == -1) {
                    throw new EOFException("Unexpected end-of-file");
                }
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= bytes[this.byteIndex++] & 0xFF;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                bb.position(0);
                this.byteIndex = 0;
            }
            return result;
        }
        return (bytes[this.byteIndex++] & 0xFF) << 24 | (bytes[this.byteIndex++] & 0xFF) << 16 | (bytes[this.byteIndex++] & 0xFF) << 8 | bytes[this.byteIndex++] & 0xFF;
    }

    protected final int getSize() {
        return this.size;
    }

    public ByteFileReader(File file, int size) throws IOException {
        this.bytes = new byte[size];
        this.byteBuffer = ByteBuffer.wrap(this.bytes);
        this.file = file;
        FileInputStream fis = new FileInputStream(file);
        this.stream = fis;
        this.channel = fis.getChannel();
        this.size = this.channel.read(this.byteBuffer);
        this.byteBuffer.position(0);
    }

    public ByteFileReader(FileInputStream stream, int size) throws IOException {
        this(stream, stream.getChannel(), size);
    }

    public ByteFileReader(InputStream stream, ReadableByteChannel channel, int size) throws IOException {
        this.bytes = new byte[size];
        this.byteBuffer = ByteBuffer.wrap(this.bytes);
        this.file = null;
        this.stream = stream;
        this.channel = channel;
        this.size = channel.read(this.byteBuffer);
        this.byteBuffer.position(0);
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    public void reset() throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("No file - cannot reset");
        }
        FileInputStream fis = new FileInputStream(this.file);
        this.stream = fis;
        this.channel = fis.getChannel();
        this.size = this.channel.read(this.byteBuffer);
        this.byteBuffer.position(0);
    }
}

