/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.impl.query.UnaryQueryHash;

public class UnaryQueryHashMap<Procedure>
extends UnaryQueryHash<Procedure> {
    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        return capacity;
    }

    public UnaryQuery put(int id, UnaryQuery value) {
        UnaryQuery previous = null;
        int index = this.insertionIndex(id);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._set[index];
            isNewMapping = false;
        }
        UnaryQuery oldKey = this._set[index];
        this._set[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        UnaryQuery[] oldKeys = this._set;
        UnaryQuery[] newKeys = (UnaryQuery[])Array.newInstance(UnaryQuery.class, newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == this.REMOVED) continue;
            UnaryQuery o = oldKeys[i];
            int index = this.insertionIndex2(o.id, newKeys);
            if (index < 0) {
                this.throwObjectContractViolation(newKeys[-index - 1], o);
            }
            newKeys[index] = o;
        }
        this._set = newKeys;
    }

    public final UnaryQuery<Procedure> get(int id) {
        return this.index2(id);
    }

    public Object remove(int id) {
        UnaryQuery prev = null;
        int index = this.index(id);
        if (index >= 0) {
            prev = this._set[index];
            this.removeAt(index);
        }
        return prev;
    }

    public final void values(int level, CacheCollectionResult result) {
        int i = this._set.length;
        while (i-- > 0) {
            UnaryQuery entry = this._set[i];
            if (entry == null || entry == this.REMOVED || entry.getLevel() > level) continue;
            result.add(entry);
        }
    }

    public final ArrayList<CacheEntry> values() {
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
        int i = this._set.length;
        while (i-- > 0) {
            if (this._set[i] == null || this._set[i] == this.REMOVED) continue;
            result.add(this._set[i]);
        }
        return result;
    }
}

