/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import com.kitfox.svg.SVGDiagram;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.scenegraph.utils.MipMapBufferedImage;
import org.simantics.scenegraph.utils.VolatileImageCache;
import org.simantics.scenegraph.utils.VolatileImageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MipMapVRamBufferedImage
extends MipMapBufferedImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MipMapVRamBufferedImage.class);

    public MipMapVRamBufferedImage(SVGDiagram original, Rectangle2D imageBounds, Point referenceSize) {
        super(original, imageBounds, referenceSize);
    }

    @Override
    protected MipMapBufferedImage.IRaster createRaster(double resolution) {
        return new VolatileRaster(resolution);
    }

    @Override
    protected double getRasterRenderingThresholdResolution() {
        return this.maxResolution * 1.5;
    }

    @Override
    protected void setupSourceRender(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
    }

    class VolatileRaster
    extends MipMapBufferedImage.Raster {
        VolatileImageProvider imageProvider;
        int widMargin;
        int heiMargin;
        int wid;
        int hei;
        AtomicInteger validateResult;

        public VolatileRaster(double resolution) {
            super(resolution);
            this.validateResult = new AtomicInteger(0);
            double wid = MipMapVRamBufferedImage.this.imageBounds.getWidth();
            double hei = MipMapVRamBufferedImage.this.imageBounds.getHeight();
            this.wid = (int)(wid * resolution);
            this.hei = (int)(hei * resolution);
            this.widMargin = (int)(wid * resolution * 0.03) + 1;
            this.heiMargin = (int)(hei * resolution * 0.03) + 1;
            this.imageProvider = VolatileImageCache.getInstance().create(this.wid + this.widMargin * 2, this.hei + this.heiMargin * 2);
        }

        private VolatileImage sourceRender(VolatileImage image) {
            Graphics2D target = image.createGraphics();
            target.setBackground(new Color(255, 255, 255, 0));
            target.clearRect(0, 0, image.getWidth(), image.getHeight());
            target.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            target.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            target.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            target.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            target.translate(this.widMargin, this.heiMargin);
            target.scale(this.resolution, this.resolution);
            target.translate(-MipMapVRamBufferedImage.this.imageBounds.getMinX(), -MipMapVRamBufferedImage.this.imageBounds.getMinY());
            try {
                MipMapVRamBufferedImage.this.source.render(target);
            }
            catch (Exception e) {
                e.printStackTrace();
                target.dispose();
                image = null;
                return null;
            }
            target.dispose();
            return image;
        }

        synchronized VolatileImage restore(GraphicsConfiguration gc2) {
            VolatileImage image = this.imageProvider.get(gc2, this.validateResult);
            int validateResult = this.validateResult.get();
            if (image == null) {
                LOGGER.error("BUG: VolatileImageProvider.get returned null!");
                return null;
            }
            boolean contentsLost = validateResult != 0 || image.contentsLost();
            return contentsLost ? this.sourceRender(image) : image;
        }

        @Override
        public void paint(Graphics2D g) {
            VolatileImage image = this.restore(g.getDeviceConfiguration());
            if (image == null) {
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                try {
                    MipMapVRamBufferedImage.this.source.render(g);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            AffineTransform af = g.getTransform();
            Object rh = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            try {
                if (rh == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                g.translate(MipMapVRamBufferedImage.this.imageBounds.getMinX(), MipMapVRamBufferedImage.this.imageBounds.getMinY());
                g.scale(1.0 / this.resolution, 1.0 / this.resolution);
                g.translate(-this.widMargin, -this.heiMargin);
                g.drawImage(image, 0, 0, null);
            }
            finally {
                g.setTransform(af);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, rh);
            }
        }

        @Override
        public void release() {
            this.imageProvider.dispose();
        }
    }
}

