/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GridUtils;

public class RulerNode
extends G2DNode {
    private static final long serialVersionUID = 2490944880914577411L;
    private static final boolean MAP_Y_SCALING = false;
    private static final Color GRAY = new Color(100, 100, 100);
    protected Boolean enabled = true;
    protected double gridSize = 1.0;
    private static final transient int MAX_DIGITS = 5;
    private static final transient double EPSILON = 0.01;
    private static final transient double TRIM_THRESHOLD_MAX_VALUE = Math.pow(10.0, 4.0);
    private static final transient String[] SI_UNIT_LARGE_PREFIXES = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};

    @INode.SyncField(value={"enabled"})
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @INode.SyncField(value={"gridSize"})
    public void setGridSize(double gridSize) {
        if (gridSize < 1.0E-6) {
            gridSize = 1.0E-6;
        }
        this.gridSize = gridSize;
    }

    @Override
    public void render(Graphics2D g) {
        Rectangle2D r;
        FontMetrics fm;
        String str;
        double modifiedValue;
        double val;
        if (!this.enabled.booleanValue()) {
            return;
        }
        AffineTransform tr = g.getTransform();
        double scaleX = Math.abs(tr.getScaleX());
        double scaleY = Math.abs(tr.getScaleY());
        if (scaleX <= 0.0 || scaleY <= 0.0) {
            return;
        }
        double offsetX = tr.getTranslateX();
        double offsetY = tr.getTranslateY();
        g.setTransform(new AffineTransform());
        Font rulerFont = new Font("Tahoma", 0, 9);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(new Color(0.9f, 0.9f, 0.9f, 0.75f));
        Rectangle bounds = g.getClipBounds();
        if (bounds == null) {
            return;
        }
        g.setComposite(AlphaComposite.getInstance(3, 0.8f));
        Rectangle2D.Double vertical = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMinY() + 20.0);
        g.fill(vertical);
        Rectangle2D.Double horizontal = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY() + 20.0, bounds.getMinX() + 20.0, bounds.getMaxY());
        g.fill(horizontal);
        double stepX = 50.0;
        double stepY = 50.0;
        stepX = GridUtils.limitedEvenGridSpacing(stepX, scaleX, 100.0, this.gridSize, true);
        stepY = GridUtils.limitedEvenGridSpacing(stepY, scaleY, 100.0, this.gridSize, true);
        while (stepX * scaleX < 50.0) {
            stepX *= 2.0;
        }
        while (stepY * scaleY < 50.0) {
            stepY *= 2.0;
        }
        stepY *= scaleY;
        g.setColor(GRAY);
        g.setFont(rulerFont);
        double previousText = -100.0;
        double x = offsetX % (stepX *= scaleX) - stepX;
        while (x < bounds.getMaxX()) {
            if (x > 20.0) {
                val = (x - offsetX) / scaleX / this.getTransform().getScaleX();
                modifiedValue = this.modifyHorizontalValue(val);
                str = RulerNode.formatValue(modifiedValue, this.getMaxDigits());
                fm = g.getFontMetrics();
                r = fm.getStringBounds(str, g);
                if (x - r.getWidth() / 2.0 > previousText) {
                    g.setColor(Color.BLACK);
                    g.drawString(str, (int)(x - r.getWidth() / 2.0), (int)(bounds.getMinY() + 1.0 + r.getHeight()));
                    previousText = x + r.getWidth() / 2.0 + stepX / 4.0;
                }
                g.setColor(GRAY);
                g.drawLine((int)x, (int)bounds.getMinY() + 12, (int)x, (int)bounds.getMinY() + 19);
            }
            if (stepX / 5.0 > 2.0) {
                double x2 = x + stepX / 5.0;
                while (x2 < x + stepX) {
                    if (x2 > 20.0) {
                        g.drawLine((int)x2, (int)bounds.getMinY() + 15, (int)x2, (int)bounds.getMinY() + 19);
                    }
                    x2 += stepX / 5.0;
                }
                x2 = x + stepX / 10.0;
                while (x2 < x + stepX) {
                    if (x2 > 20.0) {
                        g.drawLine((int)x2, (int)bounds.getMinY() + 17, (int)x2, (int)bounds.getMinY() + 19);
                    }
                    x2 += stepX / 5.0;
                }
            }
            x += stepX;
        }
        previousText = -100.0;
        double y = offsetY % stepY - stepY;
        while (y < bounds.getMaxY()) {
            if (y > 20.0) {
                val = (y - offsetY) / scaleY / this.getTransform().getScaleY();
                modifiedValue = this.modifyVerticalValue(val);
                str = RulerNode.formatValue(modifiedValue, this.getMaxDigits());
                fm = g.getFontMetrics();
                r = fm.getStringBounds(str, g);
                if (y - 1.0 + r.getHeight() / 2.0 > previousText) {
                    g.setColor(Color.BLACK);
                    AffineTransform origTr = g.getTransform();
                    g.translate((int)bounds.getMinX(), (int)(y + r.getWidth() / 2.0));
                    g.rotate(-1.5707963267948966);
                    g.drawString(str, 0, (int)r.getHeight());
                    g.setTransform(origTr);
                    previousText = y - 1.0 + r.getHeight();
                }
                g.setColor(GRAY);
                g.drawLine((int)bounds.getMinX() + 12, (int)y, (int)bounds.getMinX() + 19, (int)y);
            }
            if (stepY / 5.0 > 2.0) {
                double y2 = y + stepY / 5.0;
                while (y2 < y + stepY) {
                    if (y2 > 20.0) {
                        g.drawLine((int)bounds.getMinX() + 15, (int)y2, (int)bounds.getMinX() + 19, (int)y2);
                    }
                    y2 += stepY / 5.0;
                }
                y2 = y + stepY / 10.0;
                while (y2 < y + stepY) {
                    if (y2 > 20.0) {
                        g.drawLine((int)bounds.getMinX() + 17, (int)y2, (int)bounds.getMinX() + 19, (int)y2);
                    }
                    y2 += stepY / 5.0;
                }
            }
            y += stepY;
        }
        g.setTransform(tr);
    }

    protected double modifyHorizontalValue(double value) {
        return value;
    }

    protected double modifyVerticalValue(double value) {
        return value;
    }

    protected int getMaxDigits() {
        return 5;
    }

    public static String formatValue(double value, int maxDigits) {
        int magnitude = (int)Math.round(Math.log10(value));
        int allowedDecimals = maxDigits;
        if ((allowedDecimals -= Math.abs(magnitude)) < 0) {
            allowedDecimals = 0;
        }
        String valueStr = String.format(Locale.US, "%." + allowedDecimals + "f", value);
        if (allowedDecimals > 0) {
            int dotIndex;
            int trunc = valueStr.length() - 1;
            while (trunc > 0) {
                char ch = valueStr.charAt(trunc);
                if (ch == '.') {
                    valueStr = valueStr.substring(0, trunc);
                    break;
                }
                if (valueStr.charAt(trunc) != '0') {
                    valueStr = valueStr.substring(0, trunc + 1);
                    break;
                }
                --trunc;
            }
            if (Math.abs(value) + 0.01 > TRIM_THRESHOLD_MAX_VALUE && (dotIndex = valueStr.lastIndexOf(46)) > -1) {
                valueStr = valueStr.substring(0, dotIndex);
            }
        }
        double trimValue = value;
        if (Math.abs(value) + 0.01 >= TRIM_THRESHOLD_MAX_VALUE) {
            int i = 0;
            while (Math.abs(trimValue) + 0.01 >= TRIM_THRESHOLD_MAX_VALUE) {
                double trim = trimValue / 1000.0;
                if (Math.abs(trim) - 0.01 < TRIM_THRESHOLD_MAX_VALUE) {
                    valueStr = valueStr.substring(0, valueStr.length() - (i + 1) * 3);
                    valueStr = String.valueOf(valueStr) + SI_UNIT_LARGE_PREFIXES[i];
                    break;
                }
                trimValue = trim;
                ++i;
            }
        }
        if (valueStr.equals("-0")) {
            valueStr = "0";
        }
        return valueStr;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }
}

