/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.InitValueSupport;

public class EdgeNode
extends G2DNode
implements InitValueSupport {
    private static final long serialVersionUID = 1294351381209071074L;
    protected Color color = null;
    protected Stroke stroke = null;
    protected Shape shape = null;
    protected Point2D firstdir = null;
    protected Point2D lastdir = null;
    protected Point2D first = null;
    protected Point2D last = null;
    protected double firstsize = 0.0;
    protected double lastsize = 0.0;
    protected ArrowType first_at = null;
    protected ArrowType last_at = null;
    protected Shape firstShape = null;
    protected Shape lastShape = null;
    private transient Rectangle2D bounds;
    public static final transient GeneralPath NORMAL_ARROW;
    public static final transient GeneralPath FILLED_ARROW;
    public static final transient Stroke ARROW_STROKE;
    protected Composite alphaComposite = null;
    protected Stroke dynamicStroke = null;
    protected Color dynamicColor = null;

    static {
        ARROW_STROKE = new BasicStroke(1.0f);
        FILLED_ARROW = new GeneralPath();
        FILLED_ARROW.moveTo(-0.5f, 1.0f);
        FILLED_ARROW.lineTo(0.0f, 0.0f);
        FILLED_ARROW.lineTo(0.5f, 1.0f);
        FILLED_ARROW.closePath();
        NORMAL_ARROW = new GeneralPath();
        NORMAL_ARROW.moveTo(-0.5f, 1.0f);
        NORMAL_ARROW.lineTo(0.0f, 0.0f);
        NORMAL_ARROW.lineTo(0.5f, 1.0f);
    }

    @INode.SyncField(value={"color", "stroke", "shape", "firstdir", "lastdir", "first", "last", "firstsize", "lastsize", "first_at", "last_at"})
    public void init(Shape shape, Stroke stroke, Color color, Point2D firstdir, Point2D lastdir, Point2D first, Point2D last, double firstsize, double lastsize, ArrowType first_at, ArrowType last_at, Shape firstShape, Shape lastShape) {
        this.color = color;
        this.stroke = stroke;
        this.shape = shape;
        this.firstdir = firstdir;
        this.lastdir = lastdir;
        this.first = first;
        this.last = last;
        this.firstsize = firstsize;
        this.lastsize = lastsize;
        this.first_at = first_at;
        this.last_at = last_at;
        this.firstShape = firstShape;
        this.lastShape = lastShape;
        if (shape != null) {
            this.bounds = shape.getBounds2D();
        }
    }

    @Override
    public void render(Graphics2D g) {
        double theta;
        boolean drawArrows;
        if (this.color != null) {
            g.setColor(this.color);
        }
        if (this.stroke == null || this.shape == null) {
            return;
        }
        if (this.alphaComposite != null) {
            g.setComposite(this.alphaComposite);
        }
        Stroke effectiveStroke = this.stroke;
        if (this.dynamicStroke != null) {
            effectiveStroke = this.dynamicStroke;
        }
        Color effectiveColor = this.color;
        if (this.dynamicColor != null) {
            effectiveColor = this.dynamicColor;
        }
        g.setStroke(effectiveStroke);
        g.setColor(effectiveColor);
        g.setStroke(effectiveStroke);
        g.draw(this.shape);
        boolean bl = drawArrows = this.first_at != ArrowType.None || this.last_at != ArrowType.None;
        if (!drawArrows) {
            return;
        }
        AffineTransform at = g.getTransform();
        g.setStroke(ARROW_STROKE);
        if (this.first_at != ArrowType.None) {
            theta = Math.atan2(this.firstdir.getY(), this.firstdir.getX()) - 1.5707963267948966;
            g.translate(this.first.getX(), this.first.getY());
            g.rotate(theta);
            g.scale(this.firstsize, this.firstsize);
            if (this.first_at == ArrowType.Fill) {
                g.fill(FILLED_ARROW);
            } else if (this.first_at == ArrowType.Stroke) {
                g.draw(NORMAL_ARROW);
            }
            g.setTransform(at);
        }
        if (this.last_at != ArrowType.None) {
            theta = Math.atan2(this.lastdir.getY(), this.lastdir.getX()) - 1.5707963267948966;
            g.translate(this.last.getX(), this.last.getY());
            g.rotate(theta);
            g.scale(this.lastsize, this.lastsize);
            if (this.last_at == ArrowType.Fill) {
                g.fill(FILLED_ARROW);
            } else if (this.last_at == ArrowType.Stroke) {
                g.draw(NORMAL_ARROW);
            }
            g.setTransform(at);
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    @INode.PropertySetter(value="alpha")
    @INode.SyncField(value={"alphaComposite"})
    public void setAlphaComposite(Composite alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    @INode.PropertySetter(value="width")
    @INode.SyncField(value={"dynamicStroke"})
    public void setDynamicStroke(Stroke stroke) {
        this.dynamicStroke = stroke;
    }

    @INode.PropertySetter(value="color")
    @INode.SyncField(value={"dynamicColor"})
    public void setDynamicColor(Color color) {
        this.dynamicColor = color;
    }

    @Override
    public void initValues() {
        this.dynamicStroke = null;
        this.dynamicColor = null;
        this.alphaComposite = null;
    }

    public static enum ArrowType {
        None,
        Stroke,
        Fill,
        Both;

    }
}

