/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.solver;

import gnu.trove.map.TObjectIntMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.Simantics;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.Severity;
import org.simantics.issues.common.CountModelIssuesBySeverity;
import org.simantics.sysdyn.manager.SysdynConsole;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.sysdyn.solver.ISolverMonitor;
import org.simantics.sysdyn.solver.InternalSolver;
import org.simantics.sysdyn.solver.SolverSettings;

public class SysdynSimulationJob
extends Job {
    private static final String pluginId = "unknown";
    protected String name;
    protected SysdynExperiment experiment;
    protected ISolver solver;
    protected ISolverMonitor solverMonitor;

    public SysdynSimulationJob(String name, SysdynExperiment experiment) {
        super(name);
        this.name = name;
        this.experiment = experiment;
        this.solver = null;
        this.solverMonitor = SysdynConsole.INSTANCE;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Simulate " + this.name, 4);
        try {
            this.experiment.sysdynModel.update();
        }
        catch (DatabaseException e) {
            return new Status(4, pluginId, "Could not update model", (Throwable)e);
        }
        try {
            TObjectIntMap severeties = (TObjectIntMap)Simantics.sync((ReadInterface)new CountModelIssuesBySeverity(this.experiment.getModel(), true, Severity.ERROR));
            if (severeties.get((Object)Severity.ERROR) > 0) {
                return new Status(4, pluginId, "There are unresolved errors in the model");
            }
        }
        catch (DatabaseException e) {
            return new Status(4, pluginId, "Could not obtain issue count from model", (Throwable)e);
        }
        SolverSettings.SolverType type = this.experiment.getSolverType();
        if (this.solver == null || !this.solver.getType().equals((Object)type)) {
            if (SolverSettings.SolverType.INTERNAL.equals((Object)type)) {
                this.solver = new InternalSolver(this.experiment, this.experiment.sysdynModel, false, this.solverMonitor);
            } else if (SolverSettings.SolverType.OPENMODELICA.equals((Object)type)) {
                return new Status(4, pluginId, "The experiment should be reloaded");
            }
        }
        try {
            monitor.subTask("generating model...");
            this.solver.initialize();
            monitor.worked(1);
            monitor.subTask("building model...");
            this.solver.buildModel();
            monitor.worked(1);
            monitor.subTask("running solver...");
            this.solver.runSolver();
            monitor.worked(1);
            monitor.subTask("getting results...");
            this.solver.updateResults();
            monitor.worked(1);
        }
        catch (Exception e) {
            return new Status(4, pluginId, "Simulation failed", (Throwable)e);
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

