/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.ui.SpreadsheetTable;

public class SpreadsheetTableUI
extends BasicTableUI {
    @Override
    public void paint(Graphics g, JComponent c) {
        int col1;
        int col0;
        int row1;
        SpreadsheetTable t = (SpreadsheetTable)((Object)this.table);
        ClientModel clientModel = t.getClientModel();
        if (clientModel == null) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point corner0 = new Point(clip.x, clip.y);
        Point corner1 = new Point(new Point(clip.x + clip.width - 1, clip.y + clip.height - 1));
        int row0 = t.rowAtPointWithoutSpan(corner0);
        if (row0 == -1) {
            row0 = 0;
        }
        if ((row1 = t.rowAtPointWithoutSpan(corner1)) == -1) {
            row1 = t.getRowCount() - 1;
        }
        if ((col0 = t.columnAtPointWithoutSpan(corner0)) == -1) {
            col0 = 0;
        }
        if ((col1 = t.columnAtPointWithoutSpan(corner1)) == -1) {
            col1 = t.getColumnCount() - 1;
        }
        int row = row0;
        while (row <= row1) {
            int col = col0;
            while (col <= col1) {
                Rectangle span = clientModel.getSpan(row, col);
                if (span == null) {
                    this.paintCell(row, col, g, t.getCellRect(row, col, true));
                } else if (col == span.x && row == span.y) {
                    this.paintCell(span.y, span.x, g, t.getCellRect(span.y, span.x, true));
                } else if (row == row0 || col == col0) {
                    this.paintCell(span.y, span.x, g, t.getCellRect(span.y, span.x, true));
                }
                ++col;
            }
            ++row;
        }
    }

    private void paintCell(int row, int column, Graphics g, Rectangle rect) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(g, component, this.table, rect.x, rect.y, rect.width, rect.height, false);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SpreadsheetTableUI();
    }
}

