/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties.bar;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.jfreechart.chart.properties.BooleanPropertyFactory;
import org.simantics.jfreechart.chart.properties.BooleanSelectionListener;
import org.simantics.jfreechart.chart.properties.DoublePropertyFactory2;
import org.simantics.jfreechart.chart.properties.DoublePropertyModifier2;
import org.simantics.jfreechart.chart.properties.DoubleValidator;
import org.simantics.jfreechart.chart.properties.JFreeChartPropertyColorProvider;
import org.simantics.jfreechart.chart.properties.TitleFactory;
import org.simantics.jfreechart.chart.properties.TitleModifier;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ui.chart.property.DoublePropertyFactory;
import org.simantics.modeling.ui.chart.property.DoublePropertyModifier;
import org.simantics.sysdyn.JFreeChartResource;

public class BarGeneralPropertiesTab
extends AdjustableTab {
    private ScrolledComposite sc;
    private Button hgrid;
    private Button htitle;
    private Button hlegend;
    private TrackedText name;
    private TrackedText title;
    private TrackedText time;
    private TrackedCombo type;
    private TrackedCombo orientation;
    private boolean showTime = true;
    private boolean showFilter = false;
    private Group general;
    private Composite labelColumn1;
    private Composite propertyColumn1;
    private Composite labelColumn2;
    private Composite propertyColumn2;
    private Label labelName;
    private Label labelTitle;
    private Label labelTime;
    private Label labelType;
    private Group typeGroup;
    private Label labelOrientation;
    private Group hideGroup;
    private Label labelUse;
    private Label labelPercent;
    private Group filteringGroup;
    private Button useFilter;
    private TrackedText fraction;
    private Point size;

    public BarGeneralPropertiesTab(Object id, int options) {
        super(id);
        this.showTime = (options & 1) > 0;
        this.showFilter = (options & 2) > 0;
    }

    @Override
    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.sc = new ScrolledComposite(body, 768);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.composite = new Composite((Composite)this.sc, 0);
        this.general = new Group(this.composite, 0);
        this.general.setText("General");
        this.labelColumn1 = new Composite((Composite)this.general, 0);
        this.propertyColumn1 = new Composite((Composite)this.general, 0);
        this.labelColumn2 = new Composite((Composite)this.general, 0);
        this.propertyColumn2 = new Composite((Composite)this.general, 0);
        this.labelName = new Label(this.labelColumn1, 0);
        this.labelName.setText("Name:");
        this.name = new TrackedText(this.propertyColumn1, support, 2048);
        this.name.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.name.getResourceManager()));
        this.labelTitle = new Label(this.labelColumn2, 0);
        this.labelTitle = new Label(this.propertyColumn2, 0);
        this.labelTitle = new Label(this.labelColumn1, 0);
        this.labelTitle.setText("Title:");
        this.title = new TrackedText(this.propertyColumn1, support, 2048);
        this.title.setTextFactory((ReadFactory)new TitleFactory());
        this.title.addModifyListener((TextModifyListener)new TitleModifier());
        this.title.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.name.getResourceManager()));
        if (this.showTime) {
            this.labelTime = new Label(this.labelColumn2, 0);
            this.labelTime.setText("Time:");
            this.time = new TrackedText(this.propertyColumn2, support, 2048);
            this.time.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/JFreeChart-1.0/Chart/time"));
            this.time.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/JFreeChart-1.0/Chart/time"));
            this.time.setInputValidator((IInputValidator)new DoubleValidator(true));
            this.time.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.time.getResourceManager()));
        }
        this.typeGroup = new Group(this.composite, 0);
        this.typeGroup.setText("Visuals");
        this.labelType = new Label((Composite)this.typeGroup, 0);
        this.labelType.setText("Type:");
        this.type = new TrackedCombo((Composite)this.typeGroup, support, 2056);
        this.type.addModifyListener((TextModifyListener)new TypeModifyListener());
        this.type.setItemFactory((ReadFactory)new TypeItemFactory());
        this.type.setSelectionFactory((ReadFactory)new TypeSelectionFactory());
        this.labelOrientation = new Label((Composite)this.typeGroup, 0);
        this.labelOrientation.setText("Orientation:");
        this.orientation = new TrackedCombo((Composite)this.typeGroup, support, 2056);
        this.orientation.addModifyListener((TextModifyListener)new OrientationModifyListener());
        this.orientation.setItemFactory((ReadFactory)new OrientationItemFactory());
        this.orientation.setSelectionFactory((ReadFactory)new OrientationSelectionFactory());
        this.hideGroup = new Group(this.composite, 0);
        this.hideGroup.setText("Hide");
        this.hgrid = new Button((Composite)this.hideGroup, support, 32);
        this.hgrid.setText("Grid");
        this.hgrid.setSelectionFactory((ReadFactory)new BooleanPropertyFactory("http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Plot/visibleGrid", true));
        this.hgrid.addSelectionListener((SelectionListener)new BooleanSelectionListener(context, "http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Plot/visibleGrid", true));
        this.htitle = new Button((Composite)this.hideGroup, support, 32);
        this.htitle.setText("Title");
        this.htitle.setSelectionFactory((ReadFactory)new BooleanPropertyFactory("http://www.simantics.org/JFreeChart-1.0/TextTitle", "http://www.simantics.org/JFreeChart-1.0/visible", true));
        this.htitle.addSelectionListener((SelectionListener)new BooleanSelectionListener(context, "http://www.simantics.org/JFreeChart-1.0/TextTitle", "http://www.simantics.org/JFreeChart-1.0/visible", true));
        this.hlegend = new Button((Composite)this.hideGroup, support, 32);
        this.hlegend.setText("Legend");
        this.hlegend.setSelectionFactory((ReadFactory)new BooleanPropertyFactory(null, "http://www.simantics.org/JFreeChart-1.0/Chart/visibleLegend", true));
        this.hlegend.addSelectionListener((SelectionListener)new BooleanSelectionListener(context, null, "http://www.simantics.org/JFreeChart-1.0/Chart/visibleLegend", true));
        if (this.showFilter) {
            this.filteringGroup = new Group(this.composite, 0);
            this.filteringGroup.setText("Filter");
            this.labelUse = new Label((Composite)this.filteringGroup, 0);
            this.labelUse.setText("Use:");
            this.useFilter = new Button((Composite)this.filteringGroup, support, 32);
            this.useFilter.setSelectionFactory((ReadFactory)new BooleanPropertyFactory("http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Filter/used", false));
            this.useFilter.addSelectionListener((SelectionListener)new BooleanSelectionListener(context, "http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Filter/used"));
            this.labelPercent = new Label((Composite)this.filteringGroup, 0);
            this.labelPercent.setText("Percent:");
            this.fraction = new TrackedText((Composite)this.filteringGroup, support, 2048);
            this.fraction.setTextFactory((ReadFactory)new DoublePropertyFactory2("http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Filter/fraction"));
            this.fraction.addModifyListener((TextModifyListener)new DoublePropertyModifier2(context, "http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Filter/fraction"));
            this.fraction.setInputValidator((IInputValidator)new DoubleValidator(true));
            this.fraction.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.fraction.getResourceManager()));
        }
        this.sc.setContent((Control)this.composite);
    }

    @Override
    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.sc);
        if (this.showFilter) {
            GridLayoutFactory.fillDefaults().numColumns(1).margins(3, 3).applyTo(this.composite);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(1).margins(3, 3).applyTo(this.composite);
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.general);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.general);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.labelColumn1);
        GridLayoutFactory.fillDefaults().applyTo(this.labelColumn1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.propertyColumn1);
        GridLayoutFactory.fillDefaults().spacing(0, LayoutConstants.getSpacing().y).applyTo(this.propertyColumn1);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.labelColumn2);
        GridLayoutFactory.fillDefaults().spacing(0, LayoutConstants.getSpacing().y).applyTo(this.labelColumn2);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.propertyColumn2);
        GridLayoutFactory.fillDefaults().applyTo(this.propertyColumn2);
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelName);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelTitle);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.title.getWidget());
        if (this.showTime) {
            GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelTime);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.time.getWidget());
        }
        GridDataFactory.fillDefaults().applyTo((Control)this.typeGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.typeGroup);
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelType);
        GridDataFactory.fillDefaults().applyTo((Control)this.type.getWidget());
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelOrientation);
        GridDataFactory.fillDefaults().applyTo((Control)this.type.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.hideGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.hideGroup);
        if (this.showFilter) {
            GridDataFactory.fillDefaults().applyTo((Control)this.filteringGroup);
            GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.filteringGroup);
            GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelUse);
            GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelPercent);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fraction.getWidget());
        }
        this.size = this.composite.computeSize(-1, -1);
        this.sc.setMinSize(this.size);
    }

    @Override
    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.sc);
        if (this.showFilter) {
            GridLayoutFactory.fillDefaults().numColumns(4).margins(3, 3).applyTo(this.composite);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(3).margins(3, 3).applyTo(this.composite);
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.general);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(4).applyTo((Composite)this.general);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.labelColumn1);
        GridLayoutFactory.fillDefaults().applyTo(this.labelColumn1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.propertyColumn1);
        GridLayoutFactory.fillDefaults().spacing(0, LayoutConstants.getSpacing().y).applyTo(this.propertyColumn1);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.labelColumn2);
        GridLayoutFactory.fillDefaults().spacing(0, LayoutConstants.getSpacing().y).applyTo(this.labelColumn2);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.propertyColumn2);
        GridLayoutFactory.fillDefaults().applyTo(this.propertyColumn2);
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelName);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelTitle);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.title.getWidget());
        if (this.showTime) {
            GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelTime);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.time.getWidget());
        }
        GridDataFactory.fillDefaults().applyTo((Control)this.typeGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.typeGroup);
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelType);
        GridDataFactory.fillDefaults().applyTo((Control)this.type.getWidget());
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelOrientation);
        GridDataFactory.fillDefaults().applyTo((Control)this.type.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.hideGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.hideGroup);
        if (this.showFilter) {
            GridDataFactory.fillDefaults().applyTo((Control)this.filteringGroup);
            GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.filteringGroup);
            GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelUse);
            GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)this.labelPercent);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fraction.getWidget());
        }
        this.size = this.composite.computeSize(-1, -1);
        this.sc.setMinSize(this.size);
    }

    private class OrientationItemFactory
    extends ReadFactoryImpl<Resource, Map<String, Object>> {
        private OrientationItemFactory() {
        }

        public Map<String, Object> perform(ReadGraph graph, Resource series) throws DatabaseException {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("Vertical", "Vertical");
            result.put("Horizontal", "Horizontal");
            return result;
        }
    }

    private class OrientationModifyListener
    extends ComboModifyListenerImpl<Resource> {
        private OrientationModifyListener() {
        }

        public void applyText(WriteGraph graph, Resource chart, String text) throws DatabaseException {
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.CategoryPlot));
            if (plot == null) {
                return;
            }
            if (text.equals("Horizontal")) {
                graph.claimLiteral(plot, jfree.Plot_orientation, (Object)true);
            } else {
                graph.claimLiteral(plot, jfree.Plot_orientation, (Object)false);
            }
        }
    }

    private class OrientationSelectionFactory
    extends ReadFactoryImpl<Resource, String> {
        private OrientationSelectionFactory() {
        }

        public String perform(ReadGraph graph, Resource chart) throws DatabaseException {
            Boolean orientation;
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.CategoryPlot));
            if (plot != null && (orientation = (Boolean)graph.getPossibleRelatedValue(plot, jfree.Plot_orientation)) != null) {
                if (orientation.booleanValue()) {
                    return "Horizontal";
                }
                return "Vertical";
            }
            return "Vertical";
        }
    }

    private class TypeItemFactory
    extends ReadFactoryImpl<Resource, Map<String, Object>> {
        private TypeItemFactory() {
        }

        public Map<String, Object> perform(ReadGraph graph, Resource series) throws DatabaseException {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("Normal", "Normal");
            result.put("Stacked", "Stacked");
            return result;
        }
    }

    private class TypeModifyListener
    extends ComboModifyListenerImpl<Resource> {
        private TypeModifyListener() {
        }

        public void applyText(WriteGraph graph, Resource chart, String text) throws DatabaseException {
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.CategoryPlot));
            if (plot == null) {
                return;
            }
            Resource dataset = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(plot, l0.ConsistsOf, jfree.CategoryDataset));
            if (dataset == null) {
                return;
            }
            graph.deny(dataset, jfree.Dataset_renderer);
            Resource renderer = text.equals("Stacked") ? GraphUtils.create2((WriteGraph)graph, (Resource)jfree.StackedBarRenderer, (Object[])new Object[0]) : GraphUtils.create2((WriteGraph)graph, (Resource)jfree.BarRenderer, (Object[])new Object[0]);
            graph.claim(dataset, jfree.Dataset_renderer, renderer);
        }
    }

    private class TypeSelectionFactory
    extends ReadFactoryImpl<Resource, String> {
        private TypeSelectionFactory() {
        }

        public String perform(ReadGraph graph, Resource chart) throws DatabaseException {
            Resource renderer;
            Resource dataset;
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.CategoryPlot));
            if (plot != null && (dataset = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(plot, l0.ConsistsOf, jfree.CategoryDataset))) != null && (renderer = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(dataset, jfree.Dataset_renderer, jfree.Renderer))) != null && graph.isInstanceOf(renderer, jfree.StackedBarRenderer)) {
                return "Stacked";
            }
            return "Normal";
        }
    }
}

